/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.fileAssociationsWindows;

import com.jetbrains.toolbox.feed.FileAssociationsSupport;
import com.jetbrains.toolbox.fileAssociationsWindows.UtilKt;
import com.jetbrains.toolbox.fileAssociationsWindows.WindowsAssociations;
import com.jetbrains.toolbox.fileAssociationsWindows.WindowsAssociationsRefreshHandler;
import com.jetbrains.toolbox.fileAssociationsWindows.WindowsFileAssociationsUpdaterKt;
import com.jetbrains.toolbox.fileAssociationsWindows.WindowsProgIdChannelExtension;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.tools.ExtensionsKt;
import com.jetbrains.toolbox.tools.model.InstalledToolKt;
import com.jetbrains.toolbox.tools.model.OsIntegration;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.ToolRefreshHandler;
import java.util.Set;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class WindowsAssociationsRefreshHandler
implements OsIntegration,
ToolRefreshHandler {
    @NotNull
    private final WindowsAssociations windowsAssociations;
    @NotNull
    private final StateFlow<SelfSettings> settings;

    public WindowsAssociationsRefreshHandler(@NotNull WindowsAssociations windowsAssociations, @NotNull StateFlow<SelfSettings> settings2) {
        Intrinsics.checkNotNullParameter((Object)windowsAssociations, (String)"windowsAssociations");
        Intrinsics.checkNotNullParameter(settings2, (String)"settings");
        this.windowsAssociations = windowsAssociations;
        this.settings = settings2;
    }

    @Override
    @Nullable
    public Object onRefresh(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super ToolInstance> $completion) {
        WindowsProgIdChannelExtension windowsProgIdChannelExtension = UtilKt.getWindowsProgIdChannelExtension(toolInstance.getChannel());
        String progId = windowsProgIdChannelExtension != null ? windowsProgIdChannelExtension.getValue() : null;
        Path command2 = ExtensionsKt.getLaunchCommand(toolInstance);
        if (progId == null) {
            Logger.INSTANCE.warn("Can't find windowsProgIdChannelExtension, it should be already generated, skipping file associations ensuring");
        } else {
            FileAssociationsSupport fileAssociationsSupport = toolInstance.getTool().getFileAssociationsSupport();
            FileAssociationsSupport fileAssociationsSupport2 = toolInstance.getTool().getFileAssociationsSupport();
            WindowsFileAssociationsUpdaterKt.ensureAppAndAssociationsRegistered(this.windowsAssociations, ((SelfSettings)this.settings.getValue()).getTools().getCreateFileAssociations(), progId, command2, toolInstance.getChannel().getInstallationDirectory(), Boxing.boxBoolean((toolInstance.getTool().getFileAssociationsSupport() != null ? 1 : 0) != 0), fileAssociationsSupport != null ? fileAssociationsSupport.getExtensionsWithoutDot() : null, fileAssociationsSupport2 != null ? fileAssociationsSupport2.getNonStandardArgsForFileOpening() : null, InstalledToolKt.displayNameWithVersion(toolInstance.getChannel(), toolInstance.getTool()), (Function0<? extends Set<String>>)((Function0)onRefresh.2.INSTANCE), (Function0<Boolean>)((Function0)WindowsAssociationsRefreshHandler::onRefresh$lambda$0));
        }
        return toolInstance;
    }

    private static final boolean onRefresh$lambda$0() {
        return false;
    }
}

