/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.fileAssociationsWindows;

import com.jetbrains.toolbox.fileAssociationsWindows.OpenableAppRegistration;
import com.jetbrains.toolbox.fileAssociationsWindows.WindowsAssociations;
import com.jetbrains.toolbox.interop.Win32Registry;
import com.jetbrains.toolbox.interop.Win32Shell32;
import com.sun.jna.Pointer;
import java.io.FileNotFoundException;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class WindowsAssociationsImpl
implements WindowsAssociations {
    @NotNull
    private final Win32Registry win32Registry;
    @NotNull
    private final Win32Shell32 win32Shell32;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final List<String> defaultArgs;

    public WindowsAssociationsImpl(@NotNull Win32Registry win32Registry, @NotNull Win32Shell32 win32Shell32, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)win32Registry, (String)"win32Registry");
        Intrinsics.checkNotNullParameter((Object)win32Shell32, (String)"win32Shell32");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.win32Registry = win32Registry;
        this.win32Shell32 = win32Shell32;
        this.fileSystem = fileSystem;
        this.defaultArgs = CollectionsKt.listOf((Object)"%1");
    }

    @Override
    public void registerOpenableApp(@NotNull String progId, @NotNull Path exePath, @Nullable List<String> args, @NotNull String friendlyAppName) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)progId, (String)"progId");
        Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
        Intrinsics.checkNotNullParameter((Object)friendlyAppName, (String)"friendlyAppName");
        try {
            path2 = this.fileSystem.canonicalize(exePath);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.INSTANCE.warn("Cannot register app " + exePath + " because it doesn't exist");
            return;
        }
        Path exeAbsolutePath = path2;
        String command2 = "\"" + exeAbsolutePath + "\" " + this.createArgsString$file_associations_windows(args);
        Win32Registry.writeValue$default(this.win32Registry, Win32Registry.Hive.HKCU.INSTANCE, "SOFTWARE\\Classes\\" + progId + "\\shell\\open\\command", "", command2, false, 16, null);
        Win32Registry.writeValue$default(this.win32Registry, Win32Registry.Hive.HKCU.INSTANCE, "SOFTWARE\\Classes\\Applications\\" + progId + "\\shell\\open\\command", "", command2, false, 16, null);
        Win32Registry.writeValue$default(this.win32Registry, Win32Registry.Hive.HKCU.INSTANCE, "SOFTWARE\\Classes\\" + progId, "FriendlyAppName", friendlyAppName, false, 16, null);
        Win32Registry.writeValue$default(this.win32Registry, Win32Registry.Hive.HKCU.INSTANCE, "SOFTWARE\\Classes\\" + progId + "\\shell\\open", "FriendlyAppName", friendlyAppName, false, 16, null);
        Win32Registry.writeValue$default(this.win32Registry, Win32Registry.Hive.HKCU.INSTANCE, "SOFTWARE\\Classes\\Applications\\" + progId, "FriendlyAppName", friendlyAppName, false, 16, null);
        Win32Registry.writeValue$default(this.win32Registry, Win32Registry.Hive.HKCU.INSTANCE, "SOFTWARE\\Classes\\Applications\\" + progId + "\\shell\\open", "FriendlyAppName", friendlyAppName, false, 16, null);
    }

    @Override
    @NotNull
    public OpenableAppRegistration checkOpenableApp(@NotNull String progId, @NotNull Path exePath, @Nullable List<String> args, @NotNull String friendlyAppName) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)progId, (String)"progId");
        Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
        Intrinsics.checkNotNullParameter((Object)friendlyAppName, (String)"friendlyAppName");
        int existingProgIdEntriesCount = WindowsAssociationsImpl.checkOpenableApp$toInt(Win32Registry.listKeys$default(this.win32Registry, Win32Registry.Hive.HKCU.INSTANCE, "SOFTWARE\\Classes", false, 4, null).contains(progId)) + WindowsAssociationsImpl.checkOpenableApp$toInt(Win32Registry.listKeys$default(this.win32Registry, Win32Registry.Hive.HKCU.INSTANCE, "SOFTWARE\\Classes\\Applications", false, 4, null).contains(progId));
        switch (existingProgIdEntriesCount) {
            case 0: {
                return OpenableAppRegistration.NOT_REGISTERED_AT_ALL;
            }
            case 1: {
                return OpenableAppRegistration.PARTIAL;
            }
        }
        try {
            path2 = this.fileSystem.canonicalize(exePath);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return OpenableAppRegistration.NOT_REGISTERED_AT_ALL;
        }
        Path exeAbsolutePath = path2;
        String command2 = "\"" + exeAbsolutePath + "\" " + this.createArgsString$file_associations_windows(args);
        if (!Intrinsics.areEqual((Object)Win32Registry.readValue$default(this.win32Registry, Win32Registry.Hive.HKCU.INSTANCE, "SOFTWARE\\Classes\\" + progId + "\\shell\\open\\command", "", false, 8, null), (Object)command2)) {
            return OpenableAppRegistration.PARTIAL;
        }
        if (!Intrinsics.areEqual((Object)Win32Registry.readValue$default(this.win32Registry, Win32Registry.Hive.HKCU.INSTANCE, "SOFTWARE\\Classes\\Applications\\" + progId + "\\shell\\open\\command", "", false, 8, null), (Object)command2)) {
            return OpenableAppRegistration.PARTIAL;
        }
        if (!Intrinsics.areEqual((Object)Win32Registry.readValue$default(this.win32Registry, Win32Registry.Hive.HKCU.INSTANCE, "SOFTWARE\\Classes\\" + progId, "FriendlyAppName", false, 8, null), (Object)friendlyAppName)) {
            return OpenableAppRegistration.PARTIAL;
        }
        if (!Intrinsics.areEqual((Object)Win32Registry.readValue$default(this.win32Registry, Win32Registry.Hive.HKCU.INSTANCE, "SOFTWARE\\Classes\\" + progId + "\\shell\\open", "FriendlyAppName", false, 8, null), (Object)friendlyAppName)) {
            return OpenableAppRegistration.PARTIAL;
        }
        if (!Intrinsics.areEqual((Object)Win32Registry.readValue$default(this.win32Registry, Win32Registry.Hive.HKCU.INSTANCE, "SOFTWARE\\Classes\\Applications\\" + progId, "FriendlyAppName", false, 8, null), (Object)friendlyAppName)) {
            return OpenableAppRegistration.PARTIAL;
        }
        if (!Intrinsics.areEqual((Object)Win32Registry.readValue$default(this.win32Registry, Win32Registry.Hive.HKCU.INSTANCE, "SOFTWARE\\Classes\\Applications\\" + progId + "\\shell\\open", "FriendlyAppName", false, 8, null), (Object)friendlyAppName)) {
            return OpenableAppRegistration.PARTIAL;
        }
        return OpenableAppRegistration.FULL;
    }

    @Override
    public void deregisterOpenableApp(@NotNull String progId) {
        Intrinsics.checkNotNullParameter((Object)progId, (String)"progId");
        this.win32Registry.deleteKeyRecursively(Win32Registry.Hive.HKCU.INSTANCE, "SOFTWARE\\Classes\\Applications\\" + progId);
        this.win32Registry.deleteKeyRecursively(Win32Registry.Hive.HKCU.INSTANCE, "SOFTWARE\\Classes\\" + progId);
    }

    @Override
    public void addAppToExtensionHandlers(@NotNull String progId, @NotNull String extensionWithoutDot) {
        Intrinsics.checkNotNullParameter((Object)progId, (String)"progId");
        Intrinsics.checkNotNullParameter((Object)extensionWithoutDot, (String)"extensionWithoutDot");
        Win32Registry.writeValue$default(this.win32Registry, Win32Registry.Hive.HKCU.INSTANCE, "SOFTWARE\\Classes\\." + extensionWithoutDot + "\\OpenWithProgids", progId, "", false, 16, null);
    }

    @Override
    public boolean checkExtensionHandler(@NotNull String progId, @NotNull String extensionWithoutDot) {
        Intrinsics.checkNotNullParameter((Object)progId, (String)"progId");
        Intrinsics.checkNotNullParameter((Object)extensionWithoutDot, (String)"extensionWithoutDot");
        return Win32Registry.readValue$default(this.win32Registry, Win32Registry.Hive.HKCU.INSTANCE, "SOFTWARE\\Classes\\." + extensionWithoutDot + "\\OpenWithProgids", progId, false, 8, null) != null;
    }

    @Override
    public void removeAppFromExtensionHandlers(@NotNull String progId, @NotNull String extensionWithoutDot) {
        Intrinsics.checkNotNullParameter((Object)progId, (String)"progId");
        Intrinsics.checkNotNullParameter((Object)extensionWithoutDot, (String)"extensionWithoutDot");
        this.win32Registry.deleteValue(Win32Registry.Hive.HKCU.INSTANCE, "SOFTWARE\\Classes\\." + extensionWithoutDot + "\\OpenWithProgids", progId);
    }

    @Override
    public void notifyShellAboutChangedAssociations() {
        Pointer nullptr = Pointer.createConstant((int)0);
        Intrinsics.checkNotNull((Object)nullptr);
        this.win32Shell32.SHChangeNotify(0x8000000, 0, nullptr, nullptr);
    }

    @NotNull
    public final String createArgsString$file_associations_windows(@Nullable List<String> args) {
        List<String> list2 = args;
        if (list2 == null) {
            list2 = this.defaultArgs;
        }
        return CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)" ", null, null, (int)0, null, WindowsAssociationsImpl::createArgsString$lambda$0, (int)30, null);
    }

    private static final int checkOpenableApp$toInt(boolean $this$checkOpenableApp_u24toInt) {
        return $this$checkOpenableApp_u24toInt ? 1 : 0;
    }

    private static final CharSequence createArgsString$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\"" + it + "\"";
    }
}

