/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feedjet;

import com.jetbrains.toolbox.Notifications;
import com.jetbrains.toolbox.UIGlobalState;
import com.jetbrains.toolbox.UIModalState;
import com.jetbrains.toolbox.accounts.GoogleAccount;
import com.jetbrains.toolbox.accounts.GoogleAccountProvider;
import com.jetbrains.toolbox.accounts.JetBrainsAccount;
import com.jetbrains.toolbox.accounts.JetBrainsAccountProvider;
import com.jetbrains.toolbox.common.extensions.URIExtensionsKt;
import com.jetbrains.toolbox.feed.ApplicationFeedJSONLoader;
import com.jetbrains.toolbox.feed.ApplicationMajorVersionKt;
import com.jetbrains.toolbox.feed.ApplicationPackage;
import com.jetbrains.toolbox.feed.DataPiecesKt;
import com.jetbrains.toolbox.feed.FeedV1Json;
import com.jetbrains.toolbox.feed.RemoteFeedItem;
import com.jetbrains.toolbox.feedjet.FeedjetManager;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import com.jetbrains.toolbox.network.DownloadManager;
import com.jetbrains.toolbox.network.DownloadSession;
import com.jetbrains.toolbox.network.DownloadSessionUtilKt;
import com.jetbrains.toolbox.platform.image.internal.ImageId;
import com.jetbrains.toolbox.protocolhandler.ProtocolHandler;
import com.jetbrains.toolbox.tools.image.ImageManager;
import com.jetbrains.toolbox.tools.model.ToolBuild;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nFeedjetManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeedjetManager.kt\ncom/jetbrains/toolbox/feedjet/FeedjetManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
public final class FeedjetManager
implements ProtocolHandler {
    @NotNull
    private final DownloadManager downloadManager;
    @NotNull
    private final Notifications notifications;
    @NotNull
    private final ApplicationFeedJSONLoader applicationFeedJSONLoader;
    @NotNull
    private final ImageManager imageManager;
    @NotNull
    private final UIGlobalState uiGlobalState;
    @NotNull
    private final I18n i18n;
    @NotNull
    private final JetBrainsAccountProvider jetBrainsAccountProvider;
    @NotNull
    private final GoogleAccountProvider googleAccountProvider;
    private final boolean impliesUiMode;

    public FeedjetManager(@NotNull DownloadManager downloadManager, @NotNull Notifications notifications, @NotNull ApplicationFeedJSONLoader applicationFeedJSONLoader, @NotNull ImageManager imageManager, @NotNull UIGlobalState uiGlobalState, @NotNull I18n i18n, @NotNull JetBrainsAccountProvider jetBrainsAccountProvider, @NotNull GoogleAccountProvider googleAccountProvider) {
        Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkNotNullParameter((Object)notifications, (String)"notifications");
        Intrinsics.checkNotNullParameter((Object)applicationFeedJSONLoader, (String)"applicationFeedJSONLoader");
        Intrinsics.checkNotNullParameter((Object)imageManager, (String)"imageManager");
        Intrinsics.checkNotNullParameter((Object)uiGlobalState, (String)"uiGlobalState");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        Intrinsics.checkNotNullParameter((Object)jetBrainsAccountProvider, (String)"jetBrainsAccountProvider");
        Intrinsics.checkNotNullParameter((Object)googleAccountProvider, (String)"googleAccountProvider");
        this.downloadManager = downloadManager;
        this.notifications = notifications;
        this.applicationFeedJSONLoader = applicationFeedJSONLoader;
        this.imageManager = imageManager;
        this.uiGlobalState = uiGlobalState;
        this.i18n = i18n;
        this.jetBrainsAccountProvider = jetBrainsAccountProvider;
        this.googleAccountProvider = googleAccountProvider;
        this.impliesUiMode = true;
    }

    @Override
    @Nullable
    public Object canHandle(@NotNull URI uri, @NotNull Continuation<? super Boolean> $completion) {
        if (Intrinsics.areEqual((Object)uri.getHost(), (Object)"toolbox")) {
            String string = uri.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (StringsKt.startsWith$default((String)string, (String)"/feedjet", (boolean)false, (int)2, null)) {
                JetBrainsAccount jetBrainsAccount2 = (JetBrainsAccount)this.jetBrainsAccountProvider.getActiveAccount().getValue();
                boolean bl = jetBrainsAccount2 != null ? jetBrainsAccount2.isInternal() : false;
                if (bl) {
                    return Boxing.boxBoolean((boolean)true);
                }
                Logger.INSTANCE.warn("Feedjet is available only for internal JetBrains users");
            }
        }
        return Boxing.boxBoolean((boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Nullable
    public Object handle(@NotNull URI uri, @NotNull Continuation<? super Unit> $completion) {
        block32: {
            block31: {
                if (!($completion instanceof handle.1)) ** GOTO lbl-1000
                var23_3 = $completion;
                if ((var23_3.label & -2147483648) != 0) {
                    var23_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        Object L$5;
                        Object L$6;
                        int I$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ FeedjetManager this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.handle(null, (Continuation<? super Unit>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var24_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        googleAccount = (GoogleAccount)CollectionsKt.singleOrNull((List)((List)this.googleAccountProvider.getAccounts().getValue()));
                        if (googleAccount == null || googleAccount.getExpired()) {
                            Logger.INSTANCE.info("No Google account found for feedjet. Going to request one");
                            GoogleAccountProvider.initiateLogin$default(this.googleAccountProvider, null, (Function1)new Function1<Continuation<? super Unit>, Object>(this, uri, null){
                                int label;
                                final /* synthetic */ FeedjetManager this$0;
                                final /* synthetic */ URI $uri;
                                {
                                    this.this$0 = $receiver;
                                    this.$uri = $uri;
                                    super(1, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Logger.INSTANCE.info("Account was provided. Repeating feedjet discovery");
                                            this.label = 1;
                                            Object object2 = this.this$0.handle(this.$uri, (Continuation<? super Unit>)((Continuation)this));
                                            if (object2 != object) return Unit.INSTANCE;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(Continuation<? super Unit> p1) {
                                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                            return Unit.INSTANCE;
                        }
                        v0 = URIExtensionsKt.parseQuery(uri).get("url");
                        if (v0 == null) {
                            return Unit.INSTANCE;
                        }
                        url = v0;
                        Logger.INSTANCE.info("Processing feedjet from url " + url);
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)uri);
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)googleAccount);
                        $continuation.L$2 = url;
                        $continuation.label = 1;
                        v1 = this.downloadManager.createSession((Continuation<? super DownloadSession>)$continuation);
                        if (v1 == var24_5) {
                            return var24_5;
                        }
                        ** GOTO lbl37
                    }
                    case 1: {
                        url = (String)$continuation.L$2;
                        googleAccount = (GoogleAccount)$continuation.L$1;
                        uri = (URI)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl37:
                        // 2 sources

                        session = (DownloadSession)v1;
                        request = new Request.Builder().get().url(url).build();
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)uri);
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)googleAccount);
                        $continuation.L$2 = url;
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)session);
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)request);
                        $continuation.label = 2;
                        v2 = DownloadSessionUtilKt.await(session.getHttpClient().newCall(request), (Continuation<? super Response>)$continuation);
                        if (v2 == var24_5) {
                            return var24_5;
                        }
                        ** GOTO lbl57
                    }
                    case 2: {
                        request = (Request)$continuation.L$4;
                        session = (DownloadSession)$continuation.L$3;
                        url = (String)$continuation.L$2;
                        googleAccount = (GoogleAccount)$continuation.L$1;
                        uri = (URI)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl57:
                        // 2 sources

                        if ((response = (Response)v2).isSuccessful()) break;
                        Logger.INSTANCE.warn("Unable to download feed from " + url + ": " + response.message());
                        if (!Intrinsics.areEqual((Object)response.message(), (Object)"Failed to authenticate with proxy")) {
                            var8_30 = new Pair[]{TuplesKt.to((Object)"errorMessage", (Object)response.message())};
                            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)uri);
                            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)googleAccount);
                            $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)url);
                            $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)session);
                            $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)request);
                            $continuation.L$5 = response;
                            $continuation.label = 3;
                            v3 = this.notifications.showErrorMessage(this.i18n.tr("Cannot download package description: {{errorMessage}}", var8_30), (Continuation<? super Unit>)$continuation);
                            if (v3 == var24_5) {
                                return var24_5;
                            }
                        }
                        ** GOTO lbl81
                    }
                    case 3: {
                        response = (Response)$continuation.L$5;
                        request = (Request)$continuation.L$4;
                        session = (DownloadSession)$continuation.L$3;
                        url = (String)$continuation.L$2;
                        googleAccount = (GoogleAccount)$continuation.L$1;
                        uri = (URI)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl81:
                        // 2 sources

                        response.close();
                        return Unit.INSTANCE;
                    }
                }
                Logger.INSTANCE.debug("Downloaded feed " + url);
                try {
                    v4 /* !! */  = response.body();
                    if (v4 /* !! */  != null && (v4 /* !! */  = v4 /* !! */ .byteStream()) != null) {
                        var11_34 = v4 /* !! */ ;
                        var12_35 = null;
                        try {
                            it = (InputStream)var11_34;
                            $i$a$-use-FeedjetManager$handle$result$1 = false;
                            it = ApplicationFeedJSONLoader.parse$default(this.applicationFeedJSONLoader, url, (InputStream)it, null, 4, null);
                            v5 = it;
                        }
                        catch (Throwable var14_38) {
                            var12_35 = var14_38;
                            throw var14_38;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)var11_34, (Throwable)var12_35);
                        }
                    } else {
                        v5 = null;
                    }
                    var9_40 = v5;
                }
                catch (Throwable t) {
                    Logger.INSTANCE.warn(t, "Unable to parse feed from " + url);
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)uri);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)googleAccount);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)url);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)session);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)request);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)response);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)t);
                    $continuation.label = 4;
                    v6 = this.notifications.showErrorMessage(this.i18n.tr("Cannot read package description"), (Continuation<? super Unit>)$continuation);
                    if (v6 == var24_5) {
                        return var24_5;
                    }
                    ** GOTO lbl130
                }
                {
                    case 4: {
                        t = (Throwable)$continuation.L$6;
                        response = (Response)$continuation.L$5;
                        request = (Request)$continuation.L$4;
                        session = (DownloadSession)$continuation.L$3;
                        url = (String)$continuation.L$2;
                        googleAccount = (GoogleAccount)$continuation.L$1;
                        uri = (URI)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl130:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                result = var9_40;
                if (result != null) break block31;
                Logger.INSTANCE.warn("Response body is null for " + url);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)uri);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)googleAccount);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)url);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)session);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)response);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)result);
                $continuation.label = 5;
                v7 = this.notifications.showErrorMessage(this.i18n.tr("Response body is null for " + url), (Continuation<? super Unit>)$continuation);
                if (v7 == var24_5) {
                    return var24_5;
                }
                ** GOTO lbl156
                {
                    case 5: {
                        result = (FeedV1Json)$continuation.L$6;
                        response = (Response)$continuation.L$5;
                        request = (Request)$continuation.L$4;
                        session = (DownloadSession)$continuation.L$3;
                        url = (String)$continuation.L$2;
                        googleAccount = (GoogleAccount)$continuation.L$1;
                        uri = (URI)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl156:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
            }
            count = ((Collection)result.getFeedItems()).size();
            Logger.INSTANCE.info("Found " + count + " feed items in feedjet " + url);
            Logger.INSTANCE.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, handle$lambda$1(com.jetbrains.toolbox.feed.FeedV1Json ), ()Ljava/lang/String;)((FeedV1Json)result));
            if (count == 1) break block32;
            Logger.INSTANCE.warn("Expected exactly ONE feed item in feedjet. Got: " + count);
            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)uri);
            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)googleAccount);
            $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)url);
            $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)session);
            $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)request);
            $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)response);
            $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)result);
            $continuation.I$0 = count;
            $continuation.label = 6;
            v8 = this.notifications.showErrorMessage(this.i18n.tr("Wrong feedjet file format, expected exactly one item but got " + count), (Continuation<? super Unit>)$continuation);
            if (v8 == var24_5) {
                return var24_5;
            }
            ** GOTO lbl187
            {
                case 6: {
                    count = $continuation.I$0;
                    result = (FeedV1Json)$continuation.L$6;
                    response = (Response)$continuation.L$5;
                    request = (Request)$continuation.L$4;
                    session = (DownloadSession)$continuation.L$3;
                    url = (String)$continuation.L$2;
                    googleAccount = (GoogleAccount)$continuation.L$1;
                    uri = (URI)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v8 = $result;
lbl187:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
        }
        feedItem = (RemoteFeedItem)CollectionsKt.first(result.getFeedItems());
        newUrl = StringsKt.substringBeforeLast$default((String)url, (String)":", null, (int)2, null) + ":id/" + StringsKt.substringBefore$default((String)StringsKt.substringAfterLast$default((String)feedItem.getPackage().getUrl(), (String)"/", null, (int)2, null), (String)"?", null, (int)2, null);
        newFeedItem = RemoteFeedItem.copy-fnwMO8k$default(feedItem, null, null, null, null, null, 0, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, ApplicationPackage.copy$default(feedItem.getPackage(), null, null, newUrl, 0L, null, null, 0, null, null, null, null, null, 4091, null), null, null, null, null, null, null, null, null, false, -67108865, 15, null);
        Logger.INSTANCE.info("Asking user permission to install" + newFeedItem.getPresentableFullNameAndVersionAndBuild());
        v9 = ToolBuild.Companion;
        v10 = newFeedItem;
        v11 = newFeedItem.getIcon-fijqFwY();
        if (v11 != null) {
            var15_46 = v11;
            var16_47 = this.imageManager;
            var17_48 = var15_46;
            var20_49 = v10;
            var19_50 = v9;
            $i$a$-let-FeedjetManager$handle$toolBuild$1 = false;
            v12 = var16_47.convert-AuLSNLU((String)p0);
            var21_52 = v12 != null ? ImageId.box-impl((String)v12) : null;
            v9 = var19_50;
            v10 = var20_49;
            v13 = var21_52;
            v14 = v13 != null ? v13.unbox-impl() : null;
        } else {
            v14 = null;
        }
        toolBuild = v9.of-QT3uPOY(v10, v14, DataPiecesKt.getDefaultApplicationQuality(), ApplicationMajorVersionKt.getMaxApplicationMajorVersion());
        this.uiGlobalState.updateState((Function1<? super UIModalState, ? extends UIModalState>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, handle$lambda$2(com.jetbrains.toolbox.tools.model.ToolBuild com.jetbrains.toolbox.UIModalState ), (Lcom/jetbrains/toolbox/UIModalState;)Lcom/jetbrains/toolbox/UIModalState;)((ToolBuild)toolBuild));
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public boolean getImpliesUiMode() {
        return this.impliesUiMode;
    }

    private static final String handle$lambda$1(FeedV1Json $result) {
        return CollectionsKt.joinToString$default((Iterable)$result.getFeedItems(), (CharSequence)"\n", (CharSequence)"Feed items in feedjet: [", (CharSequence)"]", (int)0, null, FeedjetManager::handle$lambda$1$0, (int)24, null);
    }

    private static final CharSequence handle$lambda$1$0(RemoteFeedItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPresentableFullNameAndVersionAndBuild();
    }

    private static final UIModalState handle$lambda$2(ToolBuild $toolBuild, UIModalState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof UIModalState.Normal ? (UIModalState)new UIModalState.FeedjetItem($toolBuild, false, 2, null) : it;
    }
}

