/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feed;

import com.jetbrains.toolbox.feed.SubstituteKt;
import com.jetbrains.toolbox.feed.TokenPart;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nsubstitute.kt\nKotlin\n*S Kotlin\n*F\n+ 1 substitute.kt\ncom/jetbrains/toolbox/feed/Tokenizer\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,93:1\n1179#2,2:94\n*S KotlinDebug\n*F\n+ 1 substitute.kt\ncom/jetbrains/toolbox/feed/Tokenizer\n*L\n35#1:94,2\n*E\n"})
final class Tokenizer {
    @NotNull
    private List<List<TokenPart>> tokens = new ArrayList();
    @NotNull
    private List<TokenPart> tokenParts = new ArrayList();
    @NotNull
    private StringBuilder tokenPartBuilder = new StringBuilder();
    private boolean escaped;
    private boolean quoted;

    @NotNull
    public final List<List<TokenPart>> getTokens() {
        return this.tokens;
    }

    public final void feed(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        CharSequence $this$forEach$iv = s;
        boolean $i$f$forEach = false;
        for (int j = 0; j < $this$forEach$iv.length(); ++j) {
            char element$iv;
            char it = element$iv = $this$forEach$iv.charAt(j);
            boolean bl = false;
            this.feed(it);
        }
        this.flushToken();
    }

    private final void feed(char c) {
        if (this.escaped) {
            this.tokenPartBuilder.append(c);
            this.escaped = false;
            return;
        }
        if (c == '\\') {
            this.escaped = true;
            return;
        }
        if (c == '\"') {
            this.flushTokenPart();
            this.quoted = !this.quoted;
            return;
        }
        if (c == '$') {
            this.flushTokenPart();
            this.tokenPartBuilder.append(c);
            return;
        }
        if (this.quoted || !CharsKt.isWhitespace((char)c)) {
            this.tokenPartBuilder.append(c);
            return;
        }
        this.flushToken();
    }

    private final void flushTokenPart() {
        String string = this.tokenPartBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String s = string;
        if (((CharSequence)s).length() > 0) {
            this.tokenParts.add(SubstituteKt.access$TokenPart(s));
        }
        this.tokenPartBuilder = new StringBuilder();
    }

    private final void flushToken() {
        this.flushTokenPart();
        if (!((Collection)this.tokenParts).isEmpty()) {
            this.tokens.add(CollectionsKt.toList((Iterable)this.tokenParts));
        }
        this.tokenParts = new ArrayList();
    }
}

