/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feed;

import com.jetbrains.toolbox.feed.FeedLocation;
import com.jetbrains.toolbox.feed.FeedV1Json;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParsedFeed {
    @NotNull
    private final FeedLocation originalLocation;
    @NotNull
    private final Instant cachedAt;
    @Nullable
    private final String eTag;
    @NotNull
    private final FeedV1Json items;

    public ParsedFeed(@NotNull FeedLocation originalLocation, @NotNull Instant cachedAt, @Nullable String eTag, @NotNull FeedV1Json items2) {
        Intrinsics.checkNotNullParameter((Object)originalLocation, (String)"originalLocation");
        Intrinsics.checkNotNullParameter((Object)cachedAt, (String)"cachedAt");
        Intrinsics.checkNotNullParameter((Object)items2, (String)"items");
        this.originalLocation = originalLocation;
        this.cachedAt = cachedAt;
        this.eTag = eTag;
        this.items = items2;
    }

    @NotNull
    public final FeedLocation getOriginalLocation() {
        return this.originalLocation;
    }

    @NotNull
    public final FeedV1Json getItems() {
        return this.items;
    }

    @NotNull
    public String toString() {
        return "ParsedFeed(originalLocation=" + this.originalLocation + ", cachedAt=" + this.cachedAt + ", eTag=" + this.eTag + ", items=" + this.items + ")";
    }

    public int hashCode() {
        int result2 = this.originalLocation.hashCode();
        result2 = result2 * 31 + this.cachedAt.hashCode();
        result2 = result2 * 31 + (this.eTag == null ? 0 : this.eTag.hashCode());
        result2 = result2 * 31 + this.items.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ParsedFeed)) {
            return false;
        }
        ParsedFeed parsedFeed = (ParsedFeed)other;
        if (!Intrinsics.areEqual((Object)this.originalLocation, (Object)parsedFeed.originalLocation)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.cachedAt, (Object)parsedFeed.cachedAt)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.eTag, (Object)parsedFeed.eTag)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.items, (Object)parsedFeed.items);
    }
}

