/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feed;

import com.jetbrains.tbe.config.machine.TbeMachineConfig;
import com.jetbrains.toolbox.accounts.AccountManager;
import com.jetbrains.toolbox.accounts.AccountManagerKt;
import com.jetbrains.toolbox.accounts.ToolboxEnterpriseAccount;
import com.jetbrains.toolbox.enterprise.EnterpriseConfig;
import com.jetbrains.toolbox.enterprise.EnterpriseConfigManager;
import com.jetbrains.toolbox.feed.ApplicationPackage;
import com.jetbrains.toolbox.feed.Authenticator;
import com.jetbrains.toolbox.feed.FeedLocation;
import com.jetbrains.toolbox.feed.RemoteFeedItem;
import com.jetbrains.toolbox.feed.logic.AuthenticatorDefaults;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nLinkUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinkUpdater.kt\ncom/jetbrains/toolbox/feed/LinkUpdater\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,63:1\n1#2:64\n1#2:84\n1285#3,2:65\n1299#3,4:67\n1617#3,9:74\n1869#3:83\n1870#3:85\n1626#3:86\n126#4:71\n153#4,2:72\n155#4:87\n*S KotlinDebug\n*F\n+ 1 LinkUpdater.kt\ncom/jetbrains/toolbox/feed/LinkUpdater\n*L\n59#1:84\n58#1:65,2\n58#1:67,4\n59#1:74,9\n59#1:83\n59#1:85\n59#1:86\n59#1:71\n59#1:72,2\n59#1:87\n*E\n"})
public final class LinkUpdater {
    @NotNull
    private final EnterpriseConfigManager enterpriseConfigManager;
    @NotNull
    private final AccountManager accountManager;

    public LinkUpdater(@NotNull EnterpriseConfigManager enterpriseConfigManager, @NotNull AccountManager accountManager) {
        Intrinsics.checkNotNullParameter((Object)enterpriseConfigManager, (String)"enterpriseConfigManager");
        Intrinsics.checkNotNullParameter((Object)accountManager, (String)"accountManager");
        this.enterpriseConfigManager = enterpriseConfigManager;
        this.accountManager = accountManager;
    }

    @NotNull
    public final FeedLocation updateIfNeeded(@NotNull FeedLocation location2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        HttpUrl originalUrl = HttpUrl.Companion.get(location2.getUrl());
        EnterpriseConfig enterpriseConfig = (EnterpriseConfig)this.enterpriseConfigManager.getConfig().getValue();
        TbeMachineConfig config2 = enterpriseConfig != null ? enterpriseConfig.getMachineConfig() : null;
        ToolboxEnterpriseAccount authState = (ToolboxEnterpriseAccount)AccountManagerKt.getEnterprise(this.accountManager).getActiveAccount().getValue();
        if (this.shouldNotBeUpdated(config2, authState)) {
            return location2;
        }
        TbeMachineConfig tbeMachineConfig = config2;
        Intrinsics.checkNotNull((Object)tbeMachineConfig);
        String downloadUrl = this.getEnterpriseDownloadUrl(originalUrl, "api/toolbox/feeds", tbeMachineConfig);
        return new FeedLocation(downloadUrl, null, false, 6, null);
    }

    @NotNull
    public final RemoteFeedItem updateIfNeeded(@NotNull RemoteFeedItem item2) {
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        HttpUrl originalUrl = HttpUrl.Companion.get(item2.getPackage().getUrl());
        EnterpriseConfig enterpriseConfig = (EnterpriseConfig)this.enterpriseConfigManager.getConfig().getValue();
        TbeMachineConfig config2 = enterpriseConfig != null ? enterpriseConfig.getMachineConfig() : null;
        ToolboxEnterpriseAccount authState = (ToolboxEnterpriseAccount)AccountManagerKt.getEnterprise(this.accountManager).getActiveAccount().getValue();
        if (this.shouldNotBeUpdated(config2, authState)) {
            return item2;
        }
        TbeMachineConfig tbeMachineConfig = config2;
        Intrinsics.checkNotNull((Object)tbeMachineConfig);
        String downloadUrl = this.getEnterpriseDownloadUrl(originalUrl, "api/toolbox/downloads", tbeMachineConfig);
        ApplicationPackage applicationPackage = item2.getPackage();
        Authenticator authenticator = AuthenticatorDefaults.getEnterprise();
        return RemoteFeedItem.copy-fnwMO8k$default(item2, null, null, null, null, null, 0, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, ApplicationPackage.copy$default(applicationPackage, null, null, downloadUrl, 0L, authenticator, null, 0, null, null, null, null, null, 4075, null), null, null, null, null, null, null, null, null, false, -67108865, 15, null);
    }

    private final boolean shouldNotBeUpdated(TbeMachineConfig config2, ToolboxEnterpriseAccount authState) {
        return authState == null || config2 == null;
    }

    private final String getEnterpriseDownloadUrl(HttpUrl url, String base, TbeMachineConfig config2) {
        Object object;
        block3: {
            String downloadUrl;
            block2: {
                String segments = CollectionsKt.joinToString$default((Iterable)url.pathSegments(), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
                downloadUrl = config2.getTbeServerUrl() + "/" + base + "/" + url.host() + "/" + segments;
                object = this.queryParamsString(url);
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = downloadUrl + it;
                object = string;
                if (string != null) break block3;
            }
            object = downloadUrl;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final String queryParamsString(HttpUrl $this$queryParamsString) {
        void $this$mapTo$iv$iv;
        Object object;
        void $this$associateWithTo$iv$iv;
        Set<String> paramsNames = $this$queryParamsString.queryParameterNames();
        if (paramsNames.isEmpty()) {
            return null;
        }
        Iterable $this$associateWith$iv = paramsNames;
        boolean $i$f$associateWith = false;
        Map result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void paramName;
            String string = (String)element$iv$iv;
            Object t2 = element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            List<String> list2 = $this$queryParamsString.queryParameterValues((String)paramName);
            object.put(t2, list2);
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$mapNotNullTo$iv$iv;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            object = destination$iv$iv2;
            boolean bl = false;
            String key = (String)entry.getKey();
            List value2 = (List)entry.getValue();
            Iterable $this$mapNotNull$iv = value2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl2 = false;
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                if (it == null) continue;
                boolean bl4 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            object.add(((List)destination$iv$iv3).isEmpty() ? key : key + "=" + CollectionsKt.joinToString$default((Iterable)value2, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"&", (CharSequence)"?", null, (int)0, null, null, (int)60, null);
    }
}

