/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feed;

import com.jetbrains.toolbox.DataUrl;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nDataUrl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataUrl.kt\ncom/jetbrains/toolbox/feed/DataUrlKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
public final class DataUrlKt {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.jetbrains.toolbox.feed.DataUrl");
    private static final Pattern dataUrlRegex = Pattern.compile("data:([^;]+)((?:;base64)?),(.*)");

    @Nullable
    public static final Pair<String, byte[]> mediaTypeToRawData-Cn57Q5E(@NotNull String string) {
        Pair pair;
        String rawData;
        Object object;
        Matcher matcher;
        Intrinsics.checkNotNullParameter((Object)string, (String)"$v$c$com-jetbrains-toolbox-DataUrl$-dataUrl$0");
        Matcher it = matcher = dataUrlRegex.matcher(string);
        boolean bl = false;
        Matcher matcher2 = it.matches() ? matcher : null;
        if (matcher2 == null) {
            return null;
        }
        Matcher groups = matcher2;
        String string2 = groups.group(2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
        boolean isBase64 = ((CharSequence)string2).length() > 0;
        String mediaType = groups.group(1);
        String data2 = groups.group(3);
        try {
            Object object2;
            if (isBase64) {
                try {
                    Base64 base64 = Base64.Default.getUrlSafe();
                    Intrinsics.checkNotNull((Object)data2);
                    object = Base64.decode$default((Base64)base64, (CharSequence)data2, (int)0, (int)0, (int)6, null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Base64 base64 = (Base64)Base64.Default;
                    Intrinsics.checkNotNull((Object)data2);
                    object = Base64.decode$default((Base64)base64, (CharSequence)data2, (int)0, (int)0, (int)6, null);
                }
                object2 = object;
            } else {
                String string3 = URLDecoder.decode(data2, StandardCharsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"decode(...)");
                object = string3;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                byte[] byArray = ((String)object).getBytes(charset);
                object2 = byArray;
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            }
            object = object2;
        }
        catch (Throwable throwable) {
            logger.warn("Failed to decode malformed raw data for " + mediaType + " media type");
            object = null;
        }
        String string4 = rawData = object;
        if (string4 != null) {
            String it2 = string4;
            boolean bl2 = false;
            pair = TuplesKt.to((Object)mediaType, (Object)rawData);
        } else {
            pair = null;
        }
        return pair;
    }

    @NotNull
    public static final String dataUrl(@NotNull String type2, @NotNull byte[] bytes2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        return DataUrl.constructor-impl("data:" + type2 + ";base64," + Base64.encode$default((Base64)((Base64)Base64.Default), (byte[])bytes2, (int)0, (int)0, (int)6, null));
    }
}

