/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.extension.manifest;

import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.integration.OSIntegrationManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;

public final class ManifestMetadataProvider {
    @NotNull
    private final OS.Type os;
    @NotNull
    private final OSIntegrationManager osIntegrationManager;
    @NotNull
    private final String appId;
    @NotNull
    private final String executableName;
    @NotNull
    private final Lazy executablePath$delegate;

    public ManifestMetadataProvider(@NotNull OS.Type os, @NotNull OSIntegrationManager osIntegrationManager, @NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)((Object)os), (String)"os");
        Intrinsics.checkNotNullParameter((Object)osIntegrationManager, (String)"osIntegrationManager");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        this.os = os;
        this.osIntegrationManager = osIntegrationManager;
        this.appId = appId;
        this.executableName = "extension-helper";
        this.executablePath$delegate = LazyKt.lazy(() -> ManifestMetadataProvider.executablePath_delegate$lambda$0(this));
    }

    @NotNull
    public final String getAppId() {
        return this.appId;
    }

    @NotNull
    public final Path getExecutablePath() {
        Lazy lazy = this.executablePath$delegate;
        return (Path)lazy.getValue();
    }

    private static final Path executablePath_delegate$lambda$0(ManifestMetadataProvider this$0) {
        Path path2 = this$0.osIntegrationManager.getInstallationPath();
        Intrinsics.checkNotNull((Object)path2);
        Path binaryDirectory = path2;
        String suffix = switch (WhenMappings.$EnumSwitchMapping$0[this$0.os.ordinal()]) {
            case 1 -> ".exe";
            case 2 -> "";
            case 3 -> ".kexe";
            default -> throw new NoWhenBranchMatchedException();
        };
        return binaryDirectory.resolve(this$0.executableName + suffix);
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.Type.values().length];
            try {
                nArray[OS.Type.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Mac.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

