/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ex.io;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.io.Buffer;
import kotlinx.io.BuffersKt;
import kotlinx.io.bytestring.ByteStringKt;
import org.jetbrains.annotations.NotNull;

public final class PersistentBuffer {
    private final int maxSize;
    @NotNull
    private final Buffer buffer;
    @NotNull
    private final Lazy string$delegate;

    private PersistentBuffer(int maxSize, Buffer buffer) {
        this.maxSize = maxSize;
        this.buffer = buffer;
        this.string$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> PersistentBuffer.string_delegate$lambda$0(this));
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    public PersistentBuffer(int maxSize) {
        this(maxSize, new Buffer());
    }

    private final String getString() {
        Lazy lazy = this.string$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String asString() {
        return this.getString();
    }

    @NotNull
    public final PersistentBuffer transferFrom(@NotNull Buffer data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (!(data2.getSize() <= Integer.MAX_VALUE)) {
            boolean $i$a$-require-PersistentBuffer$transferFrom$22 = false;
            String $i$a$-require-PersistentBuffer$transferFrom$22 = "Too big data: " + data2.getSize();
            throw new IllegalArgumentException($i$a$-require-PersistentBuffer$transferFrom$22.toString());
        }
        if (data2.getSize() == 0L) {
            return this;
        }
        if (data2.getSize() >= (long)this.maxSize) {
            data2.skip(data2.getSize() - (long)this.maxSize);
            Buffer newBuffer = new Buffer();
            data2.transferTo(newBuffer);
            return new PersistentBuffer(this.maxSize, newBuffer);
        }
        try {
            long startInCurrentBuffer = this.buffer.getSize() + data2.getSize() - (long)this.maxSize;
            Buffer newBuffer = new Buffer();
            Buffer.copyTo$default(this.buffer, newBuffer, RangesKt.coerceAtLeast((long)startInCurrentBuffer, (long)0L), 0L, 4, null);
            data2.transferTo(newBuffer);
            return new PersistentBuffer(this.maxSize, newBuffer);
        }
        catch (Throwable t2) {
            String message2 = StringsKt.trimIndent((String)("\n          Failed to transfer data.\n          Max size: " + this.maxSize + ".\n          Buffer: " + this.buffer + ",\n          Data: " + data2 + "\n      "));
            throw new IllegalStateException(message2, t2);
        }
    }

    @NotNull
    public String toString() {
        return "PersistentBuffer(maxSize=" + this.maxSize + ", buffer=" + this.buffer + ")";
    }

    private static final String string_delegate$lambda$0(PersistentBuffer this$0) {
        return ByteStringKt.decodeToString(BuffersKt.snapshot(this$0.buffer));
    }
}

