/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.entry;

import com.intellij.diagnostic.CoroutineDumperKt;
import com.jetbrains.JBR;
import com.jetbrains.Jstack;
import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.tbe.test.access.api.TbeTestConstantsKt;
import java.awt.desktop.AppReopenedListener;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JBRSetup {
    @NotNull
    public static final JBRSetup INSTANCE = new JBRSetup();
    @Nullable
    private static AppReopenedListener listener;

    private JBRSetup() {
    }

    public final void setupJBR() {
        if (Build.INSTANCE.isSNAPSHOT() || TbeTestConstantsKt.isTbeTestAccessEnabled()) {
            this.enableCoroutinesDump();
        }
    }

    @Nullable
    public final AppReopenedListener getListener() {
        return listener;
    }

    public final void setListener(@Nullable AppReopenedListener appReopenedListener) {
        listener = appReopenedListener;
    }

    public final void setupOpenWindowEventListener(@NotNull AppReopenedListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        JBRSetup.listener = listener;
    }

    private final void enableCoroutinesDump() {
        try {
            CoroutineDumperKt.enableCoroutineDump();
            Jstack jstack = JBR.getJstack();
            if (jstack != null) {
                jstack.includeInfoFrom(JBRSetup::enableCoroutinesDump$lambda$0);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private static final String enableCoroutinesDump$lambda$0() {
        return "\n---------- Coroutine dump ----------\n" + CoroutineDumperKt.dumpCoroutines$default(null, false, false, 7, null) + "\n";
    }
}

