/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise.plugins;

import com.jetbrains.toolbox.common.security.ShaKt;
import com.jetbrains.toolbox.enterprise.EnterpriseConfig;
import com.jetbrains.toolbox.enterprise.EnterpriseConfigManager;
import com.jetbrains.toolbox.feed.PluginId;
import com.jetbrains.toolbox.intellij.plugins.IntelliJPluginVerifier;
import com.jetbrains.toolbox.manager.FeedProvider;
import com.jetbrains.toolbox.manager.FeedV2WithSource;
import java.net.URI;
import java.util.Set;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import kotlin.text.StringsKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nEnterprisePluginVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnterprisePluginVerifier.kt\ncom/jetbrains/toolbox/enterprise/plugins/EnterprisePluginVerifier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1#2:49\n*E\n"})
public final class EnterprisePluginVerifier
implements IntelliJPluginVerifier {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final FeedProvider feedProvider;
    @NotNull
    private final EnterpriseConfigManager configManager;
    @NotNull
    private final String DEFAULT_IDES_CLOUD_DOMAIN;

    public EnterprisePluginVerifier(@NotNull FileSystem fileSystem, @NotNull FeedProvider feedProvider, @NotNull EnterpriseConfigManager configManager) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)feedProvider, (String)"feedProvider");
        Intrinsics.checkNotNullParameter((Object)configManager, (String)"configManager");
        this.fileSystem = fileSystem;
        this.feedProvider = feedProvider;
        this.configManager = configManager;
        this.DEFAULT_IDES_CLOUD_DOMAIN = ".jetbrains-ide-services.com";
    }

    @Override
    @NotNull
    public IntelliJPluginVerifier.Result verifyZippedPlugin-3arw3uo(@NotNull Path path2, @NotNull String string) {
        boolean isCloudDeployment;
        Object object;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                Intrinsics.checkNotNullParameter((Object)string, (String)"$v$c$com-jetbrains-toolbox-feed-PluginId$-pluginId$0");
                object = (EnterpriseConfig)this.configManager.getConfig().getValue();
                if (object == null || (object = ((EnterpriseConfig)object).getMachineConfig()) == null || (object = object.getTbeServerUrl()) == null) break block8;
                Object it = object;
                boolean bl = false;
                URI uRI = URI.create((String)it);
                object = uRI;
                if (uRI != null) break block9;
            }
            return IntelliJPluginVerifier.Result.Failure.INSTANCE;
        }
        Object idesServerUrl = object;
        String string2 = System.getenv("IDES_CLOUD_DOMAIN");
        if (string2 == null) {
            string2 = this.DEFAULT_IDES_CLOUD_DOMAIN;
        }
        String cloudDomain = string2;
        String string3 = ((URI)idesServerUrl).getHost();
        boolean bl = isCloudDeployment = string3 != null ? StringsKt.endsWith$default((String)string3, (String)cloudDomain, (boolean)false, (int)2, null) : false;
        if (!isCloudDeployment) {
            Logger.INSTANCE.debug("Running outside of cloud, skipping checksum verification for plugin " + PluginId.toString-impl(string));
            return IntelliJPluginVerifier.Result.Skipped.INSTANCE;
        }
        Logger.INSTANCE.debug("Running in cloud mode, proceeding to checksum verification of plugin " + PluginId.toString-impl(string));
        Set<String> set = ((FeedV2WithSource)this.feedProvider.getFeed().getValue()).getEnterprisePluginHashes().get(PluginId.box-impl(string));
        if (set == null) {
            return IntelliJPluginVerifier.Result.Failure.INSTANCE;
        }
        Set<String> pluginChecksums = set;
        try {
            String pluginZipChecksum = HexExtensionsKt.toHexString$default((byte[])ShaKt.sha512(this.fileSystem, path2), null, (int)1, null);
            return pluginChecksums.contains(pluginZipChecksum) ? (IntelliJPluginVerifier.Result)IntelliJPluginVerifier.Result.Success.INSTANCE : (IntelliJPluginVerifier.Result)IntelliJPluginVerifier.Result.Failure.INSTANCE;
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "TBE plugin checksum calculation has ended with error");
            return IntelliJPluginVerifier.Result.Failure.INSTANCE;
        }
    }
}

