/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise.plugins;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.common.coroutines.flow.SingleStateFlow;
import com.jetbrains.toolbox.enterprise.EnterpriseIntelliJToolRestarter;
import com.jetbrains.toolbox.enterprise.EnterpriseToolUpdates;
import com.jetbrains.toolbox.enterprise.plugins.EnterprisePluginInstallationManager;
import com.jetbrains.toolbox.enterprise.settings.EnterpriseRequiredPluginSetting;
import com.jetbrains.toolbox.enterprise.settings.EnterpriseSetting;
import com.jetbrains.toolbox.i18n.LocalizableStringEx;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.ToolReconfigurator;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EnterprisePluginInstallationToolConfigurator
implements ToolReconfigurator {
    @NotNull
    private final String pluginId;
    @NotNull
    private final HttpUrl pluginUrl;
    @Nullable
    private final String pluginVersion;
    @NotNull
    private final String pluginChannel;
    @Nullable
    private final String pluginSource;
    @NotNull
    private final EnterprisePluginInstallationManager enterprisePluginInstallationManager;
    @NotNull
    private final EnterpriseIntelliJToolRestarter enterpriseIntelliJToolRestarter;
    @NotNull
    private final StateFlow<LocalizableString> displayName;

    private EnterprisePluginInstallationToolConfigurator(String pluginId, HttpUrl pluginUrl, String pluginVersion, String pluginChannel, String pluginSource, EnterprisePluginInstallationManager enterprisePluginInstallationManager, EnterpriseIntelliJToolRestarter enterpriseIntelliJToolRestarter) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Intrinsics.checkNotNullParameter((Object)pluginUrl, (String)"pluginUrl");
        Intrinsics.checkNotNullParameter((Object)pluginChannel, (String)"pluginChannel");
        Intrinsics.checkNotNullParameter((Object)enterprisePluginInstallationManager, (String)"enterprisePluginInstallationManager");
        Intrinsics.checkNotNullParameter((Object)enterpriseIntelliJToolRestarter, (String)"enterpriseIntelliJToolRestarter");
        this.pluginId = pluginId;
        this.pluginUrl = pluginUrl;
        this.pluginVersion = pluginVersion;
        this.pluginChannel = pluginChannel;
        this.pluginSource = pluginSource;
        this.enterprisePluginInstallationManager = enterprisePluginInstallationManager;
        this.enterpriseIntelliJToolRestarter = enterpriseIntelliJToolRestarter;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"pluginId", (Object)this.pluginId)};
        this.displayName = new SingleStateFlow<LocalizableStringEx>(LocalizableStringExKt.trl("Installing plugin {{pluginId}}\u2026", pairArray));
    }

    @Override
    @NotNull
    public StateFlow<LocalizableString> getDisplayName() {
        return this.displayName;
    }

    @Override
    @Nullable
    public Object reconfigure(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super ToolInstance> $completion) {
        return this.enterpriseIntelliJToolRestarter.runWithToolRelaunchingIfNeeded(toolInstance, new EnterpriseToolUpdates.Update(null, null, null, null, CollectionsKt.listOf((Object)new EnterpriseRequiredPluginSetting(new EnterpriseSetting(this.pluginId, true, null), this.pluginVersion, null)), false, 47, null), toolInstance, (Function1)new Function1<Continuation<? super ToolInstance>, Object>(this, toolInstance, null){
            int label;
            final /* synthetic */ EnterprisePluginInstallationToolConfigurator this$0;
            final /* synthetic */ ToolInstance $toolInstance;
            {
                this.this$0 = $receiver;
                this.$toolInstance = $toolInstance;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = EnterprisePluginInstallationToolConfigurator.access$getEnterprisePluginInstallationManager$p(this.this$0).installPlugin-R8b7GTk(this.$toolInstance, EnterprisePluginInstallationToolConfigurator.access$getPluginUrl$p(this.this$0), EnterprisePluginInstallationToolConfigurator.access$getPluginId$p(this.this$0), EnterprisePluginInstallationToolConfigurator.access$getPluginVersion$p(this.this$0), EnterprisePluginInstallationToolConfigurator.access$getPluginChannel$p(this.this$0), EnterprisePluginInstallationToolConfigurator.access$getPluginSource$p(this.this$0), (Continuation<? super ToolInstance>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super ToolInstance> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    public /* synthetic */ EnterprisePluginInstallationToolConfigurator(String pluginId, HttpUrl pluginUrl, String pluginVersion, String pluginChannel, String pluginSource, EnterprisePluginInstallationManager enterprisePluginInstallationManager, EnterpriseIntelliJToolRestarter enterpriseIntelliJToolRestarter, DefaultConstructorMarker $constructor_marker) {
        this(pluginId, pluginUrl, pluginVersion, pluginChannel, pluginSource, enterprisePluginInstallationManager, enterpriseIntelliJToolRestarter);
    }

    public static final /* synthetic */ EnterprisePluginInstallationManager access$getEnterprisePluginInstallationManager$p(EnterprisePluginInstallationToolConfigurator $this) {
        return $this.enterprisePluginInstallationManager;
    }

    public static final /* synthetic */ HttpUrl access$getPluginUrl$p(EnterprisePluginInstallationToolConfigurator $this) {
        return $this.pluginUrl;
    }

    public static final /* synthetic */ String access$getPluginId$p(EnterprisePluginInstallationToolConfigurator $this) {
        return $this.pluginId;
    }

    public static final /* synthetic */ String access$getPluginVersion$p(EnterprisePluginInstallationToolConfigurator $this) {
        return $this.pluginVersion;
    }

    public static final /* synthetic */ String access$getPluginChannel$p(EnterprisePluginInstallationToolConfigurator $this) {
        return $this.pluginChannel;
    }

    public static final /* synthetic */ String access$getPluginSource$p(EnterprisePluginInstallationToolConfigurator $this) {
        return $this.pluginSource;
    }
}

