/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise.configuration.steps;

import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.enterprise.configuration.steps.EnterpriseToolConfigurationStep;
import com.jetbrains.toolbox.enterprise.rest.ToolV2;
import com.jetbrains.toolbox.enterprise.settings.vsc.EnterpriseVsCodeExtensionInstaller;
import com.jetbrains.toolbox.enterprise.settings.vsc.EnterpriseVsCodeSettingsLocator;
import com.jetbrains.toolbox.enterprise.settings.vsc.EnterpriseVsCodeSettingsManager;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import okio.FileSystem;
import org.jetbrains.annotations.NotNull;

public final class VSCodeConfigurationStepsFactory {
    @NotNull
    private final OS.Type os;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final EnterpriseVsCodeExtensionInstaller extensionInstaller;
    @NotNull
    private final EnterpriseVsCodeSettingsManager settingsManager;

    public VSCodeConfigurationStepsFactory(@NotNull OS.Type os, @NotNull FileSystem fileSystem, @NotNull EnterpriseVsCodeExtensionInstaller extensionInstaller, @NotNull EnterpriseVsCodeSettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)os), (String)"os");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)extensionInstaller, (String)"extensionInstaller");
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        this.os = os;
        this.fileSystem = fileSystem;
        this.extensionInstaller = extensionInstaller;
        this.settingsManager = settingsManager;
    }

    @NotNull
    public final EnterpriseToolConfigurationStep createVsCodeExtensionStep(@NotNull ToolV2 config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        return new EnterpriseToolConfigurationStep(this, config2){
            final /* synthetic */ VSCodeConfigurationStepsFactory this$0;
            final /* synthetic */ ToolV2 $config;
            {
                this.this$0 = $receiver;
                this.$config = $config;
            }

            public Object execute(ToolInstance toolInstance, Continuation<? super ToolInstance> $completion) {
                VSCodeConfigurationStepsFactory.access$getExtensionInstaller$p(this.this$0).installExtensions(this.$config, toolInstance);
                return toolInstance;
            }
        };
    }

    @NotNull
    public final EnterpriseToolConfigurationStep createVsCodeSettingsStep(@NotNull ToolV2 config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        return new EnterpriseToolConfigurationStep(this, config2){
            final /* synthetic */ VSCodeConfigurationStepsFactory this$0;
            final /* synthetic */ ToolV2 $config;
            {
                this.this$0 = $receiver;
                this.$config = $config;
            }

            public Object execute(ToolInstance toolInstance, Continuation<? super ToolInstance> $completion) {
                VSCodeConfigurationStepsFactory.access$getSettingsManager$p(this.this$0).applySettings(this.$config, new EnterpriseVsCodeSettingsLocator(VSCodeConfigurationStepsFactory.access$getOs$p(this.this$0), this.$config.getAppType-UtVBrGo(), VSCodeConfigurationStepsFactory.access$getFileSystem$p(this.this$0), null));
                return toolInstance;
            }
        };
    }

    public static final /* synthetic */ EnterpriseVsCodeExtensionInstaller access$getExtensionInstaller$p(VSCodeConfigurationStepsFactory $this) {
        return $this.extensionInstaller;
    }

    public static final /* synthetic */ EnterpriseVsCodeSettingsManager access$getSettingsManager$p(VSCodeConfigurationStepsFactory $this) {
        return $this.settingsManager;
    }

    public static final /* synthetic */ OS.Type access$getOs$p(VSCodeConfigurationStepsFactory $this) {
        return $this.os;
    }

    public static final /* synthetic */ FileSystem access$getFileSystem$p(VSCodeConfigurationStepsFactory $this) {
        return $this.fileSystem;
    }
}

