/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise.configuration;

import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.enterprise.rest.EnterpriseIdeMode;
import com.jetbrains.toolbox.enterprise.settings.EnterpriseChannelExtensionModifier;
import com.jetbrains.toolbox.enterprise.settings.FrontendEnterpriseChannelExtensionImplModifier;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SettingsManager;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class EnterpriseIdeModesProvider {
    @NotNull
    private final SettingsManager settingsManager;

    public EnterpriseIdeModesProvider(@NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        this.settingsManager = settingsManager;
    }

    @NotNull
    public final EnterpriseIdeMode currentSetupToIdeMode(@NotNull EnterpriseChannelExtensionModifier enterpriseChannelExtensionModifier) {
        Intrinsics.checkNotNullParameter((Object)enterpriseChannelExtensionModifier, (String)"enterpriseChannelExtensionModifier");
        return Build.INSTANCE.isAgent() ? EnterpriseIdeMode.RdBackend : (enterpriseChannelExtensionModifier instanceof FrontendEnterpriseChannelExtensionImplModifier ? EnterpriseIdeMode.RdClient : EnterpriseIdeMode.Local);
    }

    @NotNull
    public final List<EnterpriseIdeMode> getIdeModesToBeQueried() {
        List list2;
        if (Build.INSTANCE.isAgent()) {
            list2 = CollectionsKt.listOf((Object)((Object)EnterpriseIdeMode.RdBackend));
        } else if (((SelfSettings)this.settingsManager.getSettings().getValue()).getInternal().getEnableJbidesRdIntegration()) {
            EnterpriseIdeMode[] enterpriseIdeModeArray = new EnterpriseIdeMode[]{EnterpriseIdeMode.Local, EnterpriseIdeMode.RdClient};
            list2 = CollectionsKt.listOf((Object[])enterpriseIdeModeArray);
        } else {
            list2 = CollectionsKt.listOf((Object)((Object)EnterpriseIdeMode.Local));
        }
        return list2;
    }
}

