/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise;

import com.jetbrains.tbe.config.machine.TbeMachineConfig;
import com.jetbrains.toolbox.Notifications;
import com.jetbrains.toolbox.SnackbarResult;
import com.jetbrains.toolbox.UIGlobalState;
import com.jetbrains.toolbox.UIModalState;
import com.jetbrains.toolbox.WindowManager;
import com.jetbrains.toolbox.common.extensions.StringExtensionsKt;
import com.jetbrains.toolbox.common.extensions.URIExtensionsKt;
import com.jetbrains.toolbox.enterprise.EnterpriseConfig;
import com.jetbrains.toolbox.enterprise.EnterpriseConfigManager;
import com.jetbrains.toolbox.enterprise.EnterpriseInvitationManager;
import com.jetbrains.toolbox.enterprise.EnterpriseInvitationManagerImpl;
import com.jetbrains.toolbox.enterprise.ToolboxEnterpriseMachineConfigSuggestion;
import com.jetbrains.toolbox.enterprise.machineConfig.EnterpriseMachineConfigDownloader;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import com.jetbrains.toolbox.manager.SnackbarManager;
import com.jetbrains.toolbox.network.CertificateTrustRequest;
import com.jetbrains.toolbox.network.UntrustedCertificateHandler;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class EnterpriseInvitationManagerImpl
implements EnterpriseInvitationManager {
    @NotNull
    private final EnterpriseConfigManager enterpriseConfig;
    @NotNull
    private final EnterpriseMachineConfigDownloader enterpriseMachineConfigDownloader;
    @NotNull
    private final Notifications notifications;
    @NotNull
    private final UntrustedCertificateHandler untrustedCertificateHandler;
    @NotNull
    private final UIGlobalState uiGlobalState;
    @NotNull
    private final WindowManager windowManager;
    @NotNull
    private final SnackbarManager snackbarManager;
    @NotNull
    private final I18n i18n;
    private final boolean impliesUiMode;

    public EnterpriseInvitationManagerImpl(@NotNull EnterpriseConfigManager enterpriseConfig, @NotNull EnterpriseMachineConfigDownloader enterpriseMachineConfigDownloader, @NotNull Notifications notifications, @NotNull UntrustedCertificateHandler untrustedCertificateHandler, @NotNull UIGlobalState uiGlobalState, @NotNull WindowManager windowManager, @NotNull SnackbarManager snackbarManager, @NotNull I18n i18n) {
        Intrinsics.checkNotNullParameter((Object)enterpriseConfig, (String)"enterpriseConfig");
        Intrinsics.checkNotNullParameter((Object)enterpriseMachineConfigDownloader, (String)"enterpriseMachineConfigDownloader");
        Intrinsics.checkNotNullParameter((Object)notifications, (String)"notifications");
        Intrinsics.checkNotNullParameter((Object)untrustedCertificateHandler, (String)"untrustedCertificateHandler");
        Intrinsics.checkNotNullParameter((Object)uiGlobalState, (String)"uiGlobalState");
        Intrinsics.checkNotNullParameter((Object)windowManager, (String)"windowManager");
        Intrinsics.checkNotNullParameter((Object)snackbarManager, (String)"snackbarManager");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        this.enterpriseConfig = enterpriseConfig;
        this.enterpriseMachineConfigDownloader = enterpriseMachineConfigDownloader;
        this.notifications = notifications;
        this.untrustedCertificateHandler = untrustedCertificateHandler;
        this.uiGlobalState = uiGlobalState;
        this.windowManager = windowManager;
        this.snackbarManager = snackbarManager;
        this.i18n = i18n;
        this.impliesUiMode = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public Object canHandle(@NotNull URI uri, @NotNull Continuation<? super Boolean> $completion) {
        boolean bl;
        if (Intrinsics.areEqual((Object)uri.getHost(), (Object)"toolbox")) {
            String string = uri.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (StringsKt.startsWith$default((String)string, (String)"/enterprise/config", (boolean)false, (int)2, null)) {
                bl = true;
                return Boxing.boxBoolean((boolean)bl);
            }
        }
        bl = false;
        return Boxing.boxBoolean((boolean)bl);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object handle(@NotNull URI uri, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof handle.1)) ** GOTO lbl-1000
        var7_3 = $completion;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ EnterpriseInvitationManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.handle(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                existingConfig = (EnterpriseConfig)this.enterpriseConfig.getConfig().getValue();
                if (existingConfig == null) break;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)uri);
                $continuation.L$1 = existingConfig;
                $continuation.label = 1;
                v0 = this.windowManager.showWindow((Continuation<? super Unit>)$continuation);
                if (v0 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl26
            }
            case 1: {
                existingConfig = (EnterpriseConfig)$continuation.L$1;
                uri = (URI)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)uri);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)existingConfig);
                $continuation.label = 2;
                v1 = this.snackbarManager.showSnackbar(this.snackbarManager.enterpriseOrgJoinError(existingConfig.getMachineConfig().getCompanyName()), (Continuation<? super SnackbarResult>)$continuation);
                if (v1 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl38
            }
            case 2: {
                existingConfig = (EnterpriseConfig)$continuation.L$1;
                uri = (URI)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl38:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        query = URIExtensionsKt.parseQuery(uri);
        v2 = query.get("url");
        if (v2 == null) {
            return Unit.INSTANCE;
        }
        configURL = v2;
        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)uri);
        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)existingConfig);
        $continuation.L$2 = SpillingKt.nullOutSpilledVariable(query);
        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)configURL);
        $continuation.label = 3;
        v3 = this.handleMachineConfigUrl(configURL, (Continuation<? super Unit>)$continuation);
        if (v3 == var8_5) {
            return var8_5;
        }
        ** GOTO lbl60
        {
            case 3: {
                configURL = (String)$continuation.L$3;
                query = (Map)$continuation.L$2;
                existingConfig = (EnterpriseConfig)$continuation.L$1;
                uri = (URI)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl60:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public boolean getImpliesUiMode() {
        return this.impliesUiMode;
    }

    @Override
    @Nullable
    public Object handleMachineConfigUrl(@NotNull String machineConfigUrl, @NotNull Continuation<? super Unit> $completion) {
        Logger.INSTANCE.info("Asking user permission to accept the candidate user enterprise config");
        this.uiGlobalState.updateState((Function1<? super UIModalState, ? extends UIModalState>)((Function1)arg_0 -> EnterpriseInvitationManagerImpl.handleMachineConfigUrl$lambda$0(machineConfigUrl, arg_0)));
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object readAndValidate(@NotNull String configURL, @NotNull Continuation<? super ToolboxEnterpriseMachineConfigSuggestion> $completion) {
        if (!($completion instanceof readAndValidate.1)) ** GOTO lbl-1000
        var7_3 = $completion;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ EnterpriseInvitationManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.readAndValidate(null, (Continuation<? super ToolboxEnterpriseMachineConfigSuggestion>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)configURL);
                $continuation.label = 1;
                v0 = this.readConfigAfterWaitingForCertificate(configURL, (Continuation<? super ToolboxEnterpriseMachineConfigSuggestion>)$continuation);
                if (v0 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                configURL = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                v1 = (ToolboxEnterpriseMachineConfigSuggestion)v0;
                if (v1 == null) {
                    return null;
                }
                initialConfig = v1;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)configURL);
                $continuation.L$1 = initialConfig;
                $continuation.label = 2;
                v2 = this.readWithCertificatesValidation(initialConfig, (Continuation<? super ToolboxEnterpriseMachineConfigSuggestion>)$continuation);
                if (v2 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl38
            }
            case 2: {
                initialConfig = (ToolboxEnterpriseMachineConfigSuggestion)$continuation.L$1;
                configURL = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl38:
                // 2 sources

                v3 = (ToolboxEnterpriseMachineConfigSuggestion)v2;
                if (v3 == null) {
                    return null;
                }
                validatedConfig = v3;
                if (Intrinsics.areEqual((Object)validatedConfig.getConfig().getTbeServerUrl(), (Object)initialConfig.getConfig().getTbeServerUrl()) && Intrinsics.areEqual(validatedConfig.getConfig().getHttpsTrustStore(), initialConfig.getConfig().getHttpsTrustStore())) {
                    return validatedConfig;
                }
                Logger.INSTANCE.info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, readAndValidate$lambda$0(com.jetbrains.toolbox.enterprise.ToolboxEnterpriseMachineConfigSuggestion com.jetbrains.toolbox.enterprise.ToolboxEnterpriseMachineConfigSuggestion ), ()Ljava/lang/String;)((ToolboxEnterpriseMachineConfigSuggestion)initialConfig, (ToolboxEnterpriseMachineConfigSuggestion)validatedConfig));
                var5_10 = new Pair[]{TuplesKt.to((Object)"ideServicesName", (Object)"JetBrains IDE Services")};
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)configURL);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)initialConfig);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)validatedConfig);
                $continuation.label = 3;
                v4 = this.notifications.showErrorMessage(this.i18n.tr("Inconsistent {{ideServicesName}} login request, it cannot be accepted", var5_10), (Continuation<? super Unit>)$continuation);
                if (v4 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl60
            }
            case 3: {
                validatedConfig = (ToolboxEnterpriseMachineConfigSuggestion)$continuation.L$2;
                initialConfig = (ToolboxEnterpriseMachineConfigSuggestion)$continuation.L$1;
                configURL = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl60:
                // 2 sources

                return null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object readConfigAfterWaitingForCertificate(String configURL, Continuation<? super ToolboxEnterpriseMachineConfigSuggestion> $completion) {
        if (!($completion instanceof readConfigAfterWaitingForCertificate.1)) ** GOTO lbl-1000
        var7_3 = $completion;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ EnterpriseInvitationManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return EnterpriseInvitationManagerImpl.access$readConfigAfterWaitingForCertificate(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.untrustedCertificateHandler.setCertificatePromptsEnabled(true);
                $continuation.L$0 = configURL;
                $continuation.label = 1;
                v0 = this.read(configURL, (Continuation<? super ToolboxEnterpriseMachineConfigSuggestion>)$continuation);
                ** if (v0 != var8_5) goto lbl20
lbl19:
                // 1 sources

                return var8_5;
lbl20:
                // 1 sources

                ** GOTO lbl27
            }
            case 1: {
                configURL = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl27:
                    // 2 sources

                    var4_6 = (ToolboxEnterpriseMachineConfigSuggestion)v0;
                }
                catch (Throwable var5_7) {
                    throw var5_7;
                }
                finally {
                    this.untrustedCertificateHandler.setCertificatePromptsEnabled(false);
                }
                res = var4_6;
                if (res != null) ** GOTO lbl49
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)configURL);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)res);
                $continuation.label = 2;
                v1 = TimeoutKt.withTimeoutOrNull((long)30000L, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ToolboxEnterpriseMachineConfigSuggestion>, Object>(this, configURL, null){
                    int label;
                    final /* synthetic */ EnterpriseInvitationManagerImpl this$0;
                    final /* synthetic */ String $configURL;
                    {
                        this.this$0 = $receiver;
                        this.$configURL = $configURL;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = FlowKt.first((Flow)FlowKt.dropWhile((Flow)((Flow)EnterpriseInvitationManagerImpl.access$getUntrustedCertificateHandler$p(this.this$0).getPendingUntrustedCertificatePrompts()), (Function2)((Function2)new Function2<List<? extends CertificateTrustRequest>, Continuation<? super Boolean>, Object>(null){
                                    int label;
                                    /* synthetic */ Object L$0;

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        List list2 = (List)this.L$0;
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                void it;
                                                ResultKt.throwOnFailure((Object)$result);
                                                return Boxing.boxBoolean((!((Collection)it).isEmpty() ? 1 : 0) != 0);
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                        var3_3.L$0 = value2;
                                        return (Continuation)var3_3;
                                    }

                                    public final Object invoke(List<CertificateTrustRequest> p1, Continuation<? super Boolean> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                })), (Continuation)((Continuation)this));
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                this.label = 2;
                                v1 = EnterpriseInvitationManagerImpl.access$read(this.this$0, this.$configURL, (Continuation)this);
                                if (v1 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl21
                            }
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl21:
                                // 2 sources

                                return v1;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super ToolboxEnterpriseMachineConfigSuggestion> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl48
            }
            case 2: {
                res = (ToolboxEnterpriseMachineConfigSuggestion)$continuation.L$1;
                configURL = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl48:
                // 2 sources

                res = (ToolboxEnterpriseMachineConfigSuggestion)v1;
lbl49:
                // 2 sources

                return res;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object read(String configURL, Continuation<? super ToolboxEnterpriseMachineConfigSuggestion> $completion) {
        block15: {
            block16: {
                if (!($completion instanceof read.1)) ** GOTO lbl-1000
                var6_3 = $completion;
                if ((var6_3.label & -2147483648) != 0) {
                    var6_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        /* synthetic */ Object result;
                        final /* synthetic */ EnterpriseInvitationManagerImpl this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return EnterpriseInvitationManagerImpl.access$read(this.this$0, null, (Continuation)this);
                        }
                    };
                }
                $result = $continuation.result;
                var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Logger.INSTANCE.info("Processing the candidate solid enterprise config from url " + configURL);
                        configURLAsURI = StringExtensionsKt.toUriOrNull(configURL);
                        if (configURLAsURI == null) {
                            Logger.INSTANCE.info("Can't download config from " + configURL + ": not an URI");
                            return null;
                        }
                        if (Intrinsics.areEqual((Object)configURLAsURI.getScheme(), (Object)"http") && !Intrinsics.areEqual((Object)configURLAsURI.getHost(), (Object)"localhost")) {
                            Logger.INSTANCE.info("http:// URLs are unsupported, please use HTTPS");
                            return null;
                        }
                        $continuation.L$0 = configURL;
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)configURLAsURI);
                        $continuation.label = 1;
                        v0 = this.enterpriseMachineConfigDownloader.downloadMachineConfig(configURL, (Continuation<? super EnterpriseMachineConfigDownloader.Result>)$continuation);
                        if (v0 == var7_5) {
                            return var7_5;
                        }
                        ** GOTO lbl32
                    }
                    case 1: {
                        configURLAsURI = (URI)$continuation.L$1;
                        configURL = (String)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl32:
                        // 2 sources

                        if (!((downloadResult = (EnterpriseMachineConfigDownloader.Result)v0) instanceof EnterpriseMachineConfigDownloader.Result.NetworkError)) break;
                        Logger.INSTANCE.warn("Unable to download enterprise config from " + configURL);
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)configURL);
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)configURLAsURI);
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)downloadResult);
                        $continuation.label = 2;
                        v1 = this.notifications.showErrorMessage(this.i18n.tr("Cannot download the configuration file"), (Continuation<? super Unit>)$continuation);
                        if (v1 == var7_5) {
                            return var7_5;
                        }
                        ** GOTO lbl48
                    }
                    case 2: {
                        downloadResult = (EnterpriseMachineConfigDownloader.Result)$continuation.L$2;
                        configURLAsURI = (URI)$continuation.L$1;
                        configURL = (String)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl48:
                        // 2 sources

                        v2 = null;
                        break block15;
                    }
                }
                if (!(downloadResult instanceof EnterpriseMachineConfigDownloader.Result.ParsingError)) break block16;
                Logger.INSTANCE.error("Unable to parse enterprise config from " + configURL);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)configURL);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)configURLAsURI);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)downloadResult);
                $continuation.label = 3;
                v3 = this.notifications.showErrorMessage(this.i18n.tr("Cannot parse the configuration file"), (Continuation<? super Unit>)$continuation);
                if (v3 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl66
                {
                    case 3: {
                        downloadResult = (EnterpriseMachineConfigDownloader.Result)$continuation.L$2;
                        configURLAsURI = (URI)$continuation.L$1;
                        configURL = (String)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl66:
                        // 2 sources

                        v2 = null;
                        break block15;
                    }
                }
            }
            if (downloadResult instanceof EnterpriseMachineConfigDownloader.Result.Success) {
                v2 = new ToolboxEnterpriseMachineConfigSuggestion(((EnterpriseMachineConfigDownloader.Result.Success)downloadResult).getConfig());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return v2;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object readWithCertificatesValidation(ToolboxEnterpriseMachineConfigSuggestion suggestion, Continuation<? super ToolboxEnterpriseMachineConfigSuggestion> $completion) {
        block13: {
            block14: {
                if (!($completion instanceof readWithCertificatesValidation.1)) ** GOTO lbl-1000
                var8_3 = $completion;
                if ((var8_3.label & -2147483648) != 0) {
                    var8_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        /* synthetic */ Object result;
                        final /* synthetic */ EnterpriseInvitationManagerImpl this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return EnterpriseInvitationManagerImpl.access$readWithCertificatesValidation(this.this$0, null, (Continuation)this);
                        }
                    };
                }
                $result = $continuation.result;
                var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        tbeMachineConfig = suggestion.getConfig();
                        Logger.INSTANCE.info("Validating server certificates for enterprise config from url " + tbeMachineConfig);
                        var5_9 = new char[]{'/'};
                        configURL = StringsKt.trimEnd((String)tbeMachineConfig.getTbeServerUrl(), (char[])var5_9) + "/api/machine-config";
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)suggestion);
                        $continuation.L$1 = tbeMachineConfig;
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)configURL);
                        $continuation.label = 1;
                        v0 = this.enterpriseMachineConfigDownloader.downloadMachineConfig((String)configURL, (Continuation<? super EnterpriseMachineConfigDownloader.Result>)$continuation);
                        if (v0 == var9_5) {
                            return var9_5;
                        }
                        ** GOTO lbl30
                    }
                    case 1: {
                        configURL = (String)$continuation.L$2;
                        tbeMachineConfig = (TbeMachineConfig)$continuation.L$1;
                        suggestion = (ToolboxEnterpriseMachineConfigSuggestion)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl30:
                        // 2 sources

                        if (!((downloadResult = (EnterpriseMachineConfigDownloader.Result)v0) instanceof EnterpriseMachineConfigDownloader.Result.NetworkError)) break;
                        Logger.INSTANCE.error("Unable to download JetBrains IDE Services config from the URL with service " + tbeMachineConfig.getTbeServerUrl());
                        var6_15 = new Pair[]{TuplesKt.to((Object)"ideServicesName", (Object)"JetBrains IDE Services"), TuplesKt.to((Object)"serverAddress", (Object)tbeMachineConfig.getTbeServerUrl())};
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)suggestion);
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)tbeMachineConfig);
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)configURL);
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)downloadResult);
                        $continuation.label = 2;
                        v1 = this.notifications.showErrorMessage(this.i18n.tr("Cannot download the {{ideServicesName}} configuration from {{serverAddress}}", var6_15), (Continuation<? super Unit>)$continuation);
                        if (v1 == var9_5) {
                            return var9_5;
                        }
                        ** GOTO lbl49
                    }
                    case 2: {
                        downloadResult = (EnterpriseMachineConfigDownloader.Result)$continuation.L$3;
                        configURL = (String)$continuation.L$2;
                        tbeMachineConfig = (TbeMachineConfig)$continuation.L$1;
                        suggestion = (ToolboxEnterpriseMachineConfigSuggestion)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl49:
                        // 2 sources

                        v2 = null;
                        break block13;
                    }
                }
                if (!(downloadResult instanceof EnterpriseMachineConfigDownloader.Result.ParsingError)) break block14;
                Logger.INSTANCE.error("Unable to parse enterprise config from " + tbeMachineConfig.getTbeServerUrl());
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)suggestion);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)tbeMachineConfig);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)configURL);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)downloadResult);
                $continuation.label = 3;
                v3 = this.notifications.showErrorMessage(this.i18n.tr("Cannot parse the configuration file"), (Continuation<? super Unit>)$continuation);
                if (v3 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl69
                {
                    case 3: {
                        downloadResult = (EnterpriseMachineConfigDownloader.Result)$continuation.L$3;
                        configURL = (String)$continuation.L$2;
                        tbeMachineConfig = (TbeMachineConfig)$continuation.L$1;
                        suggestion = (ToolboxEnterpriseMachineConfigSuggestion)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl69:
                        // 2 sources

                        v2 = null;
                        break block13;
                    }
                }
            }
            if (downloadResult instanceof EnterpriseMachineConfigDownloader.Result.Success) {
                v2 = new ToolboxEnterpriseMachineConfigSuggestion(((EnterpriseMachineConfigDownloader.Result.Success)downloadResult).getConfig());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return v2;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void done() {
        this.uiGlobalState.updateState((Function1<? super UIModalState, ? extends UIModalState>)((Function1)EnterpriseInvitationManagerImpl::done$lambda$0));
    }

    private static final UIModalState handleMachineConfigUrl$lambda$0(String $machineConfigUrl, UIModalState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof UIModalState.Normal ? (UIModalState)new UIModalState.CandidateEnterpriseConfig($machineConfigUrl, false, 2, null) : it;
    }

    private static final String readAndValidate$lambda$0(ToolboxEnterpriseMachineConfigSuggestion $initialConfig, ToolboxEnterpriseMachineConfigSuggestion $validatedConfig) {
        return "The initial config was " + $initialConfig.getConfig() + ", but own server config has different URL: " + $validatedConfig.getConfig() + ". Request is ignored";
    }

    private static final UIModalState done$lambda$0(UIModalState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof UIModalState.CandidateEnterpriseConfig ? (UIModalState)UIModalState.Normal.INSTANCE : it;
    }

    public static final /* synthetic */ Object access$readConfigAfterWaitingForCertificate(EnterpriseInvitationManagerImpl $this, String configURL, Continuation $completion) {
        return $this.readConfigAfterWaitingForCertificate(configURL, (Continuation<? super ToolboxEnterpriseMachineConfigSuggestion>)$completion);
    }

    public static final /* synthetic */ UntrustedCertificateHandler access$getUntrustedCertificateHandler$p(EnterpriseInvitationManagerImpl $this) {
        return $this.untrustedCertificateHandler;
    }

    public static final /* synthetic */ Object access$read(EnterpriseInvitationManagerImpl $this, String configURL, Continuation $completion) {
        return $this.read(configURL, (Continuation<? super ToolboxEnterpriseMachineConfigSuggestion>)$completion);
    }

    public static final /* synthetic */ Object access$readWithCertificatesValidation(EnterpriseInvitationManagerImpl $this, ToolboxEnterpriseMachineConfigSuggestion suggestion, Continuation $completion) {
        return $this.readWithCertificatesValidation(suggestion, (Continuation<? super ToolboxEnterpriseMachineConfigSuggestion>)$completion);
    }
}

