/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise;

import com.jetbrains.tbe.config.machine.TbeMachineConfig;
import com.jetbrains.toolbox.common.io.FileSystemWatcher;
import com.jetbrains.toolbox.enterprise.EnterpriseConfig;
import com.jetbrains.toolbox.enterprise.EnterpriseConfigManager;
import com.jetbrains.toolbox.enterprise.EnterpriseConfigManagerImpl$watchConfigFilesForChanges$1$invokeSuspend$;
import com.jetbrains.toolbox.enterprise.EnterpriseConfigManagerKt;
import com.jetbrains.toolbox.enterprise.ToolboxEnterpriseMachineConfigSuggestion;
import com.jetbrains.toolbox.enterprise.machineConfig.EnterpriseMachineConfigStorage;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class EnterpriseConfigManagerImpl
implements EnterpriseConfigManager {
    @NotNull
    private final EnterpriseMachineConfigStorage enterpriseMachineConfigStorage;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final MutableStateFlow<EnterpriseConfig> _config;
    @NotNull
    private final StateFlow<EnterpriseConfig> config;

    /*
     * WARNING - void declaration
     */
    public EnterpriseConfigManagerImpl(@NotNull EnterpriseMachineConfigStorage enterpriseMachineConfigStorage, @NotNull CoroutineScope coroutineScope) {
        EnterpriseConfig enterpriseConfig;
        Intrinsics.checkNotNullParameter((Object)enterpriseMachineConfigStorage, (String)"enterpriseMachineConfigStorage");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.enterpriseMachineConfigStorage = enterpriseMachineConfigStorage;
        this.coroutineScope = coroutineScope;
        EnterpriseConfigManagerImpl enterpriseConfigManagerImpl = this;
        TbeMachineConfig tbeMachineConfig = this.tryReadAdminConfig();
        if (tbeMachineConfig != null) {
            void adminConfig;
            TbeMachineConfig tbeMachineConfig2 = tbeMachineConfig;
            EnterpriseConfigManagerImpl enterpriseConfigManagerImpl2 = enterpriseConfigManagerImpl;
            boolean bl = false;
            enterpriseConfig = new EnterpriseConfig((TbeMachineConfig)adminConfig, true, this.enterpriseMachineConfigStorage.getAdminConfigPath());
            enterpriseConfigManagerImpl = enterpriseConfigManagerImpl2;
        } else {
            TbeMachineConfig tbeMachineConfig3 = this.tryReadUserConfig();
            if (tbeMachineConfig3 != null) {
                void userConfig;
                TbeMachineConfig bl = tbeMachineConfig3;
                EnterpriseConfigManagerImpl enterpriseConfigManagerImpl3 = enterpriseConfigManagerImpl;
                boolean bl2 = false;
                enterpriseConfig = new EnterpriseConfig((TbeMachineConfig)userConfig, false, this.enterpriseMachineConfigStorage.getUserConfigPath());
                enterpriseConfigManagerImpl = enterpriseConfigManagerImpl3;
            } else {
                enterpriseConfig = null;
            }
        }
        enterpriseConfigManagerImpl._config = StateFlowKt.MutableStateFlow(enterpriseConfig);
        this.config = FlowKt.asStateFlow(this._config);
    }

    @Override
    @NotNull
    public StateFlow<EnterpriseConfig> getConfig() {
        return this.config;
    }

    private final TbeMachineConfig tryReadAdminConfig() {
        TbeMachineConfig config2 = this.enterpriseMachineConfigStorage.readAdminConfig();
        if (config2 != null) {
            Logger.INSTANCE.info("Enabling the admin enterprise config at " + this.enterpriseMachineConfigStorage.getAdminConfigPath());
        }
        return config2;
    }

    private final TbeMachineConfig tryReadUserConfig() {
        TbeMachineConfig config2 = this.enterpriseMachineConfigStorage.readUserConfig();
        if (config2 != null) {
            Logger.INSTANCE.info("Enabling the user enterprise config at " + this.enterpriseMachineConfigStorage.getUserConfigPath());
        }
        return config2;
    }

    @Override
    public void watchConfigFilesForChanges(@NotNull FileSystemWatcher filewatcher) {
        Intrinsics.checkNotNullParameter((Object)filewatcher, (String)"filewatcher");
        Path userConfigPath = this.enterpriseMachineConfigStorage.getUserConfigPath();
        Path adminConfigPath = this.enterpriseMachineConfigStorage.getAdminConfigPath();
        Path[] pathArray = new Path[]{userConfigPath, adminConfigPath};
        filewatcher.watch(pathArray);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(filewatcher, adminConfigPath, userConfigPath, this, null){
            int label;
            final /* synthetic */ FileSystemWatcher $filewatcher;
            final /* synthetic */ Path $adminConfigPath;
            final /* synthetic */ Path $userConfigPath;
            final /* synthetic */ EnterpriseConfigManagerImpl this$0;
            {
                this.$filewatcher = $filewatcher;
                this.$adminConfigPath = $adminConfigPath;
                this.$userConfigPath = $userConfigPath;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$filter$iv;
                        ResultKt.throwOnFailure((Object)$result);
                        Flow flow2 = (Flow)this.$filewatcher.getEvents();
                        Path path2 = this.$adminConfigPath;
                        Path path3 = this.$userConfigPath;
                        boolean $i$f$filter = false;
                        void $this$unsafeTransform$iv$iv = $this$filter$iv;
                        boolean $i$f$unsafeTransform = false;
                        boolean $i$f$unsafeFlow = false;
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)FlowKt.debounce-HG0u8IE((Flow)((Flow)new Flow<FileSystemWatcher.Event>((Flow)$this$unsafeTransform$iv$iv, path2, path3){
                            final /* synthetic */ Flow $this_unsafeTransform$inlined;
                            final /* synthetic */ Path $adminConfigPath$inlined;
                            final /* synthetic */ Path $userConfigPath$inlined;
                            {
                                this.$this_unsafeTransform$inlined = flow2;
                                this.$adminConfigPath$inlined = path2;
                                this.$userConfigPath$inlined = path3;
                            }

                            public Object collect(FlowCollector collector, Continuation $completion) {
                                Continuation continuation = $completion;
                                FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                                boolean bl = false;
                                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240, this.$adminConfigPath$inlined, this.$userConfigPath$inlined){
                                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                                    final /* synthetic */ Path $adminConfigPath$inlined;
                                    final /* synthetic */ Path $userConfigPath$inlined;
                                    {
                                        this.$this_unsafeFlow = $receiver;
                                        this.$adminConfigPath$inlined = path2;
                                        this.$userConfigPath$inlined = path3;
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    public final Object emit(Object value, Continuation $completion) {
                                        if (!($completion instanceof watchConfigFilesForChanges$1$invokeSuspend$$inlined$filter$1$2$1)) ** GOTO lbl-1000
                                        var3_3 = $completion;
                                        if ((var3_3.label & -2147483648) != 0) {
                                            var3_3.label -= -2147483648;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            $continuation = new ContinuationImpl(this, $completion){
                                                /* synthetic */ Object result;
                                                int label;
                                                Object L$0;
                                                Object L$1;
                                                final /* synthetic */ watchConfigFilesForChanges$1$invokeSuspend$$inlined$filter$1$2 this$0;
                                                Object L$2;
                                                Object L$3;
                                                int I$0;
                                                {
                                                    this.this$0 = this$0;
                                                    super($completion);
                                                }

                                                public final Object invokeSuspend(Object $result) {
                                                    this.result = $result;
                                                    this.label |= Integer.MIN_VALUE;
                                                    return this.this$0.emit(null, (Continuation)this);
                                                }
                                            };
                                        }
                                        $result = $continuation.result;
                                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch ($continuation.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                var6_6 = $continuation;
                                                var7_8 = value;
                                                $this$filter_u24lambda_u240 = this.$this_unsafeFlow;
                                                $i$a$-unsafeTransform-FlowKt__TransformKt$filter$1 = 0;
                                                var10_14 = (Continuation)$continuation;
                                                it = (FileSystemWatcher.Event)value;
                                                $i$a$-filter-EnterpriseConfigManagerImpl$watchConfigFilesForChanges$1$1 = false;
                                                if (!(Intrinsics.areEqual((Object)it.getFile(), (Object)this.$adminConfigPath$inlined) != false || Intrinsics.areEqual((Object)it.getFile(), (Object)this.$userConfigPath$inlined) != false)) break;
                                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)value);
                                                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                                                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)value);
                                                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$filter_u24lambda_u240);
                                                $continuation.I$0 = $i$a$-unsafeTransform-FlowKt__TransformKt$filter$1;
                                                $continuation.label = 1;
                                                v0 = $this$filter_u24lambda_u240.emit((Object)value, (Continuation)$continuation);
                                                if (v0 == var5_5) {
                                                    return var5_5;
                                                }
                                                break;
                                            }
                                            case 1: {
                                                $i$a$-unsafeTransform-FlowKt__TransformKt$filter$1 = $continuation.I$0;
                                                $this$filter_u24lambda_u240 = (FlowCollector)$continuation.L$3;
                                                value = $continuation.L$2;
                                                $completion = $continuation.L$1;
                                                value = $continuation.L$0;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
                                                break;
                                            }
                                        }
                                        return Unit.INSTANCE;
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                }, $completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }), (long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS)), (Function2)((Function2)new Function2<FileSystemWatcher.Event, Continuation<? super Unit>, Object>(this.this$0, this.$adminConfigPath, this.$userConfigPath, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ EnterpriseConfigManagerImpl this$0;
                            final /* synthetic */ Path $adminConfigPath;
                            final /* synthetic */ Path $userConfigPath;
                            {
                                this.this$0 = $receiver;
                                this.$adminConfigPath = $adminConfigPath;
                                this.$userConfigPath = $userConfigPath;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                FileSystemWatcher.Event event = (FileSystemWatcher.Event)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void it;
                                        ResultKt.throwOnFailure((Object)$result);
                                        EnterpriseConfig oldConfig = (EnterpriseConfig)EnterpriseConfigManagerImpl.access$get_config$p(this.this$0).getValue();
                                        if (Intrinsics.areEqual((Object)it.getFile(), (Object)this.$adminConfigPath)) {
                                            TbeMachineConfig adminConfig = EnterpriseConfigManagerImpl.access$tryReadAdminConfig(this.this$0);
                                            if (adminConfig != null) {
                                                EnterpriseConfigManagerImpl.access$get_config$p(this.this$0).setValue((Object)new EnterpriseConfig(adminConfig, true, this.$adminConfigPath));
                                            } else if (EnterpriseConfigManagerKt.isAdminLevelConfig(oldConfig)) {
                                                EnterpriseConfigManagerImpl.access$get_config$p(this.this$0).setValue(null);
                                            }
                                        } else if (Intrinsics.areEqual((Object)it.getFile(), (Object)this.$userConfigPath) && !EnterpriseConfigManagerKt.isAdminLevelConfig(oldConfig)) {
                                            TbeMachineConfig userConfig = EnterpriseConfigManagerImpl.access$tryReadUserConfig(this.this$0);
                                            if (userConfig != null) {
                                                EnterpriseConfigManagerImpl.access$get_config$p(this.this$0).setValue((Object)new EnterpriseConfig(userConfig, false, this.$userConfigPath));
                                            } else {
                                                EnterpriseConfigManagerImpl.access$get_config$p(this.this$0).setValue(null);
                                            }
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value2;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(FileSystemWatcher.Event p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    @Nullable
    public Object acceptConfigFromLink(@NotNull ToolboxEnterpriseMachineConfigSuggestion newConfig, @NotNull Continuation<? super Unit> $completion) {
        EnterpriseConfig oldConfig = (EnterpriseConfig)this._config.getValue();
        if (EnterpriseConfigManagerKt.isAdminLevelConfig(oldConfig)) {
            EnterpriseConfig enterpriseConfig = oldConfig;
            Logger.INSTANCE.warn("Accepting a user enterprise config has no effect due to the presence of the admin config at " + (Path)(enterpriseConfig != null ? enterpriseConfig.getConfigPath() : null));
            return Unit.INSTANCE;
        }
        Logger.INSTANCE.info("Accepted a new user enterprise config");
        this._config.setValue((Object)new EnterpriseConfig(newConfig.getConfig(), false, this.enterpriseMachineConfigStorage.getUserConfigPath()));
        this.enterpriseMachineConfigStorage.saveUserConfig(newConfig.getConfig());
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object leaveOrganization(@NotNull Continuation<? super Unit> $completion) {
        EnterpriseConfig oldConfig = (EnterpriseConfig)this._config.getValue();
        if (EnterpriseConfigManagerKt.isAdminLevelConfig(oldConfig)) {
            EnterpriseConfig enterpriseConfig = oldConfig;
            Logger.INSTANCE.error("Cannot leave organization when using admin config from " + (Path)(enterpriseConfig != null ? enterpriseConfig.getConfigPath() : null));
        } else {
            Object object = (EnterpriseConfig)this.getConfig().getValue();
            Logger.INSTANCE.info("Leaving organization " + (object != null && (object = ((EnterpriseConfig)object).getMachineConfig()) != null ? object.getTbeServerUrl() : null));
            this.enterpriseMachineConfigStorage.removeUserConfig();
            this._config.setValue(null);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ MutableStateFlow access$get_config$p(EnterpriseConfigManagerImpl $this) {
        return $this._config;
    }

    public static final /* synthetic */ TbeMachineConfig access$tryReadAdminConfig(EnterpriseConfigManagerImpl $this) {
        return $this.tryReadAdminConfig();
    }

    public static final /* synthetic */ TbeMachineConfig access$tryReadUserConfig(EnterpriseConfigManagerImpl $this) {
        return $this.tryReadUserConfig();
    }
}

