/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.educational.progress;

import com.jetbrains.toolbox.educational.progress.EducationalProgressManager;
import com.jetbrains.toolbox.network.httpServer.websocket.WebsocketOutlet;
import com.jetbrains.toolbox.network.httpServer.websocket.WebsocketReceiver;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class EducationalProgressConnectionHandle
implements WebsocketReceiver {
    @NotNull
    private final String sessionId;
    @NotNull
    private final EducationalProgressManager progressManager;
    @NotNull
    private final WebsocketOutlet outlet;

    private EducationalProgressConnectionHandle(String sessionId, EducationalProgressManager progressManager, WebsocketOutlet outlet2) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)progressManager, (String)"progressManager");
        Intrinsics.checkNotNullParameter((Object)outlet2, (String)"outlet");
        this.sessionId = sessionId;
        this.progressManager = progressManager;
        this.outlet = outlet2;
    }

    @Override
    public void connected() {
        Logger.INSTANCE.debug("Client connected. sessionId: " + this.sessionId);
        this.progressManager.addSession-_TKwOzk(this.sessionId, this);
    }

    @Override
    public void receive(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
    }

    @Override
    public void disconnected() {
        Logger.INSTANCE.debug("Client disconnected. sessionId: " + this.sessionId);
        this.progressManager.removeSession-_TKwOzk(this.sessionId, this);
    }

    public final void send(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Logger.INSTANCE.debug("Sending message. sessionId: " + this.sessionId + ", message: " + message2);
        this.outlet.send(message2);
    }

    public /* synthetic */ EducationalProgressConnectionHandle(String sessionId, EducationalProgressManager progressManager, WebsocketOutlet outlet2, DefaultConstructorMarker $constructor_marker) {
        this(sessionId, progressManager, outlet2);
    }
}

