/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ea;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nExceptionData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionData.kt\ncom/jetbrains/toolbox/ea/ExceptionData\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n11561#2:51\n11896#2,3:52\n1#3:55\n*S KotlinDebug\n*F\n+ 1 ExceptionData.kt\ncom/jetbrains/toolbox/ea/ExceptionData\n*L\n17#1:51\n17#1:52,3\n*E\n"})
public final class ExceptionData {
    @NotNull
    private final String message;
    @NotNull
    private final String className;
    @NotNull
    private final List<StackTraceElementData> stackTrace;
    @Nullable
    private final ExceptionData cause;

    public ExceptionData(@NotNull String message2, @NotNull String className, @NotNull List<StackTraceElementData> stackTrace, @Nullable ExceptionData cause) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter(stackTrace, (String)"stackTrace");
        this.message = message2;
        this.className = className;
        this.stackTrace = stackTrace;
        this.cause = cause;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    /*
     * WARNING - void declaration
     */
    public ExceptionData(@NotNull Throwable t2) {
        ExceptionData exceptionData;
        Collection<StackTraceElementData> collection;
        Throwable $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)t2, (String)"t");
        String string = t2.getMessage();
        if (string == null) {
            string = "";
        }
        String string2 = t2.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        StackTraceElement[] stackTraceElementArray = t2.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
        Object[] objectArray = stackTraceElementArray;
        String string3 = string2;
        String string4 = string;
        ExceptionData exceptionData2 = this;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StackTraceElement stackTraceElement = (StackTraceElement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new StackTraceElementData(it.getClassName(), it.getMethodName(), it.getFileName(), it.getLineNumber()));
        }
        collection = (List)destination$iv$iv;
        ExceptionData exceptionData3 = exceptionData2;
        String string5 = string4;
        String string6 = string3;
        Collection collection2 = collection;
        Throwable throwable = t2.getCause();
        if (throwable != null) {
            void p0;
            $this$mapTo$iv$iv = throwable;
            collection = collection2;
            string3 = string6;
            string4 = string5;
            exceptionData2 = exceptionData3;
            boolean bl = false;
            ExceptionData exceptionData4 = new ExceptionData((Throwable)p0);
            exceptionData3 = exceptionData2;
            string5 = string4;
            string6 = string3;
            collection2 = collection;
            exceptionData = exceptionData4;
        } else {
            exceptionData = null;
        }
        exceptionData3(string5, string6, (List<StackTraceElementData>)collection2, exceptionData);
    }

    @NotNull
    public final ExceptionData sanitize() {
        ExceptionData exceptionData = this.cause;
        return ExceptionData.copy$default(this, "", null, null, exceptionData != null ? exceptionData.sanitize() : null, 6, null);
    }

    @NotNull
    public final String getShortStackTrace() {
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)this.stackTrace, (int)3), null, null, null, (int)0, null, ExceptionData::_get_shortStackTrace_$lambda$0, (int)31, null);
    }

    @NotNull
    public final String stackTraceToString() {
        StringBuilder stringBuilder;
        StringBuilder p0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        this.appendStacktraceString(p0);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void appendStacktraceString(StringBuilder sb) {
        for (StackTraceElementData it : this.stackTrace) {
            sb.append("\tat " + new StackTraceElement(null, null, null, it.getClassName(), it.getMethodName(), it.getFileName(), it.getLineNumber())).append('\n');
        }
        if (this.cause != null) {
            sb.append("\tCaused by: " + this.className + ": " + this.message).append('\n');
            this.cause.appendStacktraceString(sb);
        }
    }

    @NotNull
    public final ExceptionData copy(@NotNull String message2, @NotNull String className, @NotNull List<StackTraceElementData> stackTrace, @Nullable ExceptionData cause) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter(stackTrace, (String)"stackTrace");
        return new ExceptionData(message2, className, stackTrace, cause);
    }

    public static /* synthetic */ ExceptionData copy$default(ExceptionData exceptionData, String string, String string2, List list2, ExceptionData exceptionData2, int n, Object object) {
        if ((n & 1) != 0) {
            string = exceptionData.message;
        }
        if ((n & 2) != 0) {
            string2 = exceptionData.className;
        }
        if ((n & 4) != 0) {
            list2 = exceptionData.stackTrace;
        }
        if ((n & 8) != 0) {
            exceptionData2 = exceptionData.cause;
        }
        return exceptionData.copy(string, string2, list2, exceptionData2);
    }

    @NotNull
    public String toString() {
        return "ExceptionData(message=" + this.message + ", className=" + this.className + ", stackTrace=" + this.stackTrace + ", cause=" + this.cause + ")";
    }

    public int hashCode() {
        int result2 = this.message.hashCode();
        result2 = result2 * 31 + this.className.hashCode();
        result2 = result2 * 31 + ((Object)this.stackTrace).hashCode();
        result2 = result2 * 31 + (this.cause == null ? 0 : this.cause.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExceptionData)) {
            return false;
        }
        ExceptionData exceptionData = (ExceptionData)other;
        if (!Intrinsics.areEqual((Object)this.message, (Object)exceptionData.message)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.className, (Object)exceptionData.className)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.stackTrace, exceptionData.stackTrace)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.cause, (Object)exceptionData.cause);
    }

    private static final CharSequence _get_shortStackTrace_$lambda$0(StackTraceElementData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFileName() + ":" + it.getLineNumber();
    }

    public static final class StackTraceElementData {
        @Nullable
        private final String className;
        @Nullable
        private final String methodName;
        @Nullable
        private final String fileName;
        private final int lineNumber;

        public StackTraceElementData(@Nullable String className, @Nullable String methodName, @Nullable String fileName, int lineNumber) {
            this.className = className;
            this.methodName = methodName;
            this.fileName = fileName;
            this.lineNumber = lineNumber;
        }

        @Nullable
        public final String getClassName() {
            return this.className;
        }

        @Nullable
        public final String getMethodName() {
            return this.methodName;
        }

        @Nullable
        public final String getFileName() {
            return this.fileName;
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }
    }
}

