/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.devcontainers.project;

import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.devcontainers.ConfigParseResult;
import com.jetbrains.toolbox.devcontainers.Devcontainer;
import com.jetbrains.toolbox.devcontainers.DevcontainerConfig;
import com.jetbrains.toolbox.devcontainers.InspectContainerResult;
import com.jetbrains.toolbox.devcontainers.agent.DevcontainerToolboxAgents;
import com.jetbrains.toolbox.devcontainers.launcher.DevcontainerLauncher;
import com.jetbrains.toolbox.devcontainers.project.DevcontainerProjectImpl;
import com.jetbrains.toolbox.project.devcontainers.DevcontainerProject;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;

public final class DevcontainersManagerImplKt {
    private static final DevcontainerProject createDevcontainerProject(Devcontainer devcontainer, DevcontainerLauncher devcontainerLauncher, DevcontainerToolboxAgents devcontainerToolboxAgents) {
        StateFlow toolboxAgentStatus = FlowExtensionsKt.mapState(devcontainerToolboxAgents.getToolboxAgentState(devcontainer), DevcontainersManagerImplKt::createDevcontainerProject$lambda$0);
        StateFlow containerStatus = FlowExtensionsKt.mapState(devcontainer.getInspectInfo(), DevcontainersManagerImplKt::createDevcontainerProject$lambda$1);
        return new DevcontainerProjectImpl(devcontainer.getId(), devcontainer.getPresentableName(), FlowExtensionsKt.mapState(devcontainer.getConfig(), DevcontainersManagerImplKt::createDevcontainerProject$lambda$2), containerStatus, toolboxAgentStatus, devcontainer, devcontainerLauncher);
    }

    private static final DevcontainerProject.ToolboxAgentStatus createDevcontainerProject$lambda$0(DevcontainerToolboxAgents.State it) {
        DevcontainerProject.ToolboxAgentStatus toolboxAgentStatus;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DevcontainerToolboxAgents.State state2 = it;
        if (Intrinsics.areEqual((Object)state2, (Object)DevcontainerToolboxAgents.State.Initial.INSTANCE)) {
            toolboxAgentStatus = DevcontainerProject.ToolboxAgentStatus.Initial.INSTANCE;
        } else if (state2 instanceof DevcontainerToolboxAgents.State.Deploying) {
            toolboxAgentStatus = DevcontainerProject.ToolboxAgentStatus.Deploying.INSTANCE;
        } else if (state2 instanceof DevcontainerToolboxAgents.State.Running) {
            toolboxAgentStatus = DevcontainerProject.ToolboxAgentStatus.Running.INSTANCE;
        } else if (Intrinsics.areEqual((Object)state2, (Object)DevcontainerToolboxAgents.State.Stopped.INSTANCE)) {
            toolboxAgentStatus = DevcontainerProject.ToolboxAgentStatus.Stopped.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return toolboxAgentStatus;
    }

    private static final DevcontainerProject.ContainerStatus createDevcontainerProject$lambda$1(InspectContainerResult it) {
        DevcontainerProject.ContainerStatus containerStatus;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        InspectContainerResult inspectContainerResult = it;
        if (Intrinsics.areEqual((Object)inspectContainerResult, (Object)InspectContainerResult.Initial.INSTANCE)) {
            containerStatus = DevcontainerProject.ContainerStatus.Initial.INSTANCE;
        } else if (inspectContainerResult instanceof InspectContainerResult.Success) {
            containerStatus = ((InspectContainerResult.Success)it).getContent().getState().isRunning() ? (DevcontainerProject.ContainerStatus)DevcontainerProject.ContainerStatus.Running.INSTANCE : (DevcontainerProject.ContainerStatus)DevcontainerProject.ContainerStatus.Stopped.INSTANCE;
        } else if (inspectContainerResult instanceof InspectContainerResult.Failed) {
            containerStatus = DevcontainerProject.ContainerStatus.Unavailable.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return containerStatus;
    }

    private static final DevcontainerProject.Details createDevcontainerProject$lambda$2(ConfigParseResult it) {
        DevcontainerProject.Details details;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ConfigParseResult configParseResult = it;
        if (Intrinsics.areEqual((Object)configParseResult, (Object)ConfigParseResult.Initial.INSTANCE)) {
            details = DevcontainerProject.Details.Unknown.INSTANCE;
        } else if (configParseResult instanceof ConfigParseResult.Success) {
            DevcontainerConfig.ConnectionParameters connectionParams = ((ConfigParseResult.Success)it).getContent().getConnectionParams();
            details = connectionParams == null ? (DevcontainerProject.Details)DevcontainerProject.Details.Unavailable.INSTANCE : (DevcontainerProject.Details)new DevcontainerProject.Details.Retrieved(connectionParams.getProjectPath(), connectionParams.getProductCode(), connectionParams.getBuildNumber());
        } else if (Intrinsics.areEqual((Object)configParseResult, (Object)ConfigParseResult.InspectionFailed.INSTANCE) || configParseResult instanceof ConfigParseResult.InvalidConfiguration || configParseResult instanceof ConfigParseResult.ParsingError) {
            details = DevcontainerProject.Details.Unavailable.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return details;
    }

    public static final /* synthetic */ DevcontainerProject access$createDevcontainerProject(Devcontainer devcontainer, DevcontainerLauncher devcontainerLauncher, DevcontainerToolboxAgents devcontainerToolboxAgents) {
        return DevcontainersManagerImplKt.createDevcontainerProject(devcontainer, devcontainerLauncher, devcontainerToolboxAgents);
    }
}

