/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.desktop.input;

import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.desktop.input.InputKey;
import com.jetbrains.toolbox.desktop.input.KeyboardModifiers;
import com.jetbrains.toolbox.win32.InputKt;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ConversionsKt {
    public static final int toNativeVirtualKeyCode-_OrBMRk(int n) {
        int n2;
        if (OS.INSTANCE.isMac()) {
            n2 = com.jetbrains.toolbox.macos.InputKt.toMacVirtualKeyCode-_OrBMRk(n);
        } else if (OS.INSTANCE.isWindows()) {
            n2 = InputKt.toWin32VirtualKeyCode-_OrBMRk(n);
        } else if (OS.INSTANCE.isLinux()) {
            n2 = com.jetbrains.toolbox.linux.InputKt.toX11KeySym-_OrBMRk(n);
        } else {
            Logger.INSTANCE.warn("Unknown platform for key conversion, falling back to AWT code");
            n2 = InputKey.toNativePlatformCode-impl(n);
        }
        return n2;
    }

    public static final int toNativeModifiers-bhbtf8A(int n) {
        int n2;
        if (OS.INSTANCE.isMac()) {
            n2 = com.jetbrains.toolbox.macos.InputKt.toMacModifiers-bhbtf8A(n);
        } else if (OS.INSTANCE.isWindows()) {
            n2 = InputKt.toWin32Modifiers-bhbtf8A(n);
        } else if (OS.INSTANCE.isLinux()) {
            n2 = com.jetbrains.toolbox.linux.InputKt.toX11Modifiers-bhbtf8A(n);
        } else {
            Logger.INSTANCE.warn("Unknown platform for modifier conversion, falling back to AWT modifiers");
            n2 = ConversionsKt.toAwtModifiers-bhbtf8A(n);
        }
        return n2;
    }

    public static final int toAwtModifiers-bhbtf8A(int n) {
        int awtModifiers = 0;
        if (KeyboardModifiers.isShiftPressed-impl(n)) {
            awtModifiers |= 1;
        }
        if (KeyboardModifiers.isCtrlPressed-impl(n)) {
            awtModifiers |= 2;
        }
        if (KeyboardModifiers.isAltPressed-impl(n)) {
            awtModifiers |= 4;
        }
        if (KeyboardModifiers.isMetaPressed-impl(n)) {
            awtModifiers |= 8;
        }
        return awtModifiers;
    }
}

