/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.desktop.clipboard;

import com.jetbrains.toolbox.desktop.clipboard.AttachmentType;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Attachment<T> {
    @NotNull
    private final AttachmentType<T> type;
    @NotNull
    private final T value;

    public Attachment(@NotNull AttachmentType<T> type2, @NotNull T value2) {
        Intrinsics.checkNotNullParameter(type2, (String)"type");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.type = type2;
        this.value = value2;
    }

    @NotNull
    public final AttachmentType<T> getType() {
        return this.type;
    }

    @NotNull
    public final T getValue() {
        return this.value;
    }

    @NotNull
    public final AttachmentType<T> component1() {
        return this.type;
    }

    @NotNull
    public final T component2() {
        return this.value;
    }

    @NotNull
    public final Attachment<T> copy(@NotNull AttachmentType<T> type2, @NotNull T value2) {
        Intrinsics.checkNotNullParameter(type2, (String)"type");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return new Attachment<T>(type2, value2);
    }

    public static /* synthetic */ Attachment copy$default(Attachment attachment, AttachmentType attachmentType, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            attachmentType = attachment.type;
        }
        if ((n & 2) != 0) {
            object = attachment.value;
        }
        return attachment.copy(attachmentType, object);
    }

    @NotNull
    public String toString() {
        return "Attachment(type=" + this.type + ", value=" + this.value + ")";
    }

    public int hashCode() {
        int result2 = this.type.hashCode();
        result2 = result2 * 31 + this.value.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Attachment)) {
            return false;
        }
        Attachment attachment = (Attachment)other;
        if (!Intrinsics.areEqual(this.type, attachment.type)) {
            return false;
        }
        return Intrinsics.areEqual(this.value, attachment.value);
    }
}

