/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.desktop;

import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.win32.ThemeKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@ApiStatus.Internal
public final class SystemTheme {
    @NotNull
    public static final SystemTheme INSTANCE = new SystemTheme();
    @NotNull
    private static final Flow<Boolean> isDark = switch (WhenMappings.$EnumSwitchMapping$0[OS.INSTANCE.getType().ordinal()]) {
        case 1 -> ThemeKt.getWindowsThemeFlow();
        case 2 -> com.jetbrains.toolbox.macos.ThemeKt.getMacosThemeFlow();
        case 3 -> com.jetbrains.toolbox.linux.ThemeKt.getLinuxThemeFlow();
        default -> throw new NoWhenBranchMatchedException();
    };
    @NotNull
    private static final Lazy isSupported$delegate = LazyKt.lazy(SystemTheme::isSupported_delegate$lambda$0);

    private SystemTheme() {
    }

    @NotNull
    public final Flow<Boolean> isDark() {
        return isDark;
    }

    @Nullable
    public final Boolean getCurrentIsDark() {
        return switch (WhenMappings.$EnumSwitchMapping$0[OS.INSTANCE.getType().ordinal()]) {
            case 1 -> ThemeKt.getWindowsThemeIsDark();
            case 2 -> com.jetbrains.toolbox.macos.ThemeKt.getMacosThemeIsDark();
            case 3 -> com.jetbrains.toolbox.linux.ThemeKt.getLinuxThemeIsDark();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final boolean isSupported() {
        Lazy lazy = isSupported$delegate;
        return (Boolean)lazy.getValue();
    }

    private static final boolean isSupported_delegate$lambda$0() {
        boolean bl;
        try {
            INSTANCE.getCurrentIsDark();
            bl = true;
        }
        catch (Throwable e) {
            Logger.INSTANCE.warn(e, "System theme detection not supported: " + e.getMessage());
            bl = false;
        }
        return bl;
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.Type.values().length];
            try {
                nArray[OS.Type.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Mac.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Linux.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

