/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.datamodel;

import com.jetbrains.toolbox.UtilKt;
import com.jetbrains.toolbox.datamodel.ServiceConfig;
import com.jetbrains.toolbox.datamodel.ServiceInstance;
import com.jetbrains.toolbox.feed.Service;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import java.util.List;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ServiceGenerator<I extends ServiceInstance> {
    @NotNull
    public String getId();

    @NotNull
    public StateFlow<List<I>> getServiceInstances();

    public boolean getRequiresLogin();

    @Nullable
    public Object connect(@NotNull ServiceConfig var1, @NotNull Continuation<? super Unit> var2);

    @Nullable
    public Object disconnect(@NotNull String var1, @NotNull Continuation<? super Unit> var2);

    @NotNull
    public StateFlow<Service> getInfo();

    public boolean update(@NotNull Service var1);

    default public boolean matches(@NotNull String filter2, @NotNull I18n i18n) {
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        return UtilKt.valueMatches(((Service)this.getInfo().getValue()).getName(), filter2) || UtilKt.valueMatches(i18n.tr(((Service)this.getInfo().getValue()).getDescription()), filter2) || UtilKt.valueMatches(i18n.tr(((Service)this.getInfo().getValue()).getProductOverview().getHtmlDescription()), filter2);
    }

    @NotNull
    public String getFusId();

    public boolean getVisible();
}

