/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common.platform;

import com.sun.jna.Platform;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import org.jetbrains.annotations.NotNull;

public final class OS {
    @NotNull
    public static final OS INSTANCE = new OS();
    @NotNull
    private static final Type type;
    private static final boolean isLinux;
    private static final boolean isMac;
    private static final boolean isWindows;
    private static final boolean isUnix;

    private OS() {
    }

    @NotNull
    public final Type getType() {
        return type;
    }

    public final boolean isLinux() {
        return isLinux;
    }

    public final boolean isMac() {
        return isMac;
    }

    public final boolean isWindows() {
        return isWindows;
    }

    public final boolean isUnix() {
        return isUnix;
    }

    static {
        int osType = Platform.getOSType();
        type = switch (osType) {
            case 2 -> Type.Windows;
            case 1 -> Type.Linux;
            case 0 -> Type.Mac;
            default -> throw new IllegalStateException(("Unknown OS type " + osType).toString());
        };
        isLinux = type.isLinux();
        isMac = type.isMac();
        isWindows = type.isWindows();
        isUnix = type.isUnix();
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type Windows = new Type();
        public static final /* enum */ Type Linux = new Type();
        public static final /* enum */ Type Mac = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public final boolean isLinux() {
            return this == Linux;
        }

        public final boolean isMac() {
            return this == Mac;
        }

        public final boolean isWindows() {
            return this == Windows;
        }

        public final boolean isUnix() {
            return this == Linux || this == Mac;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        static {
            $VALUES = typeArray = new Type[]{Type.Windows, Type.Linux, Type.Mac};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

