/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common.io;

import com.jetbrains.toolbox.common.concurrent.ThreadGuardKt;
import com.jetbrains.toolbox.common.platform.OS;
import java.io.File;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nFileExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileExtensions.kt\ncom/jetbrains/toolbox/common/io/FileExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,21:1\n1#2:22\n*E\n"})
public final class FileExtensionsKt {
    @NotNull
    private static final Regex invalidSymbolsRegex = new Regex("\\.\\.|~");

    @NotNull
    public static final File div(@NotNull File $this$div, @NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)$this$div, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return new File($this$div, path2);
    }

    @NotNull
    public static final File getPathUnderRootDirectory(@NotNull File rootDirectory, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        ThreadGuardKt.assertNotMainThread("java.io.File.canonicalPath");
        CharSequence charSequence = relativePath;
        if (!(!invalidSymbolsRegex.containsMatchIn(charSequence))) {
            boolean $i$a$-require-FileExtensionsKt$getPathUnderRootDirectory$32 = false;
            String $i$a$-require-FileExtensionsKt$getPathUnderRootDirectory$32 = "Invalid symbols in path: " + relativePath;
            throw new IllegalArgumentException($i$a$-require-FileExtensionsKt$getPathUnderRootDirectory$32.toString());
        }
        if (!(!new File(relativePath).isAbsolute())) {
            boolean bl = false;
            String string = "Specified path is absolute, but expected relative path to install directory: " + relativePath;
            throw new IllegalArgumentException(string.toString());
        }
        String combined = new File(rootDirectory, relativePath).getCanonicalPath();
        Intrinsics.checkNotNull((Object)combined);
        String string = rootDirectory.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalPath(...)");
        if (!StringsKt.startsWith((String)combined, (String)string, (boolean)OS.INSTANCE.isWindows())) {
            boolean bl = false;
            String string2 = "Resulting path '" + combined + "' must be strictly under '" + rootDirectory.getPath() + "'";
            throw new IllegalStateException(string2.toString());
        }
        return new File(combined);
    }
}

