/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common.io;

import com.jetbrains.toolbox.common.io.FileSystemExtKt;
import com.jetbrains.toolbox.common.io.File_infoKt;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import kotlin.ExceptionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\ncopy-and-move.kt\nKotlin\n*S Kotlin\n*F\n+ 1 copy-and-move.kt\ncom/jetbrains/toolbox/common/io/Copy_and_moveKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Okio.kt\nokio/Okio__OkioKt\n+ 5 FileSystem.kt\nokio/FileSystem\n*L\n1#1,137:1\n1869#2,2:138\n1#3:140\n66#4:141\n52#4,4:143\n60#4,10:152\n56#4,18:162\n67#5:142\n68#5:147\n80#5:148\n165#5:149\n81#5,2:150\n*S KotlinDebug\n*F\n+ 1 copy-and-move.kt\ncom/jetbrains/toolbox/common/io/Copy_and_moveKt\n*L\n33#1:138,2\n47#1:141\n47#1:143,4\n47#1:152,10\n47#1:162,18\n47#1:142\n47#1:147\n47#1:148\n47#1:149\n47#1:150,2\n*E\n"})
public final class Copy_and_moveKt {
    private static final void copyOrMoveRecursivelyWithRetries(FileSystem $this$copyOrMoveRecursivelyWithRetries, Path sourcePath, Path targetPath, boolean deleteSource, FileSystem targetFileSystem, int retries, boolean overwriteExisting) {
        int attempt = 0;
        if (attempt <= retries) {
            while (true) {
                try {
                    Copy_and_moveKt.copyOrMoveRecursively($this$copyOrMoveRecursivelyWithRetries, sourcePath, targetPath, deleteSource, targetFileSystem, overwriteExisting || attempt > 0);
                    return;
                }
                catch (Exception e) {
                    if (attempt >= retries) {
                        throw e;
                    }
                    Logger.INSTANCE.debug((Throwable)e, "Failed on attempt #" + attempt + ". Retrying");
                    if (attempt == retries) break;
                    ++attempt;
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void copyOrMoveRecursively(FileSystem $this$copyOrMoveRecursively, Path sourcePath, Path targetPath, boolean deleteSource, FileSystem targetFileSystem, boolean overwriteExisting) {
        try {
            if ($this$copyOrMoveRecursively.metadata(sourcePath).isDirectory()) {
                targetFileSystem.createDirectories(targetPath);
                Iterable $this$forEach$iv = $this$copyOrMoveRecursively.list(sourcePath);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Path it = (Path)element$iv;
                    boolean bl = false;
                    Copy_and_moveKt.copyOrMoveRecursively($this$copyOrMoveRecursively, it, Path.resolve$default((Path)targetPath, (Path)it.relativeTo(sourcePath), (boolean)false, (int)2, null), deleteSource, targetFileSystem, overwriteExisting);
                }
            } else {
                Path path2 = targetPath.parent();
                if (path2 != null) {
                    Path it = path2;
                    boolean bl = false;
                    targetFileSystem.createDirectories(it);
                }
                if (overwriteExisting && targetFileSystem.exists(targetPath)) {
                    targetFileSystem.delete(targetPath);
                }
                if (FileSystemExtKt.isSystem($this$copyOrMoveRecursively) && FileSystemExtKt.isSystem(targetFileSystem)) {
                    CopyOption[] $this$forEach$iv = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS};
                    Files.copy(sourcePath.toNioPath(), targetPath.toNioPath(), $this$forEach$iv);
                } else if (Intrinsics.areEqual((Object)$this$copyOrMoveRecursively, (Object)targetFileSystem)) {
                    $this$copyOrMoveRecursively.copy(sourcePath, targetPath);
                } else {
                    Long l;
                    Throwable thrown$iv$iv;
                    block43: {
                        void this_$iv;
                        FileSystem $this$forEach$iv = $this$copyOrMoveRecursively;
                        Path file$iv = sourcePath;
                        boolean bl = false;
                        Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
                        boolean $i$f$use = false;
                        thrown$iv$iv = null;
                        try {
                            Long l2;
                            Throwable thrown$iv$iv2;
                            block41: {
                                void $this$iv;
                                BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                                boolean bl2 = false;
                                BufferedSource $this$copyOrMoveRecursively_u24lambda_u242 = it$iv;
                                boolean bl3 = false;
                                FileSystem fileSystem = targetFileSystem;
                                Path file$iv2 = targetPath;
                                boolean mustCreate$iv = false;
                                boolean bl4 = false;
                                Closeable $this$use$iv$iv2 = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv2, mustCreate$iv));
                                boolean $i$f$use2 = false;
                                thrown$iv$iv2 = null;
                                try {
                                    BufferedSink it$iv2 = (BufferedSink)$this$use$iv$iv2;
                                    boolean bl5 = false;
                                    BufferedSink $this$copyOrMoveRecursively_u24lambda_u242_u240 = it$iv2;
                                    boolean bl6 = false;
                                    l2 = $this$copyOrMoveRecursively_u24lambda_u242_u240.writeAll((Source)$this$copyOrMoveRecursively_u24lambda_u242);
                                }
                                catch (Throwable t$iv$iv) {
                                    try {
                                        thrown$iv$iv2 = t$iv$iv;
                                        l2 = null;
                                        break block41;
                                    }
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                    finally {
                                        block42: {
                                            try {
                                                Closeable closeable = $this$use$iv$iv2;
                                                if (closeable != null) {
                                                    closeable.close();
                                                }
                                            }
                                            catch (Throwable t$iv$iv2) {
                                                if (thrown$iv$iv2 == null) {
                                                    thrown$iv$iv2 = t$iv$iv2;
                                                    break block42;
                                                }
                                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv2, (Throwable)t$iv$iv2);
                                            }
                                        }
                                    }
                                }
                                try {
                                    Closeable closeable = $this$use$iv$iv2;
                                    if (closeable != null) {
                                        closeable.close();
                                    }
                                }
                                catch (Throwable t$iv$iv) {
                                    thrown$iv$iv2 = t$iv$iv;
                                }
                            }
                            Long result$iv$iv = l2;
                            Throwable throwable = thrown$iv$iv2;
                            if (throwable != null) {
                                throw throwable;
                            }
                            l = ((Number)result$iv$iv).longValue();
                        }
                        catch (Throwable t$iv$iv) {
                            try {
                                thrown$iv$iv = t$iv$iv;
                                l = null;
                                break block43;
                            }
                            catch (Throwable throwable2) {
                                throw throwable2;
                            }
                            finally {
                                block44: {
                                    try {
                                        Closeable closeable = $this$use$iv$iv;
                                        if (closeable != null) {
                                            closeable.close();
                                        }
                                    }
                                    catch (Throwable t$iv$iv3) {
                                        if (thrown$iv$iv == null) {
                                            thrown$iv$iv = t$iv$iv3;
                                            break block44;
                                        }
                                        ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv3);
                                    }
                                }
                            }
                        }
                        try {
                            Closeable closeable = $this$use$iv$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv$iv) {
                            thrown$iv$iv = t$iv$iv;
                        }
                    }
                    Long result$iv$iv = l;
                    Throwable throwable = thrown$iv$iv;
                    if (throwable != null) {
                        throw throwable;
                    }
                }
            }
            if (!deleteSource) return;
            $this$copyOrMoveRecursively.delete(sourcePath);
            return;
        }
        catch (Exception e) {
            String op = deleteSource ? "move" : "copy";
            String message2 = StringsKt.trimMargin$default((String)("Failed to " + op + " " + sourcePath + " -> " + targetPath + "\n            |  " + File_infoKt.info($this$copyOrMoveRecursively, sourcePath) + "\n            |  " + File_infoKt.info(targetFileSystem, targetPath) + "\n        "), null, (int)1, null);
            throw new IOException(message2, e);
        }
    }

    public static final void copyRecursively(@NotNull FileSystem $this$copyRecursively, @NotNull Path sourcePath, @NotNull Path targetPath, @NotNull FileSystem targetFileSystem, boolean overwriteExisting, int retries) {
        Intrinsics.checkNotNullParameter((Object)$this$copyRecursively, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        Intrinsics.checkNotNullParameter((Object)targetFileSystem, (String)"targetFileSystem");
        Copy_and_moveKt.copyOrMoveRecursivelyWithRetries($this$copyRecursively, sourcePath, targetPath, false, targetFileSystem, retries, overwriteExisting);
    }

    public static /* synthetic */ void copyRecursively$default(FileSystem fileSystem, Path path2, Path path3, FileSystem fileSystem2, boolean bl, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            fileSystem2 = fileSystem;
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        if ((n2 & 0x10) != 0) {
            n = 3;
        }
        Copy_and_moveKt.copyRecursively(fileSystem, path2, path3, fileSystem2, bl, n);
    }

    public static final void moveRecursively(@NotNull FileSystem $this$moveRecursively, @NotNull Path sourcePath, @NotNull Path targetPath, @NotNull FileSystem targetFileSystem, boolean overwriteExisting, int retries) {
        Intrinsics.checkNotNullParameter((Object)$this$moveRecursively, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        Intrinsics.checkNotNullParameter((Object)targetFileSystem, (String)"targetFileSystem");
        Copy_and_moveKt.copyOrMoveRecursivelyWithRetries($this$moveRecursively, sourcePath, targetPath, true, targetFileSystem, retries, overwriteExisting);
    }

    public static /* synthetic */ void moveRecursively$default(FileSystem fileSystem, Path path2, Path path3, FileSystem fileSystem2, boolean bl, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            fileSystem2 = fileSystem;
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        if ((n2 & 0x10) != 0) {
            n = 3;
        }
        Copy_and_moveKt.moveRecursively(fileSystem, path2, path3, fileSystem2, bl, n);
    }

    public static final void safeAtomicMove(@NotNull FileSystem $this$safeAtomicMove, @NotNull Path sourcePath, @NotNull Path targetPath, boolean overwriteExisting, int retries) {
        Intrinsics.checkNotNullParameter((Object)$this$safeAtomicMove, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        try {
            Logger.INSTANCE.info("Moving " + sourcePath + " -> " + targetPath + " atomically");
            $this$safeAtomicMove.atomicMove(sourcePath, targetPath);
            Logger.INSTANCE.info("Moved " + sourcePath + " -> " + targetPath + " atomically");
        }
        catch (IOException e) {
            Logger.INSTANCE.info("Atomic move from " + sourcePath + " to " + targetPath + " failed with message <" + e.getMessage() + ">, proceeding with copy-and-delete");
            Copy_and_moveKt.moveRecursively$default($this$safeAtomicMove, sourcePath, targetPath, null, overwriteExisting, retries, 4, null);
            Logger.INSTANCE.info("Copied " + sourcePath + " to " + targetPath + ", deleting " + sourcePath);
        }
    }

    public static /* synthetic */ void safeAtomicMove$default(FileSystem fileSystem, Path path2, Path path3, boolean bl, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            n = 3;
        }
        Copy_and_moveKt.safeAtomicMove(fileSystem, path2, path3, bl, n);
    }

    public static final void unsafeRename(@NotNull Path sourcePath, @NotNull Path targetPath) {
        Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING};
        Files.move(sourcePath.toNioPath(), targetPath.toNioPath(), copyOptionArray);
    }
}

