/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common.extensions;

import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nURIExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 URIExtensions.kt\ncom/jetbrains/toolbox/common/extensions/URIExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1617#2,9:152\n1869#2:161\n1563#2:163\n1634#2,3:164\n1870#2:168\n1626#2:169\n1222#2,2:170\n1252#2,4:172\n1#3:162\n1#3:167\n*S KotlinDebug\n*F\n+ 1 URIExtensions.kt\ncom/jetbrains/toolbox/common/extensions/URIExtensionsKt\n*L\n134#1:152,9\n134#1:161\n134#1:163\n134#1:164,3\n134#1:168\n134#1:169\n135#1:170,2\n135#1:172,4\n134#1:167\n*E\n"})
public final class URIExtensionsKt {
    @NotNull
    public static final Map<String, String> parseQuery(@NotNull URI $this$parseQuery) {
        Intrinsics.checkNotNullParameter((Object)$this$parseQuery, (String)"<this>");
        return URIExtensionsKt.parseParameters($this$parseQuery.getRawQuery());
    }

    @NotNull
    public static final Map<String, String> parseFragment(@NotNull URI $this$parseFragment) {
        Intrinsics.checkNotNullParameter((Object)$this$parseFragment, (String)"<this>");
        return URIExtensionsKt.parseParameters($this$parseFragment.getRawFragment());
    }

    @NotNull
    public static final URI withFragment(@NotNull URI $this$withFragment, @Nullable String newFragment) {
        Intrinsics.checkNotNullParameter((Object)$this$withFragment, (String)"<this>");
        return new URI($this$withFragment.getScheme(), $this$withFragment.getUserInfo(), $this$withFragment.getHost(), $this$withFragment.getPort(), $this$withFragment.getPath(), $this$withFragment.getQuery(), newFragment);
    }

    @NotNull
    public static final URI withPath(@NotNull URI $this$withPath, @Nullable String newPath) {
        Intrinsics.checkNotNullParameter((Object)$this$withPath, (String)"<this>");
        return new URI($this$withPath.getScheme(), $this$withPath.getUserInfo(), $this$withPath.getHost(), $this$withPath.getPort(), newPath, $this$withPath.getQuery(), $this$withPath.getFragment());
    }

    @NotNull
    public static final URI withQuery(@NotNull URI $this$withQuery, @Nullable String newQuery) {
        Intrinsics.checkNotNullParameter((Object)$this$withQuery, (String)"<this>");
        return new URI($this$withQuery.getScheme(), $this$withQuery.getUserInfo(), $this$withQuery.getHost(), $this$withQuery.getPort(), $this$withQuery.getPath(), newQuery, $this$withQuery.getFragment());
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, String> parseParameters(String input) {
        void $this$associateByTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        String[] stringArray = (String[])input;
        if (stringArray == null || StringsKt.isBlank((CharSequence)stringArray)) {
            return MapsKt.emptyMap();
        }
        stringArray = new String[]{"&"};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)input, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<List> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            List list2;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String item2 = (String)element$iv$iv;
            boolean bl2 = false;
            Object object = new String[]{"="};
            Object it = object = StringsKt.split$default((CharSequence)item2, (String[])object, (boolean)false, (int)2, (int)2, null);
            boolean bl32 = false;
            Object object2 = it.size() == 2 ? object : null;
            if (object2 != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)object2;
                boolean $i$f$map = false;
                Iterable bl32 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl4 = false;
                    String string2 = URLDecoder.decode((String)it2, Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"decode(...)");
                    collection.add(StringsKt.replace$default((String)string2, (char)'+', (char)' ', (boolean)false, (int)4, null));
                }
                list2 = (List)destination$iv$iv2;
            } else {
                list2 = null;
            }
            if (list2 == null) continue;
            List it$iv$iv = list2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            element$iv$iv$iv = (List)element$iv$iv;
            Map map2 = destination$iv$iv3;
            boolean bl = false;
            List it = (List)element$iv$iv;
            String string = (String)it.get(0);
            boolean bl6 = false;
            String string3 = (String)it.get(1);
            map2.put(string, string3);
        }
        return destination$iv$iv3;
    }

    @NotNull
    public static final URI addFragmentParameter(@NotNull URI $this$addFragmentParameter, @NotNull String key, @Nullable String value2) {
        Intrinsics.checkNotNullParameter((Object)$this$addFragmentParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value2 == null) {
            return $this$addFragmentParameter;
        }
        String newFragment = URIExtensionsKt.toParameters(MapsKt.plus(URIExtensionsKt.parseFragment($this$addFragmentParameter), (Pair)TuplesKt.to((Object)key, (Object)value2)));
        return URIExtensionsKt.withFragment($this$addFragmentParameter, newFragment);
    }

    @NotNull
    public static final URI addFragmentParameters(@NotNull URI $this$addFragmentParameters, @NotNull Map<String, String> parameters) {
        Intrinsics.checkNotNullParameter((Object)$this$addFragmentParameters, (String)"<this>");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        return URIExtensionsKt.withFragment($this$addFragmentParameters, URIExtensionsKt.toParameters(MapsKt.plus(URIExtensionsKt.parseFragment($this$addFragmentParameters), parameters)));
    }

    private static final String toParameters(Map<String, String> $this$toParameters) {
        return CollectionsKt.joinToString$default((Iterable)MapsKt.toList($this$toParameters), (CharSequence)"&", null, null, (int)0, null, URIExtensionsKt::toParameters$lambda$0, (int)30, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean belongsToDomain(@NotNull URI $this$belongsToDomain, @NotNull String domain) {
        Intrinsics.checkNotNullParameter((Object)$this$belongsToDomain, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        if (Intrinsics.areEqual((Object)$this$belongsToDomain.getHost(), (Object)domain)) return true;
        String string = $this$belongsToDomain.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        if (!StringsKt.endsWith$default((String)string, (String)("." + domain), (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final CharSequence toParameters$lambda$0(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFirst() + "=" + it.getSecond();
    }
}

