/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common;

import com.jetbrains.toolbox.common.WellKnownPaths;
import com.jetbrains.toolbox.common.platform.OS;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class UnixDomainSocketsUtil {
    @NotNull
    public static final UnixDomainSocketsUtil INSTANCE = new UnixDomainSocketsUtil();

    private UnixDomainSocketsUtil() {
    }

    @NotNull
    public final Path getSocketPath(@NotNull WellKnownPaths $this$getSocketPath, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)$this$getSocketPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Path inCache = $this$getSocketPath.getToolboxCacheLocation().resolve(fileName);
        if (UnixDomainSocketsUtil.isValidPath$default(this, inCache, null, 2, null)) {
            return inCache;
        }
        String string = System.getProperty("java.io.tmpdir");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        Path tmpDir = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null);
        Path inTemp = tmpDir.resolve(fileName);
        if (UnixDomainSocketsUtil.isValidPath$default(this, inTemp, null, 2, null)) {
            return inTemp;
        }
        throw new IllegalStateException(("Both " + $this$getSocketPath.getToolboxCacheLocation() + " and " + tmpDir + " are not suitable to create a valid unix domain socket with the fileName " + fileName).toString());
    }

    public final boolean isValidPath(@NotNull Path socketFile, @NotNull Function2<? super Throwable, ? super String, Unit> warnLogger) {
        java.nio.file.Path path2;
        Intrinsics.checkNotNullParameter((Object)socketFile, (String)"socketFile");
        Intrinsics.checkNotNullParameter(warnLogger, (String)"warnLogger");
        try {
            path2 = socketFile.toNioPath();
        }
        catch (Throwable e) {
            warnLogger.invoke((Object)e, (Object)("Failed to convert okio path " + socketFile + " to a valid nio path"));
            return false;
        }
        java.nio.file.Path nioPath = path2;
        String string = ((Object)nioPath.toAbsolutePath()).toString();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        int byteLength = byArray.length + 1;
        return switch (WhenMappings.$EnumSwitchMapping$0[OS.INSTANCE.getType().ordinal()]) {
            case 1 -> {
                if (byteLength < 108) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (byteLength < 108) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (byteLength < 104) {
                    yield true;
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ boolean isValidPath$default(UnixDomainSocketsUtil unixDomainSocketsUtil, Path path2, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = UnixDomainSocketsUtil::isValidPath$lambda$0;
        }
        return unixDomainSocketsUtil.isValidPath(path2, (Function2<? super Throwable, ? super String, Unit>)function2);
    }

    private static final Unit isValidPath$lambda$0(Throwable e, String m) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Logger.INSTANCE.warn(e, m);
        return Unit.INSTANCE;
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.Type.values().length];
            try {
                nArray[OS.Type.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Mac.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

