/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common;

import com.jetbrains.toolbox.common.StateMachine;
import com.jetbrains.toolbox.common.Transition;
import com.jetbrains.toolbox.common.TransitionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nStateMachineImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateMachineImpl.kt\ncom/jetbrains/toolbox/common/StateMachineImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n65#1,5:75\n827#2:80\n855#2,2:81\n*S KotlinDebug\n*F\n+ 1 StateMachineImpl.kt\ncom/jetbrains/toolbox/common/StateMachineImpl\n*L\n45#1:75,5\n56#1:80\n56#1:81,2\n*E\n"})
public final class StateMachineImpl<State, Event, QueueableEvent extends Event, MultiQueueableEvent extends QueueableEvent>
implements StateMachine<State, Event, QueueableEvent, MultiQueueableEvent> {
    @NotNull
    private final Map<KClass<? extends State>, Map<KClass<? extends Event>, Transition<State, Event, State>>> transitions;
    @NotNull
    private final KClass<? extends MultiQueueableEvent> multiQueueableEventClass;
    @NotNull
    private final MutableStateFlow<State> _state;
    @NotNull
    private final StateFlow<State> state;
    @NotNull
    private final MutableSharedFlow<TransitionEvent<State, Event>> _events;
    @NotNull
    private final SharedFlow<TransitionEvent<State, Event>> events;
    @NotNull
    private final AtomicReference<List<Event>> pendingEvents;

    public StateMachineImpl(@NotNull Map<KClass<? extends State>, ? extends Map<KClass<? extends Event>, Transition<State, Event, State>>> transitions2, @NotNull State initialState, @NotNull KClass<? extends MultiQueueableEvent> multiQueueableEventClass) {
        Intrinsics.checkNotNullParameter(transitions2, (String)"transitions");
        Intrinsics.checkNotNullParameter(initialState, (String)"initialState");
        Intrinsics.checkNotNullParameter(multiQueueableEventClass, (String)"multiQueueableEventClass");
        this.transitions = transitions2;
        this.multiQueueableEventClass = multiQueueableEventClass;
        this._state = StateFlowKt.MutableStateFlow(initialState);
        this.state = FlowKt.asStateFlow(this._state);
        this._events = SharedFlowKt.MutableSharedFlow$default((int)0, (int)8, null, (int)5, null);
        this.events = FlowKt.asSharedFlow(this._events);
        this.pendingEvents = new AtomicReference<List>(CollectionsKt.emptyList());
    }

    @Override
    @NotNull
    public StateFlow<State> getState() {
        return this.state;
    }

    @Override
    @NotNull
    public SharedFlow<TransitionEvent<State, Event>> getEvents() {
        return this.events;
    }

    @Override
    public void process(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (!this.processSingle(event)) {
            throw new IllegalStateException((Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName() + " is not supported in state " + Reflection.getOrCreateKotlinClass(this._state.getValue().getClass()).getSimpleName()).toString());
        }
        this.processPending();
    }

    @Override
    public void queue(@NotNull QueueableEvent event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        this.pendingEvents.updateAndGet(arg_0 -> StateMachineImpl.queue$lambda$0(this, event, arg_0));
        this.processPending();
    }

    private final boolean processSingle(Event event) {
        Object source;
        Map<KClass<Event>, Transition<State, Event, State>> map2;
        Map<KClass<Event>, Transition<State, Event, State>> transition;
        Object nextValue$iv;
        Object prevValue$iv;
        StateMachineImpl stateMachineImpl = this;
        MutableStateFlow<State> $this$getAndUpdateAndGet$iv = this._state;
        boolean $i$f$getAndUpdateAndGet = false;
        do {
            source = prevValue$iv = $this$getAndUpdateAndGet$iv.getValue();
            boolean bl = false;
            Map<KClass<Event>, Transition<State, Event, State>> stateTransitions = this.transitions.get(Reflection.getOrCreateKotlinClass(source.getClass()));
            map2 = stateTransitions;
            if (map2 != null && (map2 = map2.get(Reflection.getOrCreateKotlinClass(event.getClass()))) != null) continue;
            return false;
        } while (!$this$getAndUpdateAndGet$iv.compareAndSet(prevValue$iv, nextValue$iv = ((Transition)((Object)(transition = map2))).getTransit().invoke(source, event)));
        Pair pair = TuplesKt.to((Object)prevValue$iv, (Object)nextValue$iv);
        Object prev = pair.component1();
        Object next2 = pair.component2();
        this._events.tryEmit(new TransitionEvent<Object, Event>(prev, next2, event));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void processPending() {
        List<Event> queue;
        List unprocessed;
        StateMachineImpl stateMachineImpl = this;
        do {
            void $this$filterNotTo$iv$iv;
            queue = stateMachineImpl.pendingEvents.getAndUpdate(StateMachineImpl::processPending$lambda$0);
            Intrinsics.checkNotNull(queue);
            Iterable $this$filterNot$iv = queue;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            Iterator iterator2 = $this$filterNotTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv;
                Object p0 = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (stateMachineImpl.processSingle(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            unprocessed = (List)destination$iv$iv;
            if (unprocessed.isEmpty()) {
                return;
            }
            stateMachineImpl.pendingEvents.updateAndGet(arg_0 -> StateMachineImpl.processPending$lambda$1(unprocessed, arg_0));
        } while (unprocessed.size() != queue.size());
    }

    private static final List queue$lambda$0(StateMachineImpl this$0, Object $event, List it) {
        List list2;
        if (this$0.multiQueueableEventClass.isInstance($event) || !it.contains($event)) {
            Intrinsics.checkNotNull((Object)it);
            list2 = CollectionsKt.plus((Collection)it, (Object)$event);
        } else {
            list2 = it;
        }
        return list2;
    }

    private static final List processPending$lambda$0(List it) {
        return CollectionsKt.emptyList();
    }

    private static final List processPending$lambda$1(List $unprocessed, List it) {
        Collection collection = $unprocessed;
        Intrinsics.checkNotNull((Object)it);
        return CollectionsKt.plus((Collection)collection, (Iterable)it);
    }
}

