/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common;

import com.jetbrains.toolbox.common.RateLimiter;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;

public final class SimpleRateLimiter
implements RateLimiter {
    private final long gracePeriod;
    private final long cooldown;
    private final int requestsLimit;
    @NotNull
    private final Clock clock;
    @NotNull
    private final AtomicReference<Instant> nextRateLimitPeriodStart;
    @NotNull
    private final AtomicInteger requestsInPeriod;

    private SimpleRateLimiter(long gracePeriod, long cooldown, int requestsLimit, Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.gracePeriod = gracePeriod;
        this.cooldown = cooldown;
        this.requestsLimit = requestsLimit;
        this.clock = clock;
        this.nextRateLimitPeriodStart = new AtomicReference<Instant>(Instant.Companion.getDISTANT_PAST());
        this.requestsInPeriod = new AtomicInteger(0);
    }

    public /* synthetic */ SimpleRateLimiter(long l, long l2, int n, Clock clock, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            l = DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS);
        }
        if ((n2 & 2) != 0) {
            l2 = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS);
        }
        if ((n2 & 4) != 0) {
            n = 3;
        }
        if ((n2 & 8) != 0) {
            clock = (Clock)Clock.System.INSTANCE;
        }
        this(l, l2, n, clock, null);
    }

    @Override
    public boolean ensureRateLimit() {
        Instant now2 = this.clock.now();
        Instant nextPeriodStart = this.nextRateLimitPeriodStart.get();
        if (nextPeriodStart.compareTo(now2) > 0) {
            return false;
        }
        if (nextPeriodStart.plus-LRDsOJo(this.gracePeriod).compareTo(now2) <= 0 && this.nextRateLimitPeriodStart.compareAndSet(nextPeriodStart, now2)) {
            this.requestsInPeriod.set(0);
        }
        if (this.requestsInPeriod.incrementAndGet() > this.requestsLimit) {
            if (this.nextRateLimitPeriodStart.compareAndSet(nextPeriodStart, now2.plus-LRDsOJo(this.cooldown))) {
                this.requestsInPeriod.set(0);
            }
            return false;
        }
        return true;
    }

    public /* synthetic */ SimpleRateLimiter(long gracePeriod, long cooldown, int requestsLimit, Clock clock, DefaultConstructorMarker $constructor_marker) {
        this(gracePeriod, cooldown, requestsLimit, clock);
    }
}

