/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ai.chat.model;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface LlmResponse {

    public static final class FunctionCall
    implements LlmResponse {
        @Nullable
        private final String id;
        @Nullable
        private final String name;
        @NotNull
        private final String text;

        public FunctionCall(@Nullable String id, @Nullable String name2, @NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.id = id;
            this.name = name2;
            this.text = text2;
        }

        @Nullable
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public String toString() {
            return "FunctionCall(id=" + this.id + ", name=" + this.name + ", text=" + this.text + ")";
        }

        public int hashCode() {
            int result2 = this.id == null ? 0 : this.id.hashCode();
            result2 = result2 * 31 + (this.name == null ? 0 : this.name.hashCode());
            result2 = result2 * 31 + this.text.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FunctionCall)) {
                return false;
            }
            FunctionCall functionCall = (FunctionCall)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)functionCall.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)functionCall.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.text, (Object)functionCall.text);
        }
    }

    public static final class Message
    implements LlmResponse {
        @NotNull
        private final String text;

        public Message(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.text = text2;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public String toString() {
            return "Message(text=" + this.text + ")";
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Message)) {
                return false;
            }
            Message message2 = (Message)other;
            return Intrinsics.areEqual((Object)this.text, (Object)message2.text);
        }
    }
}

