/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.accounts.space;

import com.jetbrains.toolbox.UtilKt;
import com.jetbrains.toolbox.accounts.SpaceAccount;
import com.jetbrains.toolbox.accounts.space.SpaceServiceGenerator;
import com.jetbrains.toolbox.datamodel.ServiceInstance;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class SpaceServiceInstance
implements ServiceInstance {
    @NotNull
    private final SpaceAccount account;
    @NotNull
    private final SpaceServiceGenerator parent;
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final String instanceUrl;

    public SpaceServiceInstance(@NotNull SpaceAccount account2, @NotNull SpaceServiceGenerator parent) {
        Intrinsics.checkNotNullParameter((Object)account2, (String)"account");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.account = account2;
        this.parent = parent;
        this.id = this.account.getId();
        this.name = this.account.getOrganizationName();
        this.instanceUrl = this.account.getInstanceUrl();
    }

    @NotNull
    public SpaceServiceGenerator getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getInstanceUrl() {
        return this.instanceUrl;
    }

    @Override
    public boolean matches(@NotNull String filter2) {
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        return UtilKt.valueMatches(this.account.getDomain(), filter2) || UtilKt.valueMatches(this.account.getFullName(), filter2);
    }
}

