/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.accounts.oauth;

import com.jetbrains.toolbox.accounts.AuthConfiguration;
import com.jetbrains.toolbox.accounts.oauth.OAuth2Client;
import com.jetbrains.toolbox.accounts.oauth.OAuth2ClientImpl;
import com.jetbrains.toolbox.accounts.oauth.SecurityCodeProvider;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Clock;
import org.jetbrains.annotations.NotNull;

public final class ClientProvider {
    @NotNull
    private final Clock clock;
    @NotNull
    private final SecurityCodeProvider securityCodeProvider;

    public ClientProvider(@NotNull Clock clock, @NotNull SecurityCodeProvider securityCodeProvider) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)securityCodeProvider, (String)"securityCodeProvider");
        this.clock = clock;
        this.securityCodeProvider = securityCodeProvider;
    }

    @NotNull
    public final OAuth2Client createClient(@NotNull AuthConfiguration authConfiguration) {
        Intrinsics.checkNotNullParameter((Object)authConfiguration, (String)"authConfiguration");
        this.securityCodeProvider.newState();
        String string = this.securityCodeProvider.getState();
        String string2 = this.securityCodeProvider.newCodeChallenge();
        String string3 = this.securityCodeProvider.getCodeVerifier();
        Clock clock = this.clock;
        return new OAuth2ClientImpl(string, string3, string2, clock, authConfiguration, null, 32, null);
    }
}

