/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.accounts.google;

import com.jetbrains.toolbox.accounts.GoogleAccount;
import com.jetbrains.toolbox.accounts.GoogleAccountSecureToken;
import com.jetbrains.toolbox.accounts.RefreshConfigurationImpl;
import com.jetbrains.toolbox.accounts.oauth.OAuth2Token;
import com.jetbrains.toolbox.accounts.oauth.OAuthTokenRefresherImpl;
import com.jetbrains.toolbox.api.core.auth.ContentType;
import com.jetbrains.toolbox.api.core.auth.RefreshConfiguration;
import com.jetbrains.toolbox.network.BasicDownloadManager;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Clock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoogleTokenRefresher
extends OAuthTokenRefresherImpl<GoogleAccount, GoogleAccountSecureToken> {
    public GoogleTokenRefresher(@NotNull BasicDownloadManager downloadManager, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        super("Google", downloadManager, clock);
    }

    @Override
    @NotNull
    protected RefreshConfiguration createRefreshConfiguration(@NotNull GoogleAccount account2) {
        Intrinsics.checkNotNullParameter((Object)account2, (String)"account");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"grant_type", (Object)"refresh_token"), TuplesKt.to((Object)"client_id", (Object)"354544294435-becvhmgtor03n8hre52vtrac6r5qjnjc.apps.googleusercontent.com"), TuplesKt.to((Object)"client_secret", (Object)"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")};
        return new RefreshConfigurationImpl("https://oauth2.googleapis.com/token", MapsKt.mapOf((Pair[])pairArray), null, ContentType.FORM_URL_ENCODED, false, 16, null);
    }

    @Override
    @NotNull
    protected GoogleAccountSecureToken updateToken(@NotNull GoogleAccountSecureToken previousToken, @NotNull OAuth2Token newToken2, @Nullable String requestId) {
        Intrinsics.checkNotNullParameter((Object)previousToken, (String)"previousToken");
        Intrinsics.checkNotNullParameter((Object)newToken2, (String)"newToken");
        return previousToken.updateFrom(newToken2, requestId);
    }
}

