/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.accounts;

import com.jetbrains.toolbox.accounts.AuthLandingAction;
import com.jetbrains.toolbox.api.core.auth.ContentType;
import java.util.Map;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AuthConfiguration {
    @NotNull
    private final Map<String, String> authParams;
    @NotNull
    private final Map<String, String> tokenParams;
    @NotNull
    private final String authUrl;
    @Nullable
    private final String redirectUrl;
    @NotNull
    private final String tokenUrl;
    private final boolean manual;
    @NotNull
    private final AuthLandingAction landingAction;
    @NotNull
    private final String baseUrl;
    @Nullable
    private final String authHeader;
    @NotNull
    private final String codeChallengeParamName;
    @Nullable
    private final String codeChallengeMethod;
    @NotNull
    private final String verifierParamName;
    @NotNull
    private final ContentType contentType;
    @Nullable
    private final String requestId;

    public AuthConfiguration(@NotNull Map<String, String> authParams, @NotNull Map<String, String> tokenParams, @NotNull String authUrl, @Nullable String redirectUrl, @NotNull String tokenUrl, boolean manual, @NotNull AuthLandingAction landingAction, @NotNull String baseUrl, @Nullable String authHeader2, @NotNull String codeChallengeParamName, @Nullable String codeChallengeMethod, @NotNull String verifierParamName, @NotNull ContentType contentType, @Nullable String requestId) {
        Intrinsics.checkNotNullParameter(authParams, (String)"authParams");
        Intrinsics.checkNotNullParameter(tokenParams, (String)"tokenParams");
        Intrinsics.checkNotNullParameter((Object)authUrl, (String)"authUrl");
        Intrinsics.checkNotNullParameter((Object)tokenUrl, (String)"tokenUrl");
        Intrinsics.checkNotNullParameter((Object)((Object)landingAction), (String)"landingAction");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)codeChallengeParamName, (String)"codeChallengeParamName");
        Intrinsics.checkNotNullParameter((Object)verifierParamName, (String)"verifierParamName");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.authParams = authParams;
        this.tokenParams = tokenParams;
        this.authUrl = authUrl;
        this.redirectUrl = redirectUrl;
        this.tokenUrl = tokenUrl;
        this.manual = manual;
        this.landingAction = landingAction;
        this.baseUrl = baseUrl;
        this.authHeader = authHeader2;
        this.codeChallengeParamName = codeChallengeParamName;
        this.codeChallengeMethod = codeChallengeMethod;
        this.verifierParamName = verifierParamName;
        this.contentType = contentType;
        this.requestId = requestId;
    }

    public /* synthetic */ AuthConfiguration(Map map2, Map map3, String string, String string2, String string3, boolean bl, AuthLandingAction authLandingAction, String string4, String string5, String string6, String string7, String string8, ContentType contentType, String string9, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            authLandingAction = AuthLandingAction.SHOW_WINDOW;
        }
        if ((n & 0x100) != 0) {
            string5 = null;
        }
        if ((n & 0x200) != 0) {
            string6 = "code_challenge";
        }
        if ((n & 0x400) != 0) {
            string7 = "S256";
        }
        if ((n & 0x800) != 0) {
            string8 = "code_verifier";
        }
        if ((n & 0x1000) != 0) {
            contentType = ContentType.FORM_URL_ENCODED;
        }
        if ((n & 0x2000) != 0) {
            string9 = null;
        }
        this(map2, map3, string, string2, string3, bl, authLandingAction, string4, string5, string6, string7, string8, contentType, string9);
    }

    @NotNull
    public final Map<String, String> getAuthParams() {
        return this.authParams;
    }

    @NotNull
    public final Map<String, String> getTokenParams() {
        return this.tokenParams;
    }

    @NotNull
    public final String getAuthUrl() {
        return this.authUrl;
    }

    @Nullable
    public final String getRedirectUrl() {
        return this.redirectUrl;
    }

    @NotNull
    public final String getTokenUrl() {
        return this.tokenUrl;
    }

    public final boolean getManual() {
        return this.manual;
    }

    @NotNull
    public final AuthLandingAction getLandingAction() {
        return this.landingAction;
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @Nullable
    public final String getAuthHeader() {
        return this.authHeader;
    }

    @NotNull
    public final String getCodeChallengeParamName() {
        return this.codeChallengeParamName;
    }

    @Nullable
    public final String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    @NotNull
    public final String getVerifierParamName() {
        return this.verifierParamName;
    }

    @NotNull
    public final ContentType getContentType() {
        return this.contentType;
    }

    @Nullable
    public final String getRequestId() {
        return this.requestId;
    }

    @NotNull
    public final AuthConfiguration copy(@NotNull Map<String, String> authParams, @NotNull Map<String, String> tokenParams, @NotNull String authUrl, @Nullable String redirectUrl, @NotNull String tokenUrl, boolean manual, @NotNull AuthLandingAction landingAction, @NotNull String baseUrl, @Nullable String authHeader2, @NotNull String codeChallengeParamName, @Nullable String codeChallengeMethod, @NotNull String verifierParamName, @NotNull ContentType contentType, @Nullable String requestId) {
        Intrinsics.checkNotNullParameter(authParams, (String)"authParams");
        Intrinsics.checkNotNullParameter(tokenParams, (String)"tokenParams");
        Intrinsics.checkNotNullParameter((Object)authUrl, (String)"authUrl");
        Intrinsics.checkNotNullParameter((Object)tokenUrl, (String)"tokenUrl");
        Intrinsics.checkNotNullParameter((Object)((Object)landingAction), (String)"landingAction");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)codeChallengeParamName, (String)"codeChallengeParamName");
        Intrinsics.checkNotNullParameter((Object)verifierParamName, (String)"verifierParamName");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        return new AuthConfiguration(authParams, tokenParams, authUrl, redirectUrl, tokenUrl, manual, landingAction, baseUrl, authHeader2, codeChallengeParamName, codeChallengeMethod, verifierParamName, contentType, requestId);
    }

    public static /* synthetic */ AuthConfiguration copy$default(AuthConfiguration authConfiguration, Map map2, Map map3, String string, String string2, String string3, boolean bl, AuthLandingAction authLandingAction, String string4, String string5, String string6, String string7, String string8, ContentType contentType, String string9, int n, Object object) {
        if ((n & 1) != 0) {
            map2 = authConfiguration.authParams;
        }
        if ((n & 2) != 0) {
            map3 = authConfiguration.tokenParams;
        }
        if ((n & 4) != 0) {
            string = authConfiguration.authUrl;
        }
        if ((n & 8) != 0) {
            string2 = authConfiguration.redirectUrl;
        }
        if ((n & 0x10) != 0) {
            string3 = authConfiguration.tokenUrl;
        }
        if ((n & 0x20) != 0) {
            bl = authConfiguration.manual;
        }
        if ((n & 0x40) != 0) {
            authLandingAction = authConfiguration.landingAction;
        }
        if ((n & 0x80) != 0) {
            string4 = authConfiguration.baseUrl;
        }
        if ((n & 0x100) != 0) {
            string5 = authConfiguration.authHeader;
        }
        if ((n & 0x200) != 0) {
            string6 = authConfiguration.codeChallengeParamName;
        }
        if ((n & 0x400) != 0) {
            string7 = authConfiguration.codeChallengeMethod;
        }
        if ((n & 0x800) != 0) {
            string8 = authConfiguration.verifierParamName;
        }
        if ((n & 0x1000) != 0) {
            contentType = authConfiguration.contentType;
        }
        if ((n & 0x2000) != 0) {
            string9 = authConfiguration.requestId;
        }
        return authConfiguration.copy(map2, map3, string, string2, string3, bl, authLandingAction, string4, string5, string6, string7, string8, contentType, string9);
    }

    @NotNull
    public String toString() {
        return "AuthConfiguration(authParams=" + this.authParams + ", tokenParams=" + this.tokenParams + ", authUrl=" + this.authUrl + ", redirectUrl=" + this.redirectUrl + ", tokenUrl=" + this.tokenUrl + ", manual=" + this.manual + ", landingAction=" + this.landingAction + ", baseUrl=" + this.baseUrl + ", authHeader=" + this.authHeader + ", codeChallengeParamName=" + this.codeChallengeParamName + ", codeChallengeMethod=" + this.codeChallengeMethod + ", verifierParamName=" + this.verifierParamName + ", contentType=" + this.contentType + ", requestId=" + this.requestId + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.authParams).hashCode();
        result2 = result2 * 31 + ((Object)this.tokenParams).hashCode();
        result2 = result2 * 31 + this.authUrl.hashCode();
        result2 = result2 * 31 + (this.redirectUrl == null ? 0 : this.redirectUrl.hashCode());
        result2 = result2 * 31 + this.tokenUrl.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.manual);
        result2 = result2 * 31 + this.landingAction.hashCode();
        result2 = result2 * 31 + this.baseUrl.hashCode();
        result2 = result2 * 31 + (this.authHeader == null ? 0 : this.authHeader.hashCode());
        result2 = result2 * 31 + this.codeChallengeParamName.hashCode();
        result2 = result2 * 31 + (this.codeChallengeMethod == null ? 0 : this.codeChallengeMethod.hashCode());
        result2 = result2 * 31 + this.verifierParamName.hashCode();
        result2 = result2 * 31 + this.contentType.hashCode();
        result2 = result2 * 31 + (this.requestId == null ? 0 : this.requestId.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AuthConfiguration)) {
            return false;
        }
        AuthConfiguration authConfiguration = (AuthConfiguration)other;
        if (!Intrinsics.areEqual(this.authParams, authConfiguration.authParams)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tokenParams, authConfiguration.tokenParams)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.authUrl, (Object)authConfiguration.authUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.redirectUrl, (Object)authConfiguration.redirectUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tokenUrl, (Object)authConfiguration.tokenUrl)) {
            return false;
        }
        if (this.manual != authConfiguration.manual) {
            return false;
        }
        if (this.landingAction != authConfiguration.landingAction) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.baseUrl, (Object)authConfiguration.baseUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.authHeader, (Object)authConfiguration.authHeader)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.codeChallengeParamName, (Object)authConfiguration.codeChallengeParamName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.codeChallengeMethod, (Object)authConfiguration.codeChallengeMethod)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.verifierParamName, (Object)authConfiguration.verifierParamName)) {
            return false;
        }
        if (this.contentType != authConfiguration.contentType) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.requestId, (Object)authConfiguration.requestId);
    }
}

