/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.accounts;

import com.jetbrains.toolbox.accounts.Account;
import com.jetbrains.toolbox.accounts.AccountManager;
import com.jetbrains.toolbox.accounts.AccountManagerImpl;
import com.jetbrains.toolbox.accounts.AccountProvider;
import com.jetbrains.toolbox.accounts.AccountsJson;
import com.jetbrains.toolbox.accounts.AuthEvent;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nAccountManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccountManagerImpl.kt\ncom/jetbrains/toolbox/accounts/AccountManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Okio.kt\nokio/Okio__OkioKt\n+ 4 FileSystem.kt\nokio/FileSystem\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 7 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n*L\n1#1,137:1\n1563#2:138\n1634#2,3:139\n1617#2,9:165\n1869#2:174\n1870#2:176\n1626#2:177\n1869#2,2:186\n1761#2,3:238\n295#2,2:241\n66#3:142\n52#3,4:144\n60#3,10:149\n56#3,3:159\n71#3,3:162\n52#3,4:204\n60#3,10:209\n56#3,18:219\n67#4:143\n68#4:148\n80#4:201\n165#4:202\n81#4:203\n82#4:208\n1#5:175\n116#6,8:178\n125#6,2:188\n116#6,10:190\n126#6:237\n375#7:200\n*S KotlinDebug\n*F\n+ 1 AccountManagerImpl.kt\ncom/jetbrains/toolbox/accounts/AccountManagerImpl\n*L\n55#1:138\n55#1:139,3\n77#1:165,9\n77#1:174\n77#1:176\n77#1:177\n99#1:186,2\n124#1:238,3\n127#1:241,2\n72#1:142\n72#1:144,4\n72#1:149,10\n72#1:159,3\n72#1:162,3\n115#1:204,4\n115#1:209,10\n115#1:219,18\n72#1:143\n72#1:148\n115#1:201\n115#1:202\n115#1:203\n115#1:208\n77#1:175\n97#1:178,8\n97#1:188,2\n105#1:190,10\n105#1:237\n113#1:200\n*E\n"})
public final class AccountManagerImpl
implements AccountManager {
    @NotNull
    private final List<AccountProvider<Account>> providers;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Json accountJson;
    @NotNull
    private final Mutex accountFileMutex;
    @NotNull
    private final StateFlow<List<Account>> accounts;
    @NotNull
    private final SharedFlow<AuthEvent> authEvent;

    /*
     * WARNING - void declaration
     */
    public AccountManagerImpl(@Nullable Path accountsPath, @NotNull List<? extends AccountProvider<? extends Account>> providers, @NotNull CoroutineScope coroutineScope, @NotNull FileSystem fileSystem) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.providers = providers;
        this.fileSystem = fileSystem;
        this.accountJson = JsonKt.Json$default(null, AccountManagerImpl::accountJson$lambda$0, (int)1, null);
        this.accountFileMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.accounts = FlowKt.stateIn((Flow)FlowKt.channelFlow((Function2)((Function2)new Function2<ProducerScope<? super List<? extends Account>>, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ AccountManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                ProducerScope producerScope = (ProducerScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$forEach$iv;
                        ResultKt.throwOnFailure((Object)$result);
                        Iterable iterable = this.this$0.getProviders();
                        AccountManagerImpl accountManagerImpl = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            void $this$channelFlow;
                            AccountProvider provider2 = (AccountProvider)element$iv;
                            boolean bl = false;
                            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)$this$channelFlow), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((AccountProvider<? extends Account>)provider2, accountManagerImpl, (ProducerScope<? super List<? extends Account>>)$this$channelFlow, null){
                                int label;
                                final /* synthetic */ AccountProvider<Account> $provider;
                                final /* synthetic */ AccountManagerImpl this$0;
                                final /* synthetic */ ProducerScope<List<? extends Account>> $$this$channelFlow;
                                {
                                    this.$provider = $provider;
                                    this.this$0 = $receiver;
                                    this.$$this$channelFlow = $$this$channelFlow;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = FlowKt.collectLatest((Flow)((Flow)this.$provider.getAccounts()), (Function2)((Function2)new Function2<List<? extends Account>, Continuation<? super Unit>, Object>(this.this$0, this.$$this$channelFlow, null){
                                                Object L$0;
                                                int label;
                                                final /* synthetic */ AccountManagerImpl this$0;
                                                final /* synthetic */ ProducerScope<List<? extends Account>> $$this$channelFlow;
                                                {
                                                    this.this$0 = $receiver;
                                                    this.$$this$channelFlow = $$this$channelFlow;
                                                    super(2, $completion);
                                                }

                                                /*
                                                 * WARNING - void declaration
                                                 * Enabled force condition propagation
                                                 * Lifted jumps to return sites
                                                 */
                                                public final Object invokeSuspend(Object $result) {
                                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            void $this$flatMapTo$iv$iv;
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            Iterable $this$flatMap$iv = this.this$0.getProviders();
                                                            boolean $i$f$flatMap = false;
                                                            Iterable iterable = $this$flatMap$iv;
                                                            Collection destination$iv$iv = new ArrayList<E>();
                                                            boolean $i$f$flatMapTo = false;
                                                            for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                                                                AccountProvider it = (AccountProvider)element$iv$iv;
                                                                boolean bl = false;
                                                                Iterable list$iv$iv = (Iterable)it.getAccounts().getValue();
                                                                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                                                            }
                                                            List allAccounts = (List)destination$iv$iv;
                                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)allAccounts);
                                                            this.label = 1;
                                                            Object object2 = this.$$this$channelFlow.send((Object)allAccounts, (Continuation)this);
                                                            if (object2 != object) return Unit.INSTANCE;
                                                            return object;
                                                        }
                                                        case 1: {
                                                            List allAccounts = (List)this.L$0;
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            Object object2 = $result;
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(List<? extends Account> p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (Continuation)((Continuation)this));
                                            if (object2 != object) return Unit.INSTANCE;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(ProducerScope<? super List<? extends Account>> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)coroutineScope, (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)CollectionsKt.emptyList());
        Iterable iterable = this.getProviders();
        AccountManagerImpl accountManagerImpl = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void provider2;
            AccountProvider accountProvider2 = (AccountProvider)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(provider2.getAuthEvent());
        }
        accountManagerImpl.authEvent = FlowKt.shareIn$default((Flow)FlowKt.merge((Iterable)((List)destination$iv$iv)), (CoroutineScope)coroutineScope, (SharingStarted)SharingStarted.Companion.getEagerly(), (int)0, (int)4, null);
        if (accountsPath != null) {
            BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, accountsPath, null){
                int label;
                final /* synthetic */ AccountManagerImpl this$0;
                final /* synthetic */ Path $accountsPath;
                {
                    this.this$0 = $receiver;
                    this.$accountsPath = $accountsPath;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = AccountManagerImpl.access$loadAccounts(this.this$0, this.$accountsPath, (Continuation)this);
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl14
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl14:
                            // 2 sources

                            this.label = 2;
                            v1 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MILLISECONDS), (Continuation)((Continuation)this));
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl22
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl22:
                            // 2 sources

                            this.label = 3;
                            v2 = FlowKt.collectLatest((Flow)((Flow)this.this$0.getAccounts()), (Function2)((Function2)new Function2<List<? extends Account>, Continuation<? super Unit>, Object>(this.this$0, this.$accountsPath, null){
                                int label;
                                /* synthetic */ Object L$0;
                                final /* synthetic */ AccountManagerImpl this$0;
                                final /* synthetic */ Path $accountsPath;
                                {
                                    this.this$0 = $receiver;
                                    this.$accountsPath = $accountsPath;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    List list2 = (List)this.L$0;
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            void it;
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)it);
                                            this.label = 1;
                                            Object object2 = this.this$0.storeAccounts((List)it, this.$accountsPath, (Continuation<? super Unit>)((Continuation)this));
                                            if (object2 != object) return Unit.INSTANCE;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value2;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(List<? extends Account> p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v2 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl30
                        }
                        case 3: {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl30:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            Logger.INSTANCE.debug("Accounts file is not specified, accounts will not be persisted.");
        }
    }

    @Override
    @NotNull
    public List<AccountProvider<Account>> getProviders() {
        return this.providers;
    }

    @Override
    @NotNull
    public StateFlow<List<Account>> getAccounts() {
        return this.accounts;
    }

    @Override
    @NotNull
    public SharedFlow<AuthEvent> getAuthEvent() {
        return this.authEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final List<Account> loadAccountsJson(Path accountsPath) {
        try {
            List list2;
            String $i$a$-use-FileSystem$read$1$iv23332;
            Object thrown$iv$iv;
            block23: {
                void this_$iv;
                Logger.INSTANCE.info("Loading accounts from " + accountsPath);
                FileSystem fileSystem = this.fileSystem;
                Path file$iv = accountsPath;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                    boolean $i$a$-use-FileSystem$read$1$iv23332 = false;
                    BufferedSource $this$loadAccountsJson_u24lambda_u240 = it$iv;
                    boolean bl2 = false;
                    $i$a$-use-FileSystem$read$1$iv23332 = $this$loadAccountsJson_u24lambda_u240.readUtf8();
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        $i$a$-use-FileSystem$read$1$iv23332 = null;
                        break block23;
                    }
                    catch (Throwable t$iv$iv2) {
                        throw t$iv$iv2;
                    }
                    finally {
                        block24: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block24;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            String result$iv$iv = $i$a$-use-FileSystem$read$1$iv23332;
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            String json2 = result$iv$iv;
            if (((CharSequence)json2).length() == 0) {
                Logger.INSTANCE.info("File " + accountsPath + " is empty");
                list2 = CollectionsKt.emptyList();
                return list2;
            }
            JsonElement jsonElement = (JsonElement)JsonElementKt.getJsonObject((JsonElement)this.accountJson.parseToJsonElement(json2)).get((Object)"accounts");
            if (jsonElement != null && (jsonElement = JsonElementKt.getJsonArray((JsonElement)jsonElement)) != null) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = (Iterable)jsonElement;
                boolean $i$f$mapNotNull = false;
                thrown$iv$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Account it$iv$iv;
                    Account account2;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    JsonElement it = (JsonElement)element$iv$iv;
                    boolean bl3 = false;
                    try {
                        account2 = (Account)this.accountJson.decodeFromJsonElement((DeserializationStrategy)Account.Companion.serializer(), it);
                    }
                    catch (SerializationException e) {
                        Logger.INSTANCE.warn("Could not deserialize account: " + it + ", failed with error: " + e.getMessage());
                        account2 = null;
                    }
                    if (account2 == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv;
                return list2;
            }
            AccountManagerImpl $this$loadAccountsJson_u24lambda_u242 = this;
            boolean bl = false;
            Logger.INSTANCE.warn("File " + accountsPath + " couldn't be parsed: " + json2);
            list2 = CollectionsKt.emptyList();
            return list2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.INSTANCE.warn("File " + accountsPath + " does not exist");
            return CollectionsKt.emptyList();
        }
        catch (Throwable t2) {
            Logger.INSTANCE.warn(t2, "Failed to load user accounts");
            return CollectionsKt.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object loadAccounts(Path accountsPath, Continuation<? super Unit> $completion) {
        if (!($completion instanceof loadAccounts.1)) ** GOTO lbl-1000
        var17_3 = $completion;
        if ((var17_3.label & -2147483648) != 0) {
            var17_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ AccountManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AccountManagerImpl.access$loadAccounts(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var18_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.accountFileMutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = accountsPath;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var18_5) {
                    return var18_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                accountsPath = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                try {
                    $i$a$-withLock$default-AccountManagerImpl$loadAccounts$2 = false;
                    accounts = this.loadAccountsJson(accountsPath);
                    $this$forEach$iv = this.getProviders();
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        provider = (AccountProvider)element$iv;
                        $i$a$-forEach-AccountManagerImpl$loadAccounts$2$1 = false;
                        provider.tryLoadAccounts(accounts);
                    }
                    Logger.INSTANCE.info("Loaded accounts: " + CollectionsKt.joinToString$default((Iterable)accounts, null, null, null, (int)0, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, loadAccounts$lambda$0$1(com.jetbrains.toolbox.accounts.Account ), (Lcom/jetbrains/toolbox/accounts/Account;)Ljava/lang/CharSequence;)(), (int)31, null));
                    var14_17 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return var14_17;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object storeAccounts(List<? extends Account> accounts, Path accountsPath, Continuation<? super Unit> $completion) {
        if (!($completion instanceof storeAccounts.1)) ** GOTO lbl-1000
        var25_4 = $completion;
        if ((var25_4.label & -2147483648) != 0) {
            var25_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ AccountManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AccountManagerImpl.access$storeAccounts(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var26_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.accountFileMutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = accounts;
                $continuation.L$1 = accountsPath;
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                ** if (v0 != var26_6) goto lbl25
lbl24:
                // 1 sources

                return var26_6;
lbl25:
                // 1 sources

                ** GOTO lbl36
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                accountsPath = (Path)$continuation.L$1;
                accounts = (List)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl36:
                    // 2 sources

                    try {
                        $i$a$-withLock$default-AccountManagerImpl$storeAccounts$2 = false;
                        if (accounts.isEmpty() && !this.fileSystem.exists(accountsPath)) {
                            Logger.INSTANCE.info("No accounts exists and accounts file is empty");
                            var23_13 = Unit.INSTANCE;
                            return var23_13;
                        }
                        Logger.INSTANCE.info("Storing accounts: " + CollectionsKt.joinToString$default((Iterable)accounts, null, null, null, (int)0, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, storeAccounts$lambda$0$0(com.jetbrains.toolbox.accounts.Account ), (Lcom/jetbrains/toolbox/accounts/Account;)Ljava/lang/CharSequence;)(), (int)31, null));
                        json = this.accountJson.encodeToString((SerializationStrategy)AccountsJson.Companion.serializer(), (Object)new AccountsJson(accounts));
                        var9_15 = $continuation;
                        $i$f$currentCoroutineContext = false;
                        JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                        $completion$iv = this.fileSystem;
                        file$iv = accountsPath;
                        mustCreate$iv = false;
                        $i$f$-write = false;
                        $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, false));
                        $i$f$use = false;
                        thrown$iv$iv = null;
                        it$iv = (BufferedSink)$this$use$iv$iv;
                        $i$a$-use-FileSystem$write$1$iv = false;
                        $this$storeAccounts_u24lambda_u240_u241 = it$iv;
                        $i$a$--write$default-AccountManagerImpl$storeAccounts$2$2 = false;
                        var17_25 = $this$storeAccounts_u24lambda_u240_u241.writeUtf8(json);
                        try {
                            v1 = $this$use$iv$iv;
                            if (v1 != null) {
                                v1.close();
                            }
                            ** GOTO lbl93
                        }
                        catch (Throwable t$iv$iv) {
                            thrown$iv$iv = t$iv$iv;
                        }
                        ** GOTO lbl93
                        catch (Throwable t$iv$iv) {
                            try {
                                thrown$iv$iv = t$iv$iv;
                                var17_25 = null;
                            }
                            catch (Throwable var20_32) {
                                throw var20_32;
                            }
                            finally {
                                try {
                                    v2 = $this$use$iv$iv;
                                    if (v2 != null) {
                                        v2.close();
                                    }
                                }
                                catch (Throwable t$iv$iv) {
                                    if (thrown$iv$iv != null) ** GOTO lbl91
                                    thrown$iv$iv = t$iv$iv;
                                    ** GOTO lbl92
lbl91:
                                    // 1 sources

                                    ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv);
                                }
lbl92:
                                // 3 sources

                            }
                        }
lbl93:
                        // 3 sources

                        result$iv$iv = var17_25;
                        v3 = thrown$iv$iv;
                        if (v3 != null) {
                            throw v3;
                        }
                        var21_33 = result$iv$iv;
                    }
                    finally {
                        $this$withLock_u24default$iv.unlock(owner$iv);
                    }
                }
                catch (Throwable t) {
                    Logger.INSTANCE.warn(t, "Failed to store user accounts");
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object canHandle(@NotNull URI uri, @NotNull Continuation<? super Boolean> $completion) {
        block8: {
            if (!($completion instanceof canHandle.1)) ** GOTO lbl-1000
            var10_3 = $completion;
            if ((var10_3.label & -2147483648) != 0) {
                var10_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    int I$0;
                    int I$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ AccountManagerImpl this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.canHandle(null, (Continuation<? super Boolean>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $this$any$iv = this.getProviders();
                    $i$f$any = 0;
                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl17
                    v0 = false;
                    break block8;
lbl17:
                    // 1 sources

                    var5_8 = $this$any$iv.iterator();
lbl18:
                    // 2 sources

                    while (var5_8.hasNext()) {
                        element$iv = var5_8.next();
                        it = (AccountProvider)element$iv;
                        $i$a$-any-AccountManagerImpl$canHandle$2 = 0;
                        $continuation.L$0 = uri;
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$any$iv);
                        $continuation.L$2 = var5_8;
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)it);
                        $continuation.I$0 = $i$f$any;
                        $continuation.I$1 = $i$a$-any-AccountManagerImpl$canHandle$2;
                        $continuation.label = 1;
                        v1 = it.canHandle(uri, (Continuation<? super Boolean>)$continuation);
                        if (v1 == var11_5) {
                            return var11_5;
                        }
                        ** GOTO lbl45
                    }
                    break;
                }
                case 1: {
                    $i$a$-any-AccountManagerImpl$canHandle$2 = $continuation.I$1;
                    $i$f$any = $continuation.I$0;
                    it = (AccountProvider)$continuation.L$4;
                    element$iv = $continuation.L$3;
                    var5_8 = (Iterator)$continuation.L$2;
                    $this$any$iv = (Iterable)$continuation.L$1;
                    uri = (URI)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl45:
                    // 2 sources

                    if (!((Boolean)v1).booleanValue()) ** GOTO lbl18
                    v0 = true;
                    break block8;
                }
            }
            v0 = false;
        }
        return Boxing.boxBoolean((boolean)v0);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object handle(@NotNull URI uri, @NotNull Continuation<? super Unit> $completion) {
        block13: {
            block12: {
                if (!($completion instanceof handle.1)) ** GOTO lbl-1000
                var11_3 = $completion;
                if ((var11_3.label & -2147483648) != 0) {
                    var11_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        int I$0;
                        int I$1;
                        /* synthetic */ Object result;
                        final /* synthetic */ AccountManagerImpl this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.handle(null, (Continuation<? super Unit>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $this$firstOrNull$iv = this.getProviders();
                        $i$f$firstOrNull = 0;
                        var6_8 = $this$firstOrNull$iv.iterator();
lbl15:
                        // 2 sources

                        while (var6_8.hasNext()) {
                            element$iv = var6_8.next();
                            it = (AccountProvider)element$iv;
                            $i$a$-firstOrNull-AccountManagerImpl$handle$possibleHandler$1 = 0;
                            $continuation.L$0 = uri;
                            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$firstOrNull$iv);
                            $continuation.L$2 = var6_8;
                            $continuation.L$3 = element$iv;
                            $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)it);
                            $continuation.I$0 = $i$f$firstOrNull;
                            $continuation.I$1 = $i$a$-firstOrNull-AccountManagerImpl$handle$possibleHandler$1;
                            $continuation.label = 1;
                            v0 = it.canHandle(uri, (Continuation<? super Boolean>)$continuation);
                            if (v0 == var12_5) {
                                return var12_5;
                            }
                            ** GOTO lbl42
                        }
                        break;
                    }
                    case 1: {
                        $i$a$-firstOrNull-AccountManagerImpl$handle$possibleHandler$1 = $continuation.I$1;
                        $i$f$firstOrNull = $continuation.I$0;
                        it = (AccountProvider)$continuation.L$4;
                        element$iv = $continuation.L$3;
                        var6_8 = (Iterator)$continuation.L$2;
                        $this$firstOrNull$iv = (Iterable)$continuation.L$1;
                        uri = (URI)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl42:
                        // 2 sources

                        if (!((Boolean)v0).booleanValue()) ** GOTO lbl15
                        v1 = element$iv;
                        break block12;
                    }
                }
                v1 = null;
            }
            possibleHandler = (AccountProvider)v1;
            if (possibleHandler != null) {
                Logger.INSTANCE.debug("Using " + possibleHandler.getDisplayName() + " for " + uri);
            } else {
                Logger.INSTANCE.debug("No handlers found for " + uri);
            }
            v2 = possibleHandler;
            if (v2 == null) break block13;
            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)uri);
            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)possibleHandler);
            $continuation.L$2 = null;
            $continuation.L$3 = null;
            $continuation.L$4 = null;
            $continuation.label = 2;
            v3 = v2.handle(uri, (Continuation<? super Unit>)$continuation);
            if (v3 == var12_5) {
                return var12_5;
            }
            ** GOTO lbl69
            {
                case 2: {
                    possibleHandler = (AccountProvider)$continuation.L$1;
                    uri = (URI)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl69:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Unit accountJson$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setLenient(true);
        $this$Json.setPrettyPrint(true);
        $this$Json.setEncodeDefaults(true);
        return Unit.INSTANCE;
    }

    private static final CharSequence loadAccounts$lambda$0$1(Account it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "[" + Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName() + "] " + it.getId();
    }

    private static final CharSequence storeAccounts$lambda$0$0(Account it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "[" + Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName() + "] " + it.getId();
    }

    public static final /* synthetic */ Object access$loadAccounts(AccountManagerImpl $this, Path accountsPath, Continuation $completion) {
        return $this.loadAccounts(accountsPath, (Continuation<? super Unit>)$completion);
    }
}

