/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox;

import com.jetbrains.fus.reporting.client.id.MachineIdGenerator;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.intellij.JavaPreferences;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DecimalStyle;
import java.util.Locale;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.uuid.Uuid;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nuserids.kt\nKotlin\n*S Kotlin\n*F\n+ 1 userids.kt\ncom/jetbrains/toolbox/UseridsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n1#2:46\n*E\n"})
public final class UseridsKt {
    @NotNull
    public static final String userIdOnMachine() {
        String string = JavaPreferences.INSTANCE.read("", "user_id_on_machine");
        if (string == null) {
            String string2;
            String $this$userIdOnMachine_u24lambda_u240 = string2 = Uuid.Companion.random().toString();
            boolean bl = false;
            JavaPreferences.INSTANCE.write("", "user_id_on_machine", $this$userIdOnMachine_u24lambda_u240);
            string = string2;
        }
        return string;
    }

    @NotNull
    public static final String machineId() {
        String string = MachineIdGenerator.getAnonymizedMachineId((String)"TB", (String)"");
        if (string == null) {
            string = "unknown";
        }
        return string;
    }

    @NotNull
    public static final String deviceId() {
        String string;
        block3: {
            block2: {
                String string2;
                string = JavaPreferences.INSTANCE.read("", "device_id");
                if (string == null) break block2;
                String it = string2 = string;
                boolean bl = false;
                string = UseridsKt.deviceIdIsValid(it) ? string2 : null;
                if (string != null) break block3;
            }
            string = UseridsKt.generateDeviceId();
        }
        return string;
    }

    private static final boolean deviceIdIsValid(String deviceId) {
        return new Regex("[0-9]{7}[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}").matches((CharSequence)deviceId);
    }

    private static final String generateDeviceId() {
        String string;
        String it = string = DateTimeFormatter.ofPattern("ddMMyy", Locale.US).withDecimalStyle(DecimalStyle.STANDARD).format(LocalDate.now());
        boolean bl = false;
        Regex regex = new Regex("[0-9]{6}");
        Intrinsics.checkNotNull((Object)it);
        String string2 = regex.matches((CharSequence)it) ? string : null;
        if (string2 == null) {
            string2 = "000000";
        }
        String date = string2;
        int os = switch (WhenMappings.$EnumSwitchMapping$0[OS.INSTANCE.getType().ordinal()]) {
            case 1 -> 1;
            case 2 -> 2;
            case 3 -> 3;
            default -> throw new NoWhenBranchMatchedException();
        };
        String id = date + os + Uuid.Companion.random();
        JavaPreferences.INSTANCE.write("", "device_id", id);
        return id;
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.Type.values().length];
            try {
                nArray[OS.Type.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Mac.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Linux.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

