/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox;

import com.jetbrains.toolbox.INotifications;
import com.jetbrains.toolbox.Notifications;
import com.jetbrains.toolbox.UIEvent;
import com.jetbrains.toolbox.UIGlobalState;
import com.jetbrains.toolbox.WindowManager;
import com.jetbrains.toolbox.integration.OSIntegrationManagerLinux;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.Variant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nNotificationsLinux.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationsLinux.kt\ncom/jetbrains/toolbox/NotificationsLinux\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
public final class NotificationsLinux
implements Notifications {
    @NotNull
    private final UIGlobalState uiGlobalState;
    @NotNull
    private final OSIntegrationManagerLinux osIntegrationManagerLinux;
    @NotNull
    private final WindowManager windowManager;
    @NotNull
    private UInt32 myPreviousNotificationId;

    public NotificationsLinux(@NotNull UIGlobalState uiGlobalState, @NotNull OSIntegrationManagerLinux osIntegrationManagerLinux, @NotNull WindowManager windowManager) {
        Intrinsics.checkNotNullParameter((Object)uiGlobalState, (String)"uiGlobalState");
        Intrinsics.checkNotNullParameter((Object)osIntegrationManagerLinux, (String)"osIntegrationManagerLinux");
        Intrinsics.checkNotNullParameter((Object)windowManager, (String)"windowManager");
        this.uiGlobalState = uiGlobalState;
        this.osIntegrationManagerLinux = osIntegrationManagerLinux;
        this.windowManager = windowManager;
        this.myPreviousNotificationId = new UInt32(0L);
    }

    @Override
    @Nullable
    public Object showInfoMessage(@NotNull String message2, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.showNotification(message2, this.osIntegrationManagerLinux.getLinuxToolboxIcon().toString(), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object showErrorMessage(@NotNull String message2, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.showNotification(message2, "error", $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object showNotification(String message2, String icon2, Continuation<? super Unit> $completion) {
        Logger.INSTANCE.info("Show notification '" + message2 + "' (inApp=" + this.windowManager.isWindowFocused().getValue() + ")");
        if (((Boolean)this.windowManager.isWindowFocused().getValue()).booleanValue()) {
            Object object = this.uiGlobalState.processEvent(new UIEvent.InAppNotification(message2), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        this.showNotification("JetBrains Toolbox", icon2, message2);
        return Unit.INSTANCE;
    }

    private final DBusConnection getSessionBus() {
        return DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);
    }

    private final void showNotification(String title2, String icon2, String message2) {
        try {
            INotifications remoteObject = (INotifications)this.getSessionBus().getRemoteObject("org.freedesktop.Notifications", "/org/freedesktop/Notifications", INotifications.class);
            UInt32 uInt32 = remoteObject.Notify(title2, this.myPreviousNotificationId, icon2, title2, message2, CollectionsKt.emptyList(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"desktop-entry", (Object)new Variant((Object)"jetbrains-toolbox.desktop"))), 5000);
            Intrinsics.checkNotNullExpressionValue((Object)uInt32, (String)"Notify(...)");
            this.myPreviousNotificationId = uInt32;
        }
        catch (Exception e) {
            Logger.INSTANCE.warn((Throwable)e, "Failed to show notification '" + title2 + "' ('" + message2 + "'), skipping");
        }
    }
}

