/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox;

import com.intellij.util.io.Compressor;
import com.jetbrains.toolbox.FileUtils;
import com.jetbrains.toolbox.LocalLogCollector;
import com.jetbrains.toolbox.common.io.Copy_and_moveKt;
import java.io.Closeable;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSink;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nLocalLogCollectorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalLogCollectorImpl.kt\ncom/jetbrains/toolbox/LocalLogCollectorImpl\n+ 2 FileSystem.kt\nokio/FileSystem\n+ 3 Okio.kt\nokio/Okio__OkioKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n80#2:42\n165#2:43\n81#2:44\n82#2:49\n52#3,4:45\n60#3,10:52\n56#3,18:62\n1869#4,2:50\n*S KotlinDebug\n*F\n+ 1 LocalLogCollectorImpl.kt\ncom/jetbrains/toolbox/LocalLogCollectorImpl\n*L\n23#1:42\n23#1:43\n23#1:44\n23#1:49\n23#1:45,4\n23#1:52,10\n23#1:62,18\n25#1:50,2\n*E\n"})
public final class LocalLogCollectorImpl
implements LocalLogCollector {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Path logDirectory;
    @NotNull
    private final FileUtils fileUtils;

    public LocalLogCollectorImpl(@NotNull FileSystem fileSystem, @NotNull Path logDirectory, @NotNull FileUtils fileUtils) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)logDirectory, (String)"logDirectory");
        Intrinsics.checkNotNullParameter((Object)fileUtils, (String)"fileUtils");
        this.fileSystem = fileSystem;
        this.logDirectory = logDirectory;
        this.fileUtils = fileUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public Path collectLocalLogs(boolean archive) {
        Path tempDirectory = this.fileUtils.createTempDirectory("tbx-logs");
        if (!archive) {
            Copy_and_moveKt.copyRecursively$default(this.fileSystem, this.logDirectory, tempDirectory, null, false, 0, 28, null);
            return tempDirectory;
        }
        try {
            Unit unit;
            Throwable thrown$iv$iv;
            Path archiveFile;
            block29: {
                void $this$iv;
                Copy_and_moveKt.copyRecursively$default(this.fileSystem, this.logDirectory, tempDirectory, null, false, 0, 28, null);
                Path archiveTempDirectory = this.fileUtils.createTempDirectory("tbx-logs-archive");
                archiveFile = archiveTempDirectory.resolve("toolbox-logs.zip");
                FileSystem fileSystem = this.fileSystem;
                Path file$iv = archiveFile;
                boolean mustCreate$iv = false;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    Unit unit2;
                    BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                    boolean bl2 = false;
                    BufferedSink $this$collectLocalLogs_u24lambda_u240 = it$iv;
                    boolean bl3 = false;
                    Closeable closeable = new Compressor.Zip($this$collectLocalLogs_u24lambda_u240.outputStream()).withLevel(6);
                    Throwable throwable = null;
                    try {
                        Unit unit3;
                        Compressor.Zip compressor = (Compressor.Zip)closeable;
                        boolean bl4 = false;
                        List list2 = this.fileSystem.listOrNull(tempDirectory);
                        if (list2 != null) {
                            Iterable $this$forEach$iv = list2;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                Path path3 = (Path)element$iv;
                                boolean bl5 = false;
                                if (this.fileSystem.metadata(path3).isDirectory()) {
                                    compressor.addDirectory(path3.name(), path3.toNioPath());
                                    continue;
                                }
                                compressor.addFile(path3.name(), path3.toNioPath());
                            }
                            unit3 = Unit.INSTANCE;
                        } else {
                            unit3 = null;
                        }
                        unit2 = unit3;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    unit = unit2;
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        unit = null;
                        break block29;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                    finally {
                        block30: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block30;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            Unit result$iv$iv = unit;
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            Path path2 = archiveFile;
            return path2;
        }
        finally {
            this.fileSystem.deleteRecursively(tempDirectory);
        }
    }
}

