/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox;

import com.jetbrains.toolbox.FileUtils;
import com.jetbrains.toolbox.common.io.DeleteKt;
import com.jetbrains.toolbox.common.io.PathExtensionsKt;
import com.jetbrains.toolbox.common.io.Temp_directoryKt;
import java.util.Collection;
import java.util.List;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nFileUtilsImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtilsImpl.kt\ncom/jetbrains/toolbox/FileUtilsImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class FileUtilsImpl
implements FileUtils {
    @NotNull
    private final Path tempDirectory;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private List<Path> leftovers;

    public FileUtilsImpl(@NotNull Path tempDirectory, @NotNull FileSystem fileSystem, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)tempDirectory, (String)"tempDirectory");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.tempDirectory = tempDirectory;
        this.fileSystem = fileSystem;
        this.coroutineScope = coroutineScope;
        List list2 = this.fileSystem.listOrNull(this.tempDirectory);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        this.leftovers = list2;
    }

    @Override
    @NotNull
    public Path createTempDirectory(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Path path2 = this.newTempPath(prefix);
        FileSystem fileSystem = this.fileSystem;
        Path p0 = path2;
        boolean bl = false;
        fileSystem.createDirectories(p0);
        return path2;
    }

    @Override
    @NotNull
    public Path newTempPath(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return Temp_directoryKt.getTempDirectory(this.fileSystem, this.tempDirectory, prefix);
    }

    @Override
    @NotNull
    public Path getTempDirectory(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.tempDirectory.resolve(name2);
    }

    @Override
    @NotNull
    public Deferred<Boolean> asyncDelete(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return this.asyncDelete(CollectionsKt.listOf((Object)path2));
    }

    private final Deferred<Boolean> asyncDelete(List<Path> paths) {
        return BuildersKt.async$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(paths, this, null){
            int label;
            final /* synthetic */ List<Path> $paths;
            final /* synthetic */ FileUtilsImpl this$0;
            {
                this.$paths = $paths;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$fold$iv;
                        void initial$iv;
                        ResultKt.throwOnFailure((Object)$result);
                        Iterable iterable = this.$paths;
                        Boolean bl = Boxing.boxBoolean((boolean)true);
                        FileUtilsImpl fileUtilsImpl = this.this$0;
                        boolean $i$f$fold = false;
                        Boolean accumulator$iv = initial$iv;
                        for (T element$iv : $this$fold$iv) {
                            void path2;
                            Path path3 = (Path)element$iv;
                            boolean acc = accumulator$iv;
                            boolean bl2 = false;
                            if (PathExtensionsKt.contains(FileUtilsImpl.access$getTempDirectory$p(fileUtilsImpl), (Path)path2)) {
                                Logger.INSTANCE.debug("Removing temp path '" + (Path)path2 + "'");
                            } else {
                                Logger.INSTANCE.info("Removing path '" + (Path)path2 + "'");
                            }
                            accumulator$iv = Boxing.boxBoolean((DeleteKt.forceDeleteRecursively(FileUtilsImpl.access$getFileSystem$p(fileUtilsImpl), (Path)path2) && acc ? 1 : 0) != 0);
                        }
                        return accumulator$iv;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void retain(@NotNull Collection<Path> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Logger.INSTANCE.info("Retained the following " + paths.size() + " path(s): " + paths);
        this.asyncDelete(CollectionsKt.minus((Iterable)this.leftovers, (Iterable)paths));
        this.leftovers = CollectionsKt.emptyList();
    }

    public static final /* synthetic */ Path access$getTempDirectory$p(FileUtilsImpl $this) {
        return $this.tempDirectory;
    }

    public static final /* synthetic */ FileSystem access$getFileSystem$p(FileUtilsImpl $this) {
        return $this.fileSystem;
    }
}

