/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.tbe.config.machine;

import com.jetbrains.tbe.config.machine.IdeAnalyticsConfig;
import com.jetbrains.tbe.config.machine.TbeMachineConfig;
import com.jetbrains.tbe.config.machine.TbeMachineConfigCertificates;
import com.jetbrains.tbe.config.machine.TbeMachineConfigFactory$IdeAnalyticsConfigData$;
import com.jetbrains.tbe.config.machine.TbeMachineConfigFactory$TbeMachineConfigData$;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.datetime.Instant;
import kotlinx.datetime.serializers.InstantIso8601Serializer;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nTbeMachineConfigFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TbeMachineConfigFactory.kt\ncom/jetbrains/tbe/config/machine/TbeMachineConfigFactory\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n147#2:129\n1567#3:130\n1598#3,4:131\n1557#3:136\n1628#3,3:137\n113#4:135\n1#5:140\n*S KotlinDebug\n*F\n+ 1 TbeMachineConfigFactory.kt\ncom/jetbrains/tbe/config/machine/TbeMachineConfigFactory\n*L\n35#1:129\n36#1:130\n36#1:131,4\n120#1:136\n120#1:137,3\n55#1:135\n*E\n"})
public final class TbeMachineConfigFactory {
    @NotNull
    public static final TbeMachineConfigFactory INSTANCE = new TbeMachineConfigFactory();
    @NotNull
    private static final Lazy parser$delegate = LazyKt.lazy(TbeMachineConfigFactory::parser_delegate$lambda$1);

    private TbeMachineConfigFactory() {
    }

    @NotNull
    public final String getIntelliJvmOpt() {
        return "jetbrains.tbe.trust";
    }

    @NotNull
    public final TbeMachineConfig fromConfigLocation(@NotNull Path configFile) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
        try {
            byArray = Files.readAllBytes(configFile);
        }
        catch (Exception t2) {
            throw new IllegalArgumentException("Failed to read TBE Machine configuration from " + configFile + ". " + t2.getMessage(), t2);
        }
        byte[] data2 = byArray;
        Intrinsics.checkNotNull((Object)data2);
        return this.fromConfigData(data2);
    }

    private final Json getParser() {
        Lazy lazy = parser$delegate;
        return (Json)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TbeMachineConfig fromConfigData(@NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        try {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Iterable string$iv;
            void this_$iv;
            Json json2 = this.getParser();
            String string = new String(data2, Charsets.UTF_8);
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            TbeMachineConfigData model2 = (TbeMachineConfigData)this_$iv.decodeFromString((DeserializationStrategy)TbeMachineConfigData.Companion.serializer(), (String)((Object)string$iv));
            string$iv = model2.getHttpsTrustStorePem();
            TbeMachineConfigCertificates tbeMachineConfigCertificates = TbeMachineConfigCertificates.INSTANCE;
            boolean $i$f$mapIndexed = false;
            void var7_9 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void p1;
                void p0;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string2 = (String)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(tbeMachineConfigCertificates.loadCertificate((int)p0, (String)p1));
            }
            List certificates = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
            return new TbeMachineConfigImpl(model2, certificates);
        }
        catch (Throwable t2) {
            throw new IllegalArgumentException("Failed to parse TBE Machine configuration file. " + t2.getMessage(), t2);
        }
    }

    @NotNull
    public final byte[] toConfigData(@NotNull TbeMachineConfig config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        TbeMachineConfigData data2 = this.toData(config2);
        StringFormat $this$encodeToString$iv = (StringFormat)this.getParser();
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        String string = $this$encodeToString$iv.encodeToString((SerializationStrategy)TbeMachineConfigData.Companion.serializer(), (Object)data2);
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    @NotNull
    public final TbeMachineConfig mergeWith(@NotNull TbeMachineConfig $this$mergeWith, @NotNull TbeMachineConfig incomingConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$mergeWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)incomingConfig, (String)"incomingConfig");
        TbeMachineConfigData currentConfig = this.toData($this$mergeWith);
        TbeMachineConfigData updatedConfig = TbeMachineConfigData.copy$default(currentConfig, null, incomingConfig.getCompanyName(), incomingConfig.getCompanyLogoUrl(), null, null, null, null, null, null, null, 1017, null);
        return new TbeMachineConfigImpl(updatedConfig, $this$mergeWith.getHttpsTrustStore());
    }

    /*
     * WARNING - void declaration
     */
    private final TbeMachineConfigData toData(TbeMachineConfig $this$toData) {
        IdeAnalyticsConfigData ideAnalyticsConfigData;
        void $this$mapTo$iv$iv;
        String string = $this$toData.getTbeServerUrl();
        String string2 = $this$toData.getCompanyName();
        String string3 = $this$toData.getCompanyLogoUrl();
        String string4 = $this$toData.getOverriddenAuthorization();
        Instant instant = $this$toData.getExpiresAt();
        Iterable $this$map$iv = $this$toData.getHttpsTrustStore();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            X509Certificate x509Certificate = (X509Certificate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TbeMachineConfigCertificates.INSTANCE.saveCertificatePem((X509Certificate)it));
        }
        List list2 = (List)destination$iv$iv;
        String string5 = $this$toData.getBrowserUrl();
        Map<String, String> map2 = $this$toData.getAdditionalHeaders();
        IdeAnalyticsConfig ideAnalyticsConfig = $this$toData.getIdeAnalytics();
        if (ideAnalyticsConfig != null) {
            IdeAnalyticsConfig it = ideAnalyticsConfig;
            boolean bl = false;
            ideAnalyticsConfigData = new IdeAnalyticsConfigData(it);
        } else {
            ideAnalyticsConfigData = null;
        }
        iterable = ideAnalyticsConfigData;
        String string6 = $this$toData.getOrganizationSignatureManifest();
        return new TbeMachineConfigData(string, string2, string3, list2, string4, instant, string5, map2, (IdeAnalyticsConfigData)((Object)iterable), string6);
    }

    private static final Unit parser_delegate$lambda$1$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setEncodeDefaults(true);
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }

    private static final Json parser_delegate$lambda$1() {
        return JsonKt.Json$default(null, TbeMachineConfigFactory::parser_delegate$lambda$1$lambda$0, (int)1, null);
    }

    @Serializable
    public static final class IdeAnalyticsConfigData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean enabled;

        public IdeAnalyticsConfigData(boolean enabled) {
            this.enabled = enabled;
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        public IdeAnalyticsConfigData(@NotNull IdeAnalyticsConfig enabled) {
            Intrinsics.checkNotNullParameter((Object)enabled, (String)"enabled");
            this(enabled.getEnabled());
        }

        public final boolean component1() {
            return this.enabled;
        }

        @NotNull
        public final IdeAnalyticsConfigData copy(boolean enabled) {
            return new IdeAnalyticsConfigData(enabled);
        }

        public static /* synthetic */ IdeAnalyticsConfigData copy$default(IdeAnalyticsConfigData ideAnalyticsConfigData, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = ideAnalyticsConfigData.enabled;
            }
            return ideAnalyticsConfigData.copy(bl);
        }

        @NotNull
        public String toString() {
            return "IdeAnalyticsConfigData(enabled=" + this.enabled + ")";
        }

        public int hashCode() {
            return Boolean.hashCode(this.enabled);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IdeAnalyticsConfigData)) {
                return false;
            }
            IdeAnalyticsConfigData ideAnalyticsConfigData = (IdeAnalyticsConfigData)other;
            return this.enabled == ideAnalyticsConfigData.enabled;
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$tbe_config_machine(IdeAnalyticsConfigData self, CompositeEncoder output2, SerialDescriptor serialDesc) {
            output2.encodeBooleanElement(serialDesc, 0, self.enabled);
        }

        public /* synthetic */ IdeAnalyticsConfigData(int seen0, boolean enabled, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)IdeAnalyticsConfigData$$serializer.INSTANCE.getDescriptor());
            }
            this.enabled = enabled;
        }

        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<IdeAnalyticsConfigData> serializer() {
                return (KSerializer)IdeAnalyticsConfigData$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    private static final class TbeMachineConfigData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String tbeServerUrl;
        @NotNull
        private final String companyName;
        @Nullable
        private final String companyLogoUrl;
        @NotNull
        private final List<String> httpsTrustStorePem;
        @Nullable
        private final String overriddenAuthorization;
        @Nullable
        private final Instant expiresAt;
        @Nullable
        private final String browserUrl;
        @NotNull
        private final Map<String, String> additionalHeaders;
        @Nullable
        private final IdeAnalyticsConfigData ideAnalytics;
        @Nullable
        private final String organizationSignatureManifest;
        @JvmField
        @NotNull
        private static final KSerializer<Object>[] $childSerializers;

        public TbeMachineConfigData(@NotNull String tbeServerUrl, @NotNull String companyName, @Nullable String companyLogoUrl, @NotNull List<String> httpsTrustStorePem, @Nullable String overriddenAuthorization, @Nullable Instant expiresAt, @Nullable String browserUrl, @NotNull Map<String, String> additionalHeaders, @Nullable IdeAnalyticsConfigData ideAnalytics, @Nullable String organizationSignatureManifest) {
            Intrinsics.checkNotNullParameter((Object)tbeServerUrl, (String)"tbeServerUrl");
            Intrinsics.checkNotNullParameter((Object)companyName, (String)"companyName");
            Intrinsics.checkNotNullParameter(httpsTrustStorePem, (String)"httpsTrustStorePem");
            Intrinsics.checkNotNullParameter(additionalHeaders, (String)"additionalHeaders");
            this.tbeServerUrl = tbeServerUrl;
            this.companyName = companyName;
            this.companyLogoUrl = companyLogoUrl;
            this.httpsTrustStorePem = httpsTrustStorePem;
            this.overriddenAuthorization = overriddenAuthorization;
            this.expiresAt = expiresAt;
            this.browserUrl = browserUrl;
            this.additionalHeaders = additionalHeaders;
            this.ideAnalytics = ideAnalytics;
            this.organizationSignatureManifest = organizationSignatureManifest;
        }

        public /* synthetic */ TbeMachineConfigData(String string, String string2, String string3, List list2, String string4, Instant instant, String string5, Map map2, IdeAnalyticsConfigData ideAnalyticsConfigData, String string6, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n & 0x10) != 0) {
                string4 = null;
            }
            if ((n & 0x20) != 0) {
                instant = null;
            }
            if ((n & 0x40) != 0) {
                string5 = null;
            }
            if ((n & 0x80) != 0) {
                map2 = MapsKt.emptyMap();
            }
            if ((n & 0x100) != 0) {
                ideAnalyticsConfigData = null;
            }
            if ((n & 0x200) != 0) {
                string6 = null;
            }
            this(string, string2, string3, list2, string4, instant, string5, map2, ideAnalyticsConfigData, string6);
        }

        @NotNull
        public final String getTbeServerUrl() {
            return this.tbeServerUrl;
        }

        @NotNull
        public final String getCompanyName() {
            return this.companyName;
        }

        @Nullable
        public final String getCompanyLogoUrl() {
            return this.companyLogoUrl;
        }

        @NotNull
        public final List<String> getHttpsTrustStorePem() {
            return this.httpsTrustStorePem;
        }

        @Nullable
        public final String getOverriddenAuthorization() {
            return this.overriddenAuthorization;
        }

        @Nullable
        public final Instant getExpiresAt() {
            return this.expiresAt;
        }

        @Nullable
        public final String getBrowserUrl() {
            return this.browserUrl;
        }

        @NotNull
        public final Map<String, String> getAdditionalHeaders() {
            return this.additionalHeaders;
        }

        @Nullable
        public final IdeAnalyticsConfigData getIdeAnalytics() {
            return this.ideAnalytics;
        }

        @Nullable
        public final String getOrganizationSignatureManifest() {
            return this.organizationSignatureManifest;
        }

        @NotNull
        public final String component1() {
            return this.tbeServerUrl;
        }

        @NotNull
        public final String component2() {
            return this.companyName;
        }

        @Nullable
        public final String component3() {
            return this.companyLogoUrl;
        }

        @NotNull
        public final List<String> component4() {
            return this.httpsTrustStorePem;
        }

        @Nullable
        public final String component5() {
            return this.overriddenAuthorization;
        }

        @Nullable
        public final Instant component6() {
            return this.expiresAt;
        }

        @Nullable
        public final String component7() {
            return this.browserUrl;
        }

        @NotNull
        public final Map<String, String> component8() {
            return this.additionalHeaders;
        }

        @Nullable
        public final IdeAnalyticsConfigData component9() {
            return this.ideAnalytics;
        }

        @Nullable
        public final String component10() {
            return this.organizationSignatureManifest;
        }

        @NotNull
        public final TbeMachineConfigData copy(@NotNull String tbeServerUrl, @NotNull String companyName, @Nullable String companyLogoUrl, @NotNull List<String> httpsTrustStorePem, @Nullable String overriddenAuthorization, @Nullable Instant expiresAt, @Nullable String browserUrl, @NotNull Map<String, String> additionalHeaders, @Nullable IdeAnalyticsConfigData ideAnalytics, @Nullable String organizationSignatureManifest) {
            Intrinsics.checkNotNullParameter((Object)tbeServerUrl, (String)"tbeServerUrl");
            Intrinsics.checkNotNullParameter((Object)companyName, (String)"companyName");
            Intrinsics.checkNotNullParameter(httpsTrustStorePem, (String)"httpsTrustStorePem");
            Intrinsics.checkNotNullParameter(additionalHeaders, (String)"additionalHeaders");
            return new TbeMachineConfigData(tbeServerUrl, companyName, companyLogoUrl, httpsTrustStorePem, overriddenAuthorization, expiresAt, browserUrl, additionalHeaders, ideAnalytics, organizationSignatureManifest);
        }

        public static /* synthetic */ TbeMachineConfigData copy$default(TbeMachineConfigData tbeMachineConfigData, String string, String string2, String string3, List list2, String string4, Instant instant, String string5, Map map2, IdeAnalyticsConfigData ideAnalyticsConfigData, String string6, int n, Object object) {
            if ((n & 1) != 0) {
                string = tbeMachineConfigData.tbeServerUrl;
            }
            if ((n & 2) != 0) {
                string2 = tbeMachineConfigData.companyName;
            }
            if ((n & 4) != 0) {
                string3 = tbeMachineConfigData.companyLogoUrl;
            }
            if ((n & 8) != 0) {
                list2 = tbeMachineConfigData.httpsTrustStorePem;
            }
            if ((n & 0x10) != 0) {
                string4 = tbeMachineConfigData.overriddenAuthorization;
            }
            if ((n & 0x20) != 0) {
                instant = tbeMachineConfigData.expiresAt;
            }
            if ((n & 0x40) != 0) {
                string5 = tbeMachineConfigData.browserUrl;
            }
            if ((n & 0x80) != 0) {
                map2 = tbeMachineConfigData.additionalHeaders;
            }
            if ((n & 0x100) != 0) {
                ideAnalyticsConfigData = tbeMachineConfigData.ideAnalytics;
            }
            if ((n & 0x200) != 0) {
                string6 = tbeMachineConfigData.organizationSignatureManifest;
            }
            return tbeMachineConfigData.copy(string, string2, string3, list2, string4, instant, string5, map2, ideAnalyticsConfigData, string6);
        }

        @NotNull
        public String toString() {
            return "TbeMachineConfigData(tbeServerUrl=" + this.tbeServerUrl + ", companyName=" + this.companyName + ", companyLogoUrl=" + this.companyLogoUrl + ", httpsTrustStorePem=" + this.httpsTrustStorePem + ", overriddenAuthorization=" + this.overriddenAuthorization + ", expiresAt=" + this.expiresAt + ", browserUrl=" + this.browserUrl + ", additionalHeaders=" + this.additionalHeaders + ", ideAnalytics=" + this.ideAnalytics + ", organizationSignatureManifest=" + this.organizationSignatureManifest + ")";
        }

        public int hashCode() {
            int result2 = this.tbeServerUrl.hashCode();
            result2 = result2 * 31 + this.companyName.hashCode();
            result2 = result2 * 31 + (this.companyLogoUrl == null ? 0 : this.companyLogoUrl.hashCode());
            result2 = result2 * 31 + ((Object)this.httpsTrustStorePem).hashCode();
            result2 = result2 * 31 + (this.overriddenAuthorization == null ? 0 : this.overriddenAuthorization.hashCode());
            result2 = result2 * 31 + (this.expiresAt == null ? 0 : this.expiresAt.hashCode());
            result2 = result2 * 31 + (this.browserUrl == null ? 0 : this.browserUrl.hashCode());
            result2 = result2 * 31 + ((Object)this.additionalHeaders).hashCode();
            result2 = result2 * 31 + (this.ideAnalytics == null ? 0 : this.ideAnalytics.hashCode());
            result2 = result2 * 31 + (this.organizationSignatureManifest == null ? 0 : this.organizationSignatureManifest.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TbeMachineConfigData)) {
                return false;
            }
            TbeMachineConfigData tbeMachineConfigData = (TbeMachineConfigData)other;
            if (!Intrinsics.areEqual((Object)this.tbeServerUrl, (Object)tbeMachineConfigData.tbeServerUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.companyName, (Object)tbeMachineConfigData.companyName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.companyLogoUrl, (Object)tbeMachineConfigData.companyLogoUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.httpsTrustStorePem, tbeMachineConfigData.httpsTrustStorePem)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.overriddenAuthorization, (Object)tbeMachineConfigData.overriddenAuthorization)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.expiresAt, (Object)tbeMachineConfigData.expiresAt)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.browserUrl, (Object)tbeMachineConfigData.browserUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.additionalHeaders, tbeMachineConfigData.additionalHeaders)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.ideAnalytics, (Object)tbeMachineConfigData.ideAnalytics)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.organizationSignatureManifest, (Object)tbeMachineConfigData.organizationSignatureManifest);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$tbe_config_machine(TbeMachineConfigData self, CompositeEncoder output2, SerialDescriptor serialDesc) {
            KSerializer<Object>[] kSerializerArray = $childSerializers;
            output2.encodeStringElement(serialDesc, 0, self.tbeServerUrl);
            output2.encodeStringElement(serialDesc, 1, self.companyName);
            if (output2.shouldEncodeElementDefault(serialDesc, 2) ? true : self.companyLogoUrl != null) {
                output2.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.companyLogoUrl);
            }
            if (output2.shouldEncodeElementDefault(serialDesc, 3) ? true : !Intrinsics.areEqual(self.httpsTrustStorePem, (Object)CollectionsKt.emptyList())) {
                output2.encodeSerializableElement(serialDesc, 3, (SerializationStrategy)kSerializerArray[3], self.httpsTrustStorePem);
            }
            if (output2.shouldEncodeElementDefault(serialDesc, 4) ? true : self.overriddenAuthorization != null) {
                output2.encodeNullableSerializableElement(serialDesc, 4, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.overriddenAuthorization);
            }
            if (output2.shouldEncodeElementDefault(serialDesc, 5) ? true : self.expiresAt != null) {
                output2.encodeNullableSerializableElement(serialDesc, 5, (SerializationStrategy)InstantIso8601Serializer.INSTANCE, (Object)self.expiresAt);
            }
            if (output2.shouldEncodeElementDefault(serialDesc, 6) ? true : self.browserUrl != null) {
                output2.encodeNullableSerializableElement(serialDesc, 6, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.browserUrl);
            }
            if (output2.shouldEncodeElementDefault(serialDesc, 7) ? true : !Intrinsics.areEqual(self.additionalHeaders, (Object)MapsKt.emptyMap())) {
                output2.encodeSerializableElement(serialDesc, 7, (SerializationStrategy)kSerializerArray[7], self.additionalHeaders);
            }
            if (output2.shouldEncodeElementDefault(serialDesc, 8) ? true : self.ideAnalytics != null) {
                output2.encodeNullableSerializableElement(serialDesc, 8, (SerializationStrategy)IdeAnalyticsConfigData$$serializer.INSTANCE, (Object)self.ideAnalytics);
            }
            if (output2.shouldEncodeElementDefault(serialDesc, 9) ? true : self.organizationSignatureManifest != null) {
                output2.encodeNullableSerializableElement(serialDesc, 9, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.organizationSignatureManifest);
            }
        }

        public /* synthetic */ TbeMachineConfigData(int seen0, String tbeServerUrl, String companyName, String companyLogoUrl, List httpsTrustStorePem, String overriddenAuthorization, Instant expiresAt, String browserUrl, Map additionalHeaders, IdeAnalyticsConfigData ideAnalytics, String organizationSignatureManifest, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)TbeMachineConfigData$$serializer.INSTANCE.getDescriptor());
            }
            this.tbeServerUrl = tbeServerUrl;
            this.companyName = companyName;
            this.companyLogoUrl = (seen0 & 4) == 0 ? null : companyLogoUrl;
            this.httpsTrustStorePem = (seen0 & 8) == 0 ? CollectionsKt.emptyList() : httpsTrustStorePem;
            this.overriddenAuthorization = (seen0 & 0x10) == 0 ? null : overriddenAuthorization;
            this.expiresAt = (seen0 & 0x20) == 0 ? null : expiresAt;
            this.browserUrl = (seen0 & 0x40) == 0 ? null : browserUrl;
            this.additionalHeaders = (seen0 & 0x80) == 0 ? MapsKt.emptyMap() : additionalHeaders;
            this.ideAnalytics = (seen0 & 0x100) == 0 ? null : ideAnalytics;
            this.organizationSignatureManifest = (seen0 & 0x200) == 0 ? null : organizationSignatureManifest;
        }

        public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            KSerializer[] kSerializerArray = new KSerializer[]{null, null, null, new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE), null, null, null, new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE), null, null};
            $childSerializers = kSerializerArray;
        }

        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<TbeMachineConfigData> serializer() {
                return (KSerializer)TbeMachineConfigData$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @SourceDebugExtension(value={"SMAP\nTbeMachineConfigFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TbeMachineConfigFactory.kt\ncom/jetbrains/tbe/config/machine/TbeMachineConfigFactory$TbeMachineConfigImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
    private static final class TbeMachineConfigImpl
    implements TbeMachineConfig {
        @NotNull
        private final TbeMachineConfigData data;
        @NotNull
        private final List<X509Certificate> httpsTrustStore;
        @Nullable
        private final IdeAnalyticsConfig ideAnalytics;

        /*
         * WARNING - void declaration
         */
        public TbeMachineConfigImpl(@NotNull TbeMachineConfigData data2, @NotNull List<? extends X509Certificate> certificates) {
            IdeAnalyticsConfig ideAnalyticsConfig;
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
            this.data = data2;
            this.httpsTrustStore = certificates;
            TbeMachineConfigImpl tbeMachineConfigImpl = this;
            IdeAnalyticsConfigData ideAnalyticsConfigData = this.data.getIdeAnalytics();
            if (ideAnalyticsConfigData != null) {
                void it;
                IdeAnalyticsConfigData ideAnalyticsConfigData2 = ideAnalyticsConfigData;
                TbeMachineConfigImpl tbeMachineConfigImpl2 = tbeMachineConfigImpl;
                boolean bl = false;
                ideAnalyticsConfig = new IdeAnalyticsConfig((IdeAnalyticsConfigData)it);
                tbeMachineConfigImpl = tbeMachineConfigImpl2;
            } else {
                ideAnalyticsConfig = null;
            }
            tbeMachineConfigImpl.ideAnalytics = ideAnalyticsConfig;
        }

        @Override
        @NotNull
        public String getTbeServerUrl() {
            return this.data.getTbeServerUrl();
        }

        private static Object getTbeServerUrl$delegate(TbeMachineConfigImpl tbeMachineConfigImpl) {
            return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)tbeMachineConfigImpl.data, TbeMachineConfigData.class, "tbeServerUrl", "getTbeServerUrl()Ljava/lang/String;", 0)));
        }

        @Override
        @NotNull
        public String getCompanyName() {
            return this.data.getCompanyName();
        }

        private static Object getCompanyName$delegate(TbeMachineConfigImpl tbeMachineConfigImpl) {
            return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)tbeMachineConfigImpl.data, TbeMachineConfigData.class, "companyName", "getCompanyName()Ljava/lang/String;", 0)));
        }

        @Override
        @Nullable
        public String getCompanyLogoUrl() {
            return this.data.getCompanyLogoUrl();
        }

        private static Object getCompanyLogoUrl$delegate(TbeMachineConfigImpl tbeMachineConfigImpl) {
            return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)tbeMachineConfigImpl.data, TbeMachineConfigData.class, "companyLogoUrl", "getCompanyLogoUrl()Ljava/lang/String;", 0)));
        }

        @Override
        @Nullable
        public String getOverriddenAuthorization() {
            return this.data.getOverriddenAuthorization();
        }

        private static Object getOverriddenAuthorization$delegate(TbeMachineConfigImpl tbeMachineConfigImpl) {
            return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)tbeMachineConfigImpl.data, TbeMachineConfigData.class, "overriddenAuthorization", "getOverriddenAuthorization()Ljava/lang/String;", 0)));
        }

        @Override
        @Nullable
        public Instant getExpiresAt() {
            return this.data.getExpiresAt();
        }

        private static Object getExpiresAt$delegate(TbeMachineConfigImpl tbeMachineConfigImpl) {
            return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)tbeMachineConfigImpl.data, TbeMachineConfigData.class, "expiresAt", "getExpiresAt()Lkotlinx/datetime/Instant;", 0)));
        }

        @Override
        @NotNull
        public List<X509Certificate> getHttpsTrustStore() {
            return this.httpsTrustStore;
        }

        @Override
        @Nullable
        public String getBrowserUrl() {
            return this.data.getBrowserUrl();
        }

        private static Object getBrowserUrl$delegate(TbeMachineConfigImpl tbeMachineConfigImpl) {
            return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)tbeMachineConfigImpl.data, TbeMachineConfigData.class, "browserUrl", "getBrowserUrl()Ljava/lang/String;", 0)));
        }

        @Override
        @NotNull
        public Map<String, String> getAdditionalHeaders() {
            return this.data.getAdditionalHeaders();
        }

        private static Object getAdditionalHeaders$delegate(TbeMachineConfigImpl tbeMachineConfigImpl) {
            return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)tbeMachineConfigImpl.data, TbeMachineConfigData.class, "additionalHeaders", "getAdditionalHeaders()Ljava/util/Map;", 0)));
        }

        @Override
        @Nullable
        public IdeAnalyticsConfig getIdeAnalytics() {
            return this.ideAnalytics;
        }

        @Override
        @Nullable
        public String getOrganizationSignatureManifest() {
            return this.data.getOrganizationSignatureManifest();
        }

        private static Object getOrganizationSignatureManifest$delegate(TbeMachineConfigImpl tbeMachineConfigImpl) {
            return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)tbeMachineConfigImpl.data, TbeMachineConfigData.class, "organizationSignatureManifest", "getOrganizationSignatureManifest()Ljava/lang/String;", 0)));
        }

        @NotNull
        public String toString() {
            return "TbeMachineConfig(tbeServerUrl='" + this.getTbeServerUrl() + "', companyName='" + this.getCompanyName() + "')";
        }

        public boolean equals(@Nullable Object other) {
            TbeMachineConfigImpl tbeMachineConfigImpl = other instanceof TbeMachineConfigImpl ? (TbeMachineConfigImpl)other : null;
            return Intrinsics.areEqual((Object)this.data, (Object)(tbeMachineConfigImpl != null ? tbeMachineConfigImpl.data : null));
        }

        public int hashCode() {
            return this.data.hashCode();
        }
    }
}

