/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.schema.generation;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class ValidationResult {
    @NotNull
    private final Map<String, Set<String>> errors;

    public ValidationResult(@NotNull Map<String, Set<String>> errors) {
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        this.errors = errors;
    }

    @NotNull
    public final Map<String, Set<String>> getErrors() {
        return this.errors;
    }

    public ValidationResult() {
        this(new HashMap());
    }

    public final void addError(@NotNull String groupId, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Set set = this.errors.get(groupId);
        if (set == null) {
            set = new HashSet();
        }
        Set existingErrors = set;
        existingErrors.add((String)message2);
        this.errors.put(groupId, existingErrors);
    }

    private final void addErrors(String groupId, Set<String> messages2) {
        Set set = this.errors.get(groupId);
        if (set == null) {
            set = new HashSet();
        }
        Set existingErrors = set;
        existingErrors.addAll((Collection)messages2);
        this.errors.put(groupId, existingErrors);
    }

    public final boolean isCorrectGroup(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        return this.errors.get(groupId) == null;
    }

    @NotNull
    public final ValidationResult merge(@NotNull ValidationResult other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ValidationResult result2 = new ValidationResult(this.errors);
        for (Map.Entry<String, Set<String>> entry : other.errors.entrySet()) {
            String group = entry.getKey();
            Set<String> errors = entry.getValue();
            result2.addErrors(group, errors);
        }
        return result2;
    }
}

