/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.schema;

import com.jetbrains.fus.reporting.schema.EventField;
import com.jetbrains.fus.reporting.schema.FieldsValues;
import java.util.HashMap;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventPair<T> {
    @NotNull
    private final EventField<T> field;
    private final T data;

    public EventPair(@NotNull EventField<T> field, T data2) {
        Intrinsics.checkNotNullParameter(field, (String)"field");
        this.field = field;
        this.data = data2;
    }

    @NotNull
    public final EventField<T> getField() {
        return this.field;
    }

    public final T getData() {
        return this.data;
    }

    public final void addFieldValue(@NotNull HashMap<String, Object> data2) {
        Intrinsics.checkNotNullParameter(data2, (String)"data");
        FieldsValues.Companion.addData(data2, this.field, this.data);
    }

    @NotNull
    public final EventField<T> component1() {
        return this.field;
    }

    public final T component2() {
        return this.data;
    }

    @NotNull
    public final EventPair<T> copy(@NotNull EventField<T> field, T data2) {
        Intrinsics.checkNotNullParameter(field, (String)"field");
        return new EventPair<T>(field, data2);
    }

    public static /* synthetic */ EventPair copy$default(EventPair eventPair, EventField eventField, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            eventField = eventPair.field;
        }
        if ((n & 2) != 0) {
            object = eventPair.data;
        }
        return eventPair.copy(eventField, object);
    }

    @NotNull
    public String toString() {
        return "EventPair(field=" + this.field + ", data=" + this.data + ')';
    }

    public int hashCode() {
        int result2 = this.field.hashCode();
        result2 = result2 * 31 + (this.data == null ? 0 : this.data.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EventPair)) {
            return false;
        }
        EventPair eventPair = (EventPair)other;
        if (!Intrinsics.areEqual(this.field, eventPair.field)) {
            return false;
        }
        return Intrinsics.areEqual(this.data, eventPair.data);
    }
}

