/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.dom;

import com.fasterxml.aalto.WFCException;
import com.fasterxml.aalto.impl.ErrorConsts;
import com.intellij.util.xml.dom.NoOpXmlInterner;
import com.intellij.util.xml.dom.StaxFactory;
import com.intellij.util.xml.dom.XmlElement;
import com.intellij.util.xml.dom.XmlElementBuilder;
import com.intellij.util.xml.dom.XmlInterner;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.codehaus.stax2.XMLStreamReader2;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JvmName(name="XmlDomReader")
@ApiStatus.Internal
public final class XmlDomReader {
    @NotNull
    public static final XmlElement readXmlAsModel(@NotNull Reader inputReader) {
        Intrinsics.checkNotNullParameter((Object)inputReader, (String)"inputReader");
        return XmlDomReader.readAndClose(StaxFactory.createXmlStreamReader(inputReader));
    }

    @NotNull
    public static final XmlElement readXmlAsModel(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return XmlDomReader.readAndClose(StaxFactory.createXmlStreamReader$default(inputStream, null, 2, null));
    }

    @NotNull
    public static final XmlElement readXmlAsModel(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        return XmlDomReader.readAndClose(StaxFactory.createXmlStreamReader$default(inputStream, null, 2, null));
    }

    @NotNull
    public static final XmlElement readXmlAsModel(@NotNull byte[] inputData) {
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        return XmlDomReader.readAndClose(StaxFactory.createXmlStreamReader(inputData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final XmlElement readAndClose(XMLStreamReader2 reader2) {
        try {
            String rootName = XmlDomReader.nextTag(reader2) == 1 ? reader2.getLocalName() : null;
            XmlElement xmlElement = XmlDomReader.readXmlAsModel(reader2, rootName, NoOpXmlInterner.INSTANCE);
            return xmlElement;
        }
        finally {
            reader2.closeCompletely();
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static final XmlElement readXmlAsModel(@NotNull XMLStreamReader2 reader2, @Nullable String rootName, @NotNull XmlInterner interner) {
        XmlElementBuilder fragment;
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)interner, (String)"interner");
        String string = rootName;
        XmlElementBuilder current = fragment = new XmlElementBuilder(string == null ? "" : interner.name(string), XmlDomReader.readAttributes(reader2, interner));
        ArrayDeque<XmlElementBuilder> stack = new ArrayDeque<XmlElementBuilder>();
        ArrayDeque<XmlElementBuilder> elementPool = new ArrayDeque<XmlElementBuilder>();
        int depth = 1;
        block7: while (reader2.hasNext()) {
            switch (reader2.next()) {
                case 1: {
                    String string2 = reader2.getLocalName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLocalName(...)");
                    String name2 = interner.name(string2);
                    Map<String, String> attributes = XmlDomReader.readAttributes(reader2, interner);
                    if (reader2.isEmptyElement()) {
                        ArrayList<XmlElement> arrayList = current.children;
                        List<XmlElement> list2 = Collections.emptyList();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"emptyList(...)");
                        arrayList.add(new XmlElement(name2, attributes, list2, null));
                        reader2.skipElement();
                        continue block7;
                    }
                    XmlElementBuilder child2 = (XmlElementBuilder)elementPool.pollLast();
                    if (child2 == null) {
                        child2 = new XmlElementBuilder(name2, attributes);
                    } else {
                        child2.name = name2;
                        child2.attributes = attributes;
                    }
                    stack.addLast(current);
                    current = child2;
                    ++depth;
                    continue block7;
                }
                case 2: {
                    List<XmlElement> children = null;
                    if (current.children.isEmpty()) {
                        List<XmlElement> list3 = Collections.emptyList();
                        Intrinsics.checkNotNullExpressionValue(list3, (String)"emptyList(...)");
                        children = list3;
                    } else {
                        XmlElement[] xmlElementArray = current.children.toArray(new XmlElement[current.children.size()]);
                        List<XmlElement> list4 = Arrays.asList(Arrays.copyOf(xmlElementArray, xmlElementArray.length));
                        Intrinsics.checkNotNullExpressionValue(list4, (String)"asList(...)");
                        children = list4;
                        current.children.clear();
                    }
                    XmlElement result2 = new XmlElement(current.name, current.attributes, children, current.content);
                    current.content = null;
                    elementPool.addLast(current);
                    if (--depth == 0) {
                        return result2;
                    }
                    Object e = stack.removeLast();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"removeLast(...)");
                    current = (XmlElementBuilder)e;
                    current.children.add(result2);
                    continue block7;
                }
                case 12: {
                    if (current.content == null) {
                        String string3 = current.name;
                        String string4 = reader2.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
                        current.content = interner.value(string3, string4);
                        continue block7;
                    }
                    XmlElementBuilder xmlElementBuilder = current;
                    xmlElementBuilder.content = xmlElementBuilder.content + reader2.getText();
                    continue block7;
                }
                case 4: {
                    if (reader2.isWhiteSpace()) continue block7;
                    if (current.content == null) {
                        current.content = reader2.getText();
                        continue block7;
                    }
                    XmlElementBuilder xmlElementBuilder = current;
                    xmlElementBuilder.content = xmlElementBuilder.content + reader2.getText();
                    continue block7;
                }
                case 3: 
                case 5: 
                case 6: 
                case 9: {
                    continue block7;
                }
            }
            throw new XMLStreamException("Unexpected XMLStream event " + reader2.getEventType(), reader2.getLocation());
        }
        throw new XMLStreamException("Unexpected end of input: " + reader2.getEventType(), reader2.getLocation());
    }

    private static final Map<String, String> readAttributes(XMLStreamReader2 reader2, XmlInterner interner) {
        int attributeCount = reader2.getAttributeCount();
        switch (attributeCount) {
            case 0: {
                Map<String, String> map2 = Collections.emptyMap();
                Intrinsics.checkNotNullExpressionValue(map2, (String)"emptyMap(...)");
                return map2;
            }
            case 1: {
                String string = reader2.getAttributeLocalName(0);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeLocalName(...)");
                String name2 = interner.name(string);
                String string2 = reader2.getAttributeValue(0);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttributeValue(...)");
                Map<String, String> map3 = Collections.singletonMap(name2, interner.value(name2, string2));
                Intrinsics.checkNotNullExpressionValue(map3, (String)"singletonMap(...)");
                return map3;
            }
        }
        HashMap<String, String> result2 = new HashMap<String, String>(attributeCount);
        for (int i2 = 0; i2 < attributeCount; ++i2) {
            String string = reader2.getAttributeLocalName(i2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeLocalName(...)");
            String name3 = interner.name(string);
            String string3 = reader2.getAttributeValue(i2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAttributeValue(...)");
            result2.put(name3, interner.value(name3, string3));
        }
        return result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final int nextTag(XMLStreamReader2 reader2) {
        int next2;
        block5: while (true) {
            next2 = reader2.next();
            switch (next2) {
                case 3: 
                case 5: 
                case 6: 
                case 11: {
                    continue block5;
                }
                case 4: 
                case 12: {
                    if (!reader2.isWhiteSpace()) throw new WFCException("Received non-all-whitespace CHARACTERS or CDATA event in nextTag().", reader2.getLocation());
                    continue block5;
                }
                case 1: 
                case 2: {
                    return next2;
                }
            }
            break;
        }
        throw new WFCException("Received event " + ErrorConsts.tokenTypeDesc((int)next2) + ", instead of START_ELEMENT or END_ELEMENT.", reader2.getLocation());
    }
}

