/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import org.jetbrains.annotations.NotNull;

public final class NameUtilCore {
    public static int nextWord(@NotNull String text2, int start2) {
        int i2;
        int codePoint;
        if (text2 == null) {
            NameUtilCore.$$$reportNull$$$0(4);
        }
        int ch = text2.codePointAt(start2);
        int chLen = Character.charCount(ch);
        if (!Character.isLetterOrDigit(ch)) {
            return start2 + chLen;
        }
        for (i2 = start2; i2 < text2.length() && Character.isDigit(codePoint = text2.codePointAt(i2)); i2 += Character.charCount(codePoint)) {
        }
        if (i2 > start2) {
            return i2;
        }
        while (i2 < text2.length() && Character.isUpperCase(codePoint = text2.codePointAt(i2))) {
            i2 += Character.charCount(codePoint);
        }
        if (i2 > start2 + chLen) {
            if (i2 == text2.length() || !Character.isLetter(text2.codePointAt(i2))) {
                return i2;
            }
            return i2 - Character.charCount(text2.codePointBefore(i2));
        }
        if (i2 == start2) {
            i2 += chLen;
        }
        while (i2 < text2.length() && Character.isLetter(codePoint = text2.codePointAt(i2)) && !NameUtilCore.isWordStart(text2, i2)) {
            i2 += Character.charCount(codePoint);
        }
        return i2;
    }

    public static boolean isWordStart(String text2, int i2) {
        int prev;
        int cur = text2.codePointAt(i2);
        int n = prev = i2 > 0 ? text2.codePointBefore(i2) : -1;
        if (Character.isUpperCase(cur)) {
            if (Character.isUpperCase(prev)) {
                int nextPos = i2 + Character.charCount(cur);
                return nextPos < text2.length() && Character.isLowerCase(text2.codePointAt(nextPos));
            }
            return true;
        }
        if (Character.isDigit(cur)) {
            return true;
        }
        if (!Character.isLetter(cur)) {
            return false;
        }
        if (Character.isIdeographic(cur)) {
            return true;
        }
        return i2 == 0 || !Character.isLetterOrDigit(text2.charAt(i2 - 1)) || NameUtilCore.isHardCodedWordStart(text2, i2) || NameUtilCore.isKanaBreak(cur, prev);
    }

    private static boolean maybeKana(int codePoint) {
        return codePoint >= 12352 && codePoint <= 13144 || codePoint >= 65382 && codePoint <= 65437;
    }

    private static boolean isKanaBreak(int cur, int prev) {
        if (!NameUtilCore.maybeKana(cur) && !NameUtilCore.maybeKana(prev)) {
            return false;
        }
        Character.UnicodeScript curScript = Character.UnicodeScript.of(cur);
        Character.UnicodeScript prevScript = Character.UnicodeScript.of(prev);
        if (prevScript == curScript) {
            return false;
        }
        return (curScript == Character.UnicodeScript.KATAKANA || curScript == Character.UnicodeScript.HIRAGANA || prevScript == Character.UnicodeScript.KATAKANA || prevScript == Character.UnicodeScript.HIRAGANA) && prevScript != Character.UnicodeScript.COMMON && curScript != Character.UnicodeScript.COMMON;
    }

    private static boolean isHardCodedWordStart(String text2, int i2) {
        return text2.charAt(i2) == 'l' && i2 < text2.length() - 1 && text2.charAt(i2 + 1) == 'n' && (text2.length() == i2 + 2 || NameUtilCore.isWordStart(text2, i2 + 2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/NameUtilCore";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/NameUtilCore";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "splitNameIntoWords";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "nameToWords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "splitNameIntoWords";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addAllWords";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "nextWord";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "nameToWords";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

