/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.ArchiveBackend;
import com.intellij.util.io.PosixFilePermissionsUtil;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.PosixFileAttributeView;
import java.util.function.BiPredicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Compressor
implements Closeable {
    @Nullable
    private @Nullable BiPredicate<? super String, ? super @Nullable Path> myFilter;
    private static final Logger LOG = Logger.getInstance(Compressor.class);

    public final void addFile(@NotNull String entryName, @NotNull Path file) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(2);
        }
        if (file == null) {
            Compressor.$$$reportNull$$$0(3);
        }
        this.addFile(entryName, file, -1L);
    }

    public final void addFile(@NotNull String entryName, @NotNull Path file, long timestamp2) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(4);
        }
        if (file == null) {
            Compressor.$$$reportNull$$$0(5);
        }
        boolean isWindows = ArchiveBackend.Companion.isWindows$intellij_platform_util(file);
        if (this.accept(entryName = Compressor.entryName(entryName), file)) {
            this.addFile(file, Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]), entryName, timestamp2, isWindows);
        }
    }

    public final void addFile(@NotNull String entryName, @NotNull InputStream content2, long timestamp2) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(12);
        }
        if (content2 == null) {
            Compressor.$$$reportNull$$$0(13);
        }
        if (this.accept(entryName = Compressor.entryName(entryName), null)) {
            this.writeFileEntry(entryName, content2, -1L, Compressor.timestamp(timestamp2), 0, null);
        }
    }

    public final void addDirectory(@NotNull String entryName, long timestamp2) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(15);
        }
        if (this.accept(entryName = Compressor.entryName(entryName), null)) {
            this.writeDirectoryEntry(entryName, Compressor.timestamp(timestamp2));
        }
    }

    public final void addDirectory(@NotNull String prefix, @NotNull Path directory) throws IOException {
        if (prefix == null) {
            Compressor.$$$reportNull$$$0(20);
        }
        if (directory == null) {
            Compressor.$$$reportNull$$$0(21);
        }
        this.addDirectory(prefix, directory, -1L);
    }

    public final void addDirectory(@NotNull String prefix, @NotNull Path directory, long timestampInMillis) throws IOException {
        if (prefix == null) {
            Compressor.$$$reportNull$$$0(22);
        }
        if (directory == null) {
            Compressor.$$$reportNull$$$0(23);
        }
        prefix = prefix.isEmpty() ? "" : Compressor.entryName(prefix);
        this.addRecursively(prefix, directory, timestampInMillis);
    }

    protected Compressor() {
    }

    private static String entryName(String name2) {
        String entryName = StringUtil.trimLeading(StringUtil.trimTrailing(name2.replace('\\', '/'), '/'), '/');
        if (entryName.isEmpty()) {
            throw new IllegalArgumentException("Invalid entry name: " + name2);
        }
        return entryName;
    }

    private static long timestamp(long timestamp2) {
        return timestamp2 == -1L ? System.currentTimeMillis() : timestamp2;
    }

    private boolean accept(String entryName, @Nullable Path file) {
        return this.myFilter == null || this.myFilter.test(entryName, file);
    }

    private void addFile(Path file, BasicFileAttributes attrs, String name2, long explicitTimestamp, boolean isWindows) throws IOException {
        try (InputStream source = Files.newInputStream(file, new OpenOption[0]);){
            long timestamp2 = explicitTimestamp == -1L ? attrs.lastModifiedTime().toMillis() : explicitTimestamp;
            String symlinkTarget = attrs.isSymbolicLink() ? Files.readSymbolicLink(file).toString() : null;
            this.writeFileEntry(name2, source, attrs.size(), timestamp2, Compressor.mode(file, isWindows), symlinkTarget);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    private static int mode(Path file, boolean isWindows) throws IOException {
        if (isWindows) {
            DosFileAttributeView attrs = Files.getFileAttributeView(file, DosFileAttributeView.class, new LinkOption[0]);
            if (attrs != null) {
                DosFileAttributes dosAttrs = attrs.readAttributes();
                int mode = 0;
                if (dosAttrs.isReadOnly()) {
                    mode |= 1;
                }
                if (dosAttrs.isHidden()) {
                    mode |= 2;
                }
                return mode;
            }
        } else {
            PosixFileAttributeView attrs = Files.getFileAttributeView(file, PosixFileAttributeView.class, new LinkOption[0]);
            if (attrs != null) {
                return PosixFilePermissionsUtil.toUnixMode(attrs.readAttributes().permissions());
            }
        }
        return 0;
    }

    private void addRecursively(final String prefix, final Path root, final long timestampMs) throws IOException {
        final boolean isWindows = ArchiveBackend.Companion.isWindows$intellij_platform_util(root);
        final boolean traceEnabled = LOG.isTraceEnabled();
        if (traceEnabled) {
            LOG.trace("dir=" + root + " prefix=" + prefix);
        }
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String name2;
                String string = name2 = dir == root ? prefix : this.entryName(dir);
                if (name2.isEmpty()) {
                    return FileVisitResult.CONTINUE;
                }
                if (Compressor.this.accept(name2, dir)) {
                    if (traceEnabled) {
                        LOG.trace("  " + dir + " -> " + name2 + '/');
                    }
                    Compressor.this.writeDirectoryEntry(name2, timestampMs == -1L ? attrs.lastModifiedTime().toMillis() : timestampMs);
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String name2 = this.entryName(file);
                if (Compressor.this.accept(name2, file)) {
                    if (traceEnabled) {
                        LOG.trace("  " + file + " -> " + name2 + (attrs.isSymbolicLink() ? " symlink" : " size=" + attrs.size()));
                    }
                    Compressor.this.addFile(file, attrs, name2, timestampMs, isWindows);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                if (exc instanceof NoSuchFileException) {
                    return FileVisitResult.CONTINUE;
                }
                throw exc;
            }

            private String entryName(Path fileOrDir) {
                String relativeName = Compressor.entryName(root.relativize(fileOrDir).toString());
                return prefix.isEmpty() ? relativeName : prefix + '/' + relativeName;
            }
        });
        LOG.trace(".");
    }

    protected abstract void writeDirectoryEntry(String var1, long var2) throws IOException;

    protected abstract void writeFileEntry(String var1, InputStream var2, long var3, long var5, int var7, @Nullable String var8) throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/Compressor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addFile";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "addDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Zip
    extends Compressor {
        private final ZipOutputStream myStream;

        public Zip(@NotNull Path file) throws IOException {
            if (file == null) {
                Zip.$$$reportNull$$$0(1);
            }
            this(new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]))));
        }

        public Zip(@NotNull OutputStream stream) {
            if (stream == null) {
                Zip.$$$reportNull$$$0(2);
            }
            this(new ZipOutputStream(stream));
        }

        public Zip withLevel(int compressionLevel) {
            this.myStream.setLevel(compressionLevel);
            return this;
        }

        protected Zip(ZipOutputStream stream) {
            this.myStream = stream;
        }

        @Override
        protected void writeDirectoryEntry(String name2, long timestamp2) throws IOException {
            ZipEntry e = new ZipEntry(name2 + '/');
            e.setMethod(0);
            e.setSize(0L);
            e.setCrc(0L);
            e.setTime(timestamp2);
            this.myStream.putNextEntry(e);
            this.myStream.closeEntry();
        }

        @Override
        protected void writeFileEntry(String name2, InputStream source, long length, long timestamp2, int mode, @Nullable String symlinkTarget) throws IOException {
            ZipEntry e = new ZipEntry(name2);
            if (length == 0L) {
                e.setMethod(0);
                e.setSize(0L);
                e.setCrc(0L);
            }
            e.setTime(timestamp2);
            this.myStream.putNextEntry(e);
            if (length != 0L) {
                StreamUtil.copy(source, this.myStream);
            }
            this.myStream.closeEntry();
        }

        @Override
        public void close() throws IOException {
            this.myStream.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stream";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/io/Compressor$Zip";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

