/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.textmate.joni;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.RegexFacade;
import org.jetbrains.plugins.textmate.regex.TextMateByteOffset;
import org.jetbrains.plugins.textmate.regex.TextMateString;
import org.jetbrains.plugins.textmate.regex.TextMateStringImpl;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.joni.exception.JOniException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class JoniRegexFacade
implements RegexFacade {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Regex myRegex;
    private static final long MATCHING_TIMEOUT = Duration.getInWholeNanoseconds-impl((long)DurationKt.toDuration((int)300, (DurationUnit)DurationUnit.MILLISECONDS));
    @NotNull
    private static final Logger LOGGER;

    public JoniRegexFacade(@NotNull Regex myRegex) {
        Intrinsics.checkNotNullParameter((Object)myRegex, (String)"myRegex");
        this.myRegex = myRegex;
    }

    @Override
    @NotNull
    public MatchData match-ZRjI0jQ(@NotNull TextMateString string, int n, boolean matchBeginPosition, boolean matchBeginString, @Nullable Runnable checkCancelledCallback) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (!(string instanceof TextMateStringImpl)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        int gosOffset = matchBeginPosition ? n : Integer.MAX_VALUE;
        int options = matchBeginString ? 0 : 65536;
        Runnable runnable2 = checkCancelledCallback;
        if (runnable2 != null) {
            runnable2.run();
        }
        Matcher matcher = this.myRegex.matcher(((TextMateStringImpl)string).getBytes(), 0, ((TextMateStringImpl)string).getBytes().length, MATCHING_TIMEOUT);
        try {
            int matchIndex = matcher.search(gosOffset, n, ((TextMateStringImpl)string).getBytes().length, options);
            return switch (matchIndex) {
                case -1 -> MatchData.Companion.getNOT_MATCHED();
                case -2 -> {
                    LOGGER.info("Matching regex was interrupted on string: {}", (Object)StringsKt.decodeToString((byte[])((TextMateStringImpl)string).getBytes()));
                    yield MatchData.Companion.getNOT_MATCHED();
                }
                default -> {
                    MatchData var11_11;
                    MatchData it = var11_11 = JoniRegexFacade.Companion.matchData(matcher.getEagerRegion());
                    boolean $i$a$-also-JoniRegexFacade$match$1 = false;
                    JoniRegexFacade.Companion.checkMatched(it, (TextMateStringImpl)string);
                    yield var11_11;
                }
            };
        }
        catch (JOniException e) {
            Object[] objectArray = new Object[]{StringsKt.decodeToString((byte[])((TextMateStringImpl)string).getBytes()), ((Object)((Object)e)).getClass().getName(), e.getMessage()};
            LOGGER.info("Failed to match textmate regex '{}' with {}: {}", objectArray);
            return MatchData.Companion.getNOT_MATCHED();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Object[] objectArray = new Object[]{StringsKt.decodeToString((byte[])((TextMateStringImpl)string).getBytes()), e.getClass().getName(), e.getMessage()};
            LOGGER.info("Failed to match textmate regex '{}' with {}: {}", objectArray);
            return MatchData.Companion.getNOT_MATCHED();
        }
    }

    @Override
    public void close() {
    }

    static {
        Logger logger = LoggerFactory.getLogger(JoniRegexFacade.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
    }

    public static final class Companion {
        private Companion() {
        }

        private final void checkMatched(MatchData match2, TextMateStringImpl string) {
            if (!(!match2.getMatched() || MatchData.byteRange$default(match2, 0, 1, null).getEnd-Esigj34() <= string.getBytes().length)) {
                boolean bl = false;
                String string2 = "Match data out of bounds: " + TextMateByteOffset.toString-impl(MatchData.byteRange$default(match2, 0, 1, null).getStart-Esigj34()) + " > " + string.getBytes().length + "\n" + new String(string.getBytes(), Charsets.UTF_8);
                throw new IllegalStateException(string2.toString());
            }
        }

        private final MatchData matchData(Region matchedRegion) {
            if (matchedRegion != null) {
                int[] offsets = new int[matchedRegion.getNumRegs() * 2];
                int n = matchedRegion.getNumRegs();
                for (int i2 = 0; i2 < n; ++i2) {
                    int startIndex = i2 * 2;
                    offsets[startIndex] = matchedRegion.getBeg(i2);
                    offsets[startIndex + 1] = matchedRegion.getEnd(i2);
                }
                return new MatchData(true, offsets);
            }
            return MatchData.Companion.getNOT_MATCHED();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

