/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.codeStyle.AsciiUtils;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.FList;
import com.intellij.util.text.NameUtilCore;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class TypoTolerantMatcher
extends MinusculeMatcher {
    private final char[] myPattern;
    private final String myHardSeparators;
    private final NameUtil.MatchingCaseSensitivity myOptions;
    private final boolean myHasHumps;
    private final boolean myHasSeparators;
    private final boolean myHasDots;
    private final boolean[] isLowerCase;
    private final boolean[] isUpperCase;
    private final boolean[] isWordSeparator;
    private final char[] toUpperCase;
    private final char[] toLowerCase;
    private final char[] myMeaningfulCharacters;
    private final int myMinNameLength;
    private static final char[][] keyboard = new char[][]{{'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p'}, {'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l'}, {'z', 'x', 'c', 'v', 'b', 'n', 'm'}};

    @VisibleForTesting
    public TypoTolerantMatcher(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity options, @NotNull String hardSeparators) {
        if (pattern == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(0);
        }
        if (options == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(1);
        }
        if (hardSeparators == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(2);
        }
        this.myOptions = options;
        this.myPattern = Strings.trimEnd(pattern, "* ").toCharArray();
        this.myHardSeparators = hardSeparators;
        this.isLowerCase = new boolean[this.myPattern.length];
        this.isUpperCase = new boolean[this.myPattern.length];
        this.isWordSeparator = new boolean[this.myPattern.length];
        this.toUpperCase = new char[this.myPattern.length];
        this.toLowerCase = new char[this.myPattern.length];
        StringBuilder meaningful = new StringBuilder();
        for (int k = 0; k < this.myPattern.length; ++k) {
            char c = this.myPattern[k];
            this.isLowerCase[k] = Character.isLowerCase(c);
            this.isUpperCase[k] = Character.isUpperCase(c);
            this.isWordSeparator[k] = TypoTolerantMatcher.isWordSeparator(c);
            this.toUpperCase[k] = Strings.toUpperCase(c);
            this.toLowerCase[k] = Strings.toLowerCase(c);
            if (this.isWildcard(k)) continue;
            meaningful.append(this.toLowerCase[k]);
            meaningful.append(this.toUpperCase[k]);
        }
        int i2 = 0;
        while (this.isWildcard(i2)) {
            ++i2;
        }
        this.myHasHumps = this.hasFlag(i2 + 1, this.isUpperCase) && this.hasFlag(i2, this.isLowerCase);
        this.myHasSeparators = this.hasFlag(i2, this.isWordSeparator);
        this.myHasDots = this.hasDots(i2);
        this.myMeaningfulCharacters = meaningful.toString().toCharArray();
        this.myMinNameLength = this.myMeaningfulCharacters.length / 2;
    }

    private static boolean isWordSeparator(char c) {
        return Character.isWhitespace(c) || c == '_' || c == '-' || c == ':' || c == '+' || c == '.';
    }

    private static int nextWord(@NotNull String name2, int start2, boolean isAsciiName) {
        if (name2 == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(3);
        }
        if (start2 < name2.length() && Character.isDigit(name2.charAt(start2))) {
            return start2 + 1;
        }
        if (isAsciiName) {
            return AsciiUtils.nextWordAscii(name2, start2);
        }
        return NameUtilCore.nextWord(name2, start2);
    }

    private boolean hasFlag(int start2, boolean[] flags) {
        for (int i2 = start2; i2 < this.myPattern.length; ++i2) {
            if (!flags[i2]) continue;
            return true;
        }
        return false;
    }

    private boolean hasDots(int start2) {
        for (int i2 = start2; i2 < this.myPattern.length; ++i2) {
            if (this.myPattern[i2] != '.') continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static FList<TextRange> prependRange(@NotNull FList<TextRange> ranges, @NotNull Range range) {
        Range head;
        if (ranges == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(4);
        }
        if (range == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(5);
        }
        if ((head = (Range)ranges.getHead()) != null && head.getStartOffset() == range.getEndOffset()) {
            FList<TextRange> fList = ranges.getTail().prepend(new Range(range.getStartOffset(), head.getEndOffset(), range.getErrorCount() + head.getErrorCount()));
            if (fList == null) {
                TypoTolerantMatcher.$$$reportNull$$$0(6);
            }
            return fList;
        }
        FList<TextRange> fList = ranges.prepend(range);
        if (fList == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(7);
        }
        return fList;
    }

    @Override
    public int matchingDegree(@NotNull String name2) {
        if (name2 == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(8);
        }
        return this.matchingDegree(name2, false);
    }

    @Override
    public int matchingDegree(@NotNull String name2, boolean valueStartCaseMatch) {
        if (name2 == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(9);
        }
        return this.matchingDegree(name2, valueStartCaseMatch, this.matchingFragments(name2));
    }

    @Override
    public int matchingDegree(@NotNull String name2, boolean valueStartCaseMatch, @Nullable FList<? extends TextRange> fragments) {
        if (name2 == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(10);
        }
        if (fragments == null) {
            return Integer.MIN_VALUE;
        }
        if (fragments.isEmpty()) {
            return 0;
        }
        TextRange first = fragments.getHead();
        boolean startMatch = first.getStartOffset() == 0;
        boolean valuedStartMatch = startMatch && valueStartCaseMatch;
        int errors = 0;
        int matchingCase = 0;
        int p = -1;
        int skippedHumps = 0;
        int nextHumpStart = 0;
        boolean humpStartMatchedUpperCase = false;
        for (TextRange textRange : fragments) {
            for (int i2 = textRange.getStartOffset(); i2 < textRange.getEndOffset(); ++i2) {
                boolean afterGap = i2 == textRange.getStartOffset() && first != textRange;
                boolean isHumpStart = false;
                while (nextHumpStart <= i2) {
                    if (nextHumpStart == i2) {
                        isHumpStart = true;
                    } else if (afterGap) {
                        ++skippedHumps;
                    }
                    nextHumpStart = TypoTolerantMatcher.nextWord(name2, nextHumpStart, false);
                }
                char c = name2.charAt(i2);
                p = Strings.indexOf(this.myPattern, c, p + 1, this.myPattern.length, false);
                if (p < 0) break;
                if (isHumpStart) {
                    humpStartMatchedUpperCase = c == this.myPattern[p] && this.isUpperCase[p];
                }
                matchingCase += this.evaluateCaseMatching(valuedStartMatch, p, humpStartMatchedUpperCase, i2, afterGap, isHumpStart, c);
            }
            errors = (int)((double)errors + 2000.0 * Math.pow(1.0 * (double)((Range)textRange).getErrorCount() / (double)textRange.getLength(), 2.0));
        }
        int startIndex = first.getStartOffset();
        boolean bl = Strings.indexOfAny(name2, this.myHardSeparators, 0, startIndex) >= 0;
        boolean wordStart = startIndex == 0 || NameUtilCore.isWordStart(name2, startIndex) && !NameUtilCore.isWordStart(name2, startIndex - 1);
        boolean finalMatch = fragments.get(fragments.size() - 1).getEndOffset() == name2.length();
        return (wordStart ? 1000 : 0) + matchingCase - fragments.size() + -skippedHumps * 10 - errors + (bl ? 0 : 2) + (startMatch ? 1 : 0) + (finalMatch ? 1 : 0);
    }

    private int evaluateCaseMatching(boolean valuedStartMatch, int patternIndex, boolean humpStartMatchedUpperCase, int nameIndex, boolean afterGap, boolean isHumpStart, char nameChar) {
        if (afterGap && isHumpStart && this.isLowerCase[patternIndex]) {
            return -10;
        }
        if (nameChar == this.myPattern[patternIndex]) {
            if (this.isUpperCase[patternIndex]) {
                return 50;
            }
            if (nameIndex == 0 && valuedStartMatch) {
                return 150;
            }
            if (isHumpStart) {
                return 1;
            }
        } else {
            if (isHumpStart) {
                return -1;
            }
            if (this.isLowerCase[patternIndex] && humpStartMatchedUpperCase) {
                return -1;
            }
        }
        return 0;
    }

    @Override
    public boolean matches(@NotNull String name2) {
        if (name2 == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(12);
        }
        return this.matchingFragments(name2) != null;
    }

    @Override
    @NotNull
    public String getPattern() {
        return new String(this.myPattern);
    }

    @Override
    @Nullable
    public FList<TextRange> matchingFragments(@NotNull String name2) {
        if (name2 == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(13);
        }
        if (name2.length() < this.myMinNameLength) {
            return null;
        }
        boolean ascii = AsciiUtils.isAscii(name2);
        FList<TextRange> ranges = new Session(name2, false, ascii).matchingFragments();
        if (ranges != null) {
            return ranges;
        }
        return new Session(name2, true, ascii).matchingFragments();
    }

    private boolean isWildcard(int patternIndex) {
        if (patternIndex >= 0 && patternIndex < this.myPattern.length) {
            char pc = this.myPattern[patternIndex];
            return pc == ' ' || pc == '*';
        }
        return false;
    }

    @NonNls
    public String toString() {
        return "TypoTolerantMatcher{myPattern=" + new String(this.myPattern) + ", myOptions=" + String.valueOf((Object)this.myOptions) + "}";
    }

    private static char leftMiss(char aChar) {
        boolean isUpperCase = AsciiUtils.isUpperAscii(aChar);
        char lc = isUpperCase ? AsciiUtils.toLowerAscii(aChar) : aChar;
        for (char[] line : keyboard) {
            for (int j = 0; j < line.length; ++j) {
                char c = line[j];
                if (c != lc) continue;
                if (j > 0) {
                    return isUpperCase ? AsciiUtils.toUpperAscii(line[j - 1]) : line[j - 1];
                }
                return '\u0000';
            }
        }
        return '\u0000';
    }

    private static char rightMiss(char aChar) {
        boolean isUpperCase = AsciiUtils.isUpperAscii(aChar);
        char lc = isUpperCase ? AsciiUtils.toLowerAscii(aChar) : aChar;
        for (char[] line : keyboard) {
            for (int j = 0; j < line.length; ++j) {
                char c = line[j];
                if (c != lc) continue;
                if (j + 1 < line.length) {
                    return isUpperCase ? AsciiUtils.toUpperAscii(line[j + 1]) : line[j + 1];
                }
                return '\u0000';
            }
        }
        return '\u0000';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hardSeparators";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/TypoTolerantMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/TypoTolerantMatcher";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "prependRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "nextWord";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prependRange";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "matchingDegree";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isStartMatch";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "matchingFragments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }

    private static class Range
    extends TextRange {
        private final int myErrorCount;

        Range(int startOffset, int endOffset, int errorCount) {
            super(startOffset, endOffset);
            this.myErrorCount = errorCount;
        }

        public int getErrorCount() {
            return this.myErrorCount;
        }

        @Override
        @NotNull
        public Range shiftRight(int delta) {
            if (delta == 0) {
                Range range = this;
                if (range == null) {
                    Range.$$$reportNull$$$0(0);
                }
                return range;
            }
            return new Range(this.getStartOffset() + delta, this.getEndOffset() + delta, this.getErrorCount());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/TypoTolerantMatcher$Range", "shiftRight"));
        }
    }

    private class Session {
        @NotNull
        private final String myName;
        private final boolean isAsciiName;
        private final boolean myTypoAware;
        private final boolean myAllowTypos;

        Session(String name2, boolean typoAware, boolean ascii) {
            if (name2 == null) {
                Session.$$$reportNull$$$0(0);
            }
            this.myName = name2;
            this.isAsciiName = ascii;
            this.myTypoAware = typoAware;
            this.myAllowTypos = typoAware && ascii;
        }

        private char charAt(int i2, @NotNull ErrorState errorState2) {
            if (errorState2 == null) {
                Session.$$$reportNull$$$0(1);
            }
            return errorState2.affects(i2) ? errorState2.getChar(TypoTolerantMatcher.this.myPattern, i2) : TypoTolerantMatcher.this.myPattern[i2];
        }

        private boolean equalsIgnoreCase(int patternIndex, @NotNull ErrorState errorState2, char nameChar) {
            if (errorState2 == null) {
                Session.$$$reportNull$$$0(2);
            }
            if (errorState2.affects(patternIndex)) {
                char patternChar = errorState2.getChar(TypoTolerantMatcher.this.myPattern, patternIndex);
                return AsciiUtils.toLowerAscii(patternChar) == nameChar || AsciiUtils.toUpperAscii(patternChar) == nameChar;
            }
            return TypoTolerantMatcher.this.toLowerCase[patternIndex] == nameChar || TypoTolerantMatcher.this.toUpperCase[patternIndex] == nameChar;
        }

        private boolean isLowerCase(int i2, @NotNull ErrorState errorState2) {
            if (errorState2 == null) {
                Session.$$$reportNull$$$0(3);
            }
            return errorState2.affects(i2) ? AsciiUtils.isLowerAscii(errorState2.getChar(TypoTolerantMatcher.this.myPattern, i2)) : TypoTolerantMatcher.this.isLowerCase[i2];
        }

        private boolean isUpperCase(int i2, @NotNull ErrorState errorState2) {
            if (errorState2 == null) {
                Session.$$$reportNull$$$0(4);
            }
            return errorState2.affects(i2) ? AsciiUtils.isUpperAscii(errorState2.getChar(TypoTolerantMatcher.this.myPattern, i2)) : TypoTolerantMatcher.this.isUpperCase[i2];
        }

        private boolean isWordSeparator(int i2, @NotNull ErrorState errorState2) {
            if (errorState2 == null) {
                Session.$$$reportNull$$$0(5);
            }
            return errorState2.affects(i2) ? TypoTolerantMatcher.isWordSeparator(errorState2.getChar(TypoTolerantMatcher.this.myPattern, i2)) : TypoTolerantMatcher.this.isWordSeparator[i2];
        }

        private int patternLength(@NotNull ErrorState errorState2) {
            if (errorState2 == null) {
                Session.$$$reportNull$$$0(6);
            }
            return errorState2.length(TypoTolerantMatcher.this.myPattern);
        }

        @Nullable
        public FList<TextRange> matchingFragments() {
            int length = this.myName.length();
            if (length < TypoTolerantMatcher.this.myMinNameLength) {
                return null;
            }
            if (this.myTypoAware && !this.isAsciiName) {
                return null;
            }
            if (!this.myTypoAware) {
                int patternIndex = 0;
                if (TypoTolerantMatcher.this.myMeaningfulCharacters.length > 0) {
                    char c;
                    for (int i2 = 0; i2 < length && ((c = this.myName.charAt(i2)) != TypoTolerantMatcher.this.myMeaningfulCharacters[patternIndex] && c != TypoTolerantMatcher.this.myMeaningfulCharacters[patternIndex + 1] || (patternIndex += 2) < TypoTolerantMatcher.this.myMeaningfulCharacters.length); ++i2) {
                    }
                }
                if (patternIndex < TypoTolerantMatcher.this.myMinNameLength * 2) {
                    return null;
                }
            }
            return this.matchWildcards(0, 0, new ErrorState());
        }

        @Nullable
        private FList<TextRange> matchWildcards(int patternIndex, int nameIndex, @NotNull ErrorState errorState2) {
            if (errorState2 == null) {
                Session.$$$reportNull$$$0(7);
            }
            if (nameIndex < 0) {
                return null;
            }
            if (!TypoTolerantMatcher.this.isWildcard(patternIndex)) {
                if (patternIndex == this.patternLength(errorState2)) {
                    return FList.emptyList();
                }
                return this.matchFragment(patternIndex, nameIndex, errorState2);
            }
            while (TypoTolerantMatcher.this.isWildcard(++patternIndex)) {
            }
            if (patternIndex == this.patternLength(errorState2)) {
                if (this.isTrailingSpacePattern(errorState2) && nameIndex != this.myName.length() && (patternIndex < 2 || !Session.isUpperCaseOrDigit(this.charAt(patternIndex - 2, errorState2)))) {
                    int spaceIndex = this.myName.indexOf(32, nameIndex);
                    if (spaceIndex >= 0) {
                        return FList.singleton(new Range(spaceIndex, spaceIndex + 1, 0));
                    }
                    return null;
                }
                return FList.emptyList();
            }
            FList<TextRange> ranges = this.matchFragment(patternIndex, nameIndex, errorState2);
            if (ranges != null) {
                return ranges;
            }
            return this.matchSkippingWords(patternIndex, nameIndex, true, errorState2);
        }

        private boolean isTrailingSpacePattern(@NotNull ErrorState errorState2) {
            if (errorState2 == null) {
                Session.$$$reportNull$$$0(8);
            }
            return this.isPatternChar(this.patternLength(errorState2) - 1, ' ', errorState2);
        }

        private static boolean isUpperCaseOrDigit(char p) {
            return Character.isUpperCase(p) || Character.isDigit(p);
        }

        @Nullable
        private FList<TextRange> matchSkippingWords(int patternIndex, int nameIndex, boolean allowSpecialChars, @NotNull ErrorState errorState2) {
            FList<TextRange> ranges;
            if (errorState2 == null) {
                Session.$$$reportNull$$$0(9);
            }
            boolean wordStartsOnly = !this.isPatternChar(patternIndex - 1, '*', errorState2) && !this.isWordSeparator(patternIndex, errorState2);
            int maxFoundLength = 0;
            while (true) {
                int fragmentLength;
                if ((nameIndex = this.findNextPatternCharOccurrence(nameIndex, patternIndex, allowSpecialChars, wordStartsOnly, errorState2)) < 0) {
                    return null;
                }
                Fragment fragment = this.seemsLikeFragmentStart(patternIndex, nameIndex, errorState2) ? this.maxMatchingFragment(patternIndex, nameIndex, errorState2) : null;
                if (fragment == null || (fragmentLength = fragment.getLength()) <= maxFoundLength && (nameIndex + fragmentLength != this.myName.length() || !this.isTrailingSpacePattern(errorState2))) continue;
                if (!this.isMiddleMatch(patternIndex, nameIndex, errorState2)) {
                    maxFoundLength = fragmentLength;
                }
                if ((ranges = this.matchInsideFragment(patternIndex, nameIndex, fragment)) != null) break;
            }
            return ranges;
        }

        private int findNextPatternCharOccurrence(int startAt, int patternIndex, boolean allowSpecialChars, boolean wordStartsOnly, @NotNull ErrorState errorState2) {
            int next2;
            if (errorState2 == null) {
                Session.$$$reportNull$$$0(10);
            }
            int n = next2 = wordStartsOnly ? this.indexOfWordStart(patternIndex, startAt, errorState2) : this.indexOfIgnoreCase(startAt + 1, patternIndex, errorState2);
            if (!allowSpecialChars && !TypoTolerantMatcher.this.myHasSeparators && !TypoTolerantMatcher.this.myHasHumps && Strings.containsAnyChar(this.myName, TypoTolerantMatcher.this.myHardSeparators, startAt, next2)) {
                return -1;
            }
            if (!allowSpecialChars && TypoTolerantMatcher.this.myHasDots && !this.isPatternChar(patternIndex - 1, '.', errorState2) && Strings.contains(this.myName, startAt, next2, '.')) {
                return -1;
            }
            return next2;
        }

        private boolean seemsLikeFragmentStart(int patternIndex, int nextOccurrence, @NotNull ErrorState errorState2) {
            if (errorState2 == null) {
                Session.$$$reportNull$$$0(11);
            }
            return !this.isUpperCase(patternIndex, errorState2) || Character.isUpperCase(this.myName.charAt(nextOccurrence)) || NameUtilCore.isWordStart(this.myName, nextOccurrence) || !TypoTolerantMatcher.this.myHasHumps && TypoTolerantMatcher.this.myOptions != NameUtil.MatchingCaseSensitivity.ALL;
        }

        private boolean charEquals(int patternIndex, int nameIndex, boolean isIgnoreCase, boolean allowTypos, @NotNull ErrorState errorState2) {
            char nextNameChar;
            if (errorState2 == null) {
                Session.$$$reportNull$$$0(12);
            }
            char patternChar = this.charAt(patternIndex, errorState2);
            char nameChar = this.myName.charAt(nameIndex);
            int length = this.myName.length();
            if (patternChar == nameChar || isIgnoreCase && this.equalsIgnoreCase(patternIndex, errorState2, nameChar)) {
                return true;
            }
            if (!this.myAllowTypos || !allowTypos) {
                return false;
            }
            if (errorState2.countErrors(0, patternIndex) > 0) {
                return false;
            }
            Error prevError = errorState2.getError(patternIndex - 1);
            if (prevError == SwapError.instance) {
                return false;
            }
            char leftMiss = TypoTolerantMatcher.leftMiss(patternChar);
            if (leftMiss != '\u0000' && (leftMiss == nameChar || isIgnoreCase && (AsciiUtils.toLowerAscii(leftMiss) == nameChar || AsciiUtils.toUpperAscii(leftMiss) == nameChar))) {
                errorState2.addError(patternIndex, new TypoError(leftMiss));
                return true;
            }
            char rightMiss = TypoTolerantMatcher.rightMiss(patternChar);
            if (rightMiss != '\u0000' && (rightMiss == nameChar || isIgnoreCase && (AsciiUtils.toLowerAscii(rightMiss) == nameChar || AsciiUtils.toUpperAscii(rightMiss) == nameChar))) {
                errorState2.addError(patternIndex, new TypoError(rightMiss));
                return true;
            }
            if (this.patternLength(errorState2) > patternIndex + 1 && length > nameIndex + 1) {
                nextNameChar = this.myName.charAt(nameIndex + 1);
                char nextPatternChar = this.charAt(patternIndex + 1, errorState2);
                if ((patternChar == nextNameChar || isIgnoreCase && this.equalsIgnoreCase(patternIndex, errorState2, nextNameChar)) && (nextPatternChar == nameChar || isIgnoreCase && this.equalsIgnoreCase(patternIndex + 1, errorState2, nameChar))) {
                    errorState2.addError(patternIndex, SwapError.instance);
                    return true;
                }
            }
            if (length > nameIndex + 1 && (patternChar == (nextNameChar = this.myName.charAt(nameIndex + 1)) || isIgnoreCase && this.equalsIgnoreCase(patternIndex, errorState2, nextNameChar))) {
                errorState2.addError(patternIndex, new MissError(nameChar));
                return true;
            }
            return false;
        }

        @Nullable
        private FList<TextRange> matchFragment(int patternIndex, int nameIndex, @NotNull ErrorState errorState2) {
            Fragment fragment;
            if (errorState2 == null) {
                Session.$$$reportNull$$$0(13);
            }
            return (fragment = this.maxMatchingFragment(patternIndex, nameIndex, errorState2)) == null ? null : this.matchInsideFragment(patternIndex, nameIndex, fragment);
        }

        @Nullable
        private Fragment maxMatchingFragment(int patternIndex, int nameIndex, @NotNull ErrorState baseErrorState) {
            boolean ignoreCase;
            ErrorState errorState2;
            if (baseErrorState == null) {
                Session.$$$reportNull$$$0(14);
            }
            if (!this.isFirstCharMatching(nameIndex, patternIndex, errorState2 = baseErrorState.deriveFrom(patternIndex))) {
                return null;
            }
            int i2 = 1;
            boolean bl = ignoreCase = TypoTolerantMatcher.this.myOptions != NameUtil.MatchingCaseSensitivity.ALL;
            while (nameIndex + i2 < this.myName.length() && patternIndex + i2 < this.patternLength(errorState2)) {
                if (!this.charEquals(patternIndex + i2, nameIndex + i2, ignoreCase, true, errorState2)) {
                    if (!Character.isDigit(this.charAt(patternIndex + i2, errorState2)) || !Character.isDigit(this.charAt(patternIndex + i2 - 1, errorState2))) break;
                    return null;
                }
                ++i2;
            }
            return new Fragment(i2, errorState2);
        }

        @Nullable
        private FList<TextRange> matchInsideFragment(int patternIndex, int nameIndex, @NotNull Fragment fragment) {
            if (fragment == null) {
                Session.$$$reportNull$$$0(15);
            }
            int minFragment = this.isMiddleMatch(patternIndex, nameIndex, fragment.getErrorState()) ? 3 : 1;
            FList<TextRange> camelHumpRanges = this.improveCamelHumps(patternIndex, nameIndex, fragment.getLength(), minFragment, fragment.getErrorState());
            if (camelHumpRanges != null) {
                return camelHumpRanges;
            }
            return this.findLongestMatchingPrefix(patternIndex, nameIndex, fragment.getLength(), minFragment, fragment.getErrorState());
        }

        private boolean isMiddleMatch(int patternIndex, int nameIndex, @NotNull ErrorState errorState2) {
            if (errorState2 == null) {
                Session.$$$reportNull$$$0(16);
            }
            return this.isPatternChar(patternIndex - 1, '*', errorState2) && !TypoTolerantMatcher.this.isWildcard(patternIndex + 1) && Character.isLetterOrDigit(this.myName.charAt(nameIndex)) && !NameUtilCore.isWordStart(this.myName, nameIndex);
        }

        @Nullable
        private FList<TextRange> findLongestMatchingPrefix(int patternIndex, int nameIndex, int fragmentLength, int minFragment, @NotNull ErrorState errorState2) {
            if (errorState2 == null) {
                Session.$$$reportNull$$$0(17);
            }
            if (patternIndex + fragmentLength >= this.patternLength(errorState2)) {
                int errors = errorState2.countErrors(patternIndex, patternIndex + fragmentLength);
                if (errors == fragmentLength) {
                    return null;
                }
                return FList.singleton(new Range(nameIndex, nameIndex + fragmentLength, errors));
            }
            for (int i2 = fragmentLength; i2 >= minFragment || TypoTolerantMatcher.this.isWildcard(patternIndex + i2); --i2) {
                FList<TextRange> ranges;
                ErrorState derivedErrorState = errorState2.deriveFrom(patternIndex + i2);
                FList<TextRange> fList = ranges = TypoTolerantMatcher.this.isWildcard(patternIndex + i2) ? this.matchWildcards(patternIndex + i2, nameIndex + i2, derivedErrorState) : this.matchSkippingWords(patternIndex + i2, nameIndex + i2, false, derivedErrorState);
                if (ranges == null) continue;
                int errors = errorState2.countErrors(patternIndex, patternIndex + i2);
                if (errors == i2) {
                    return null;
                }
                return TypoTolerantMatcher.prependRange(ranges, new Range(nameIndex, nameIndex + i2, errors));
            }
            return null;
        }

        @Nullable
        private FList<TextRange> improveCamelHumps(int patternIndex, int nameIndex, int maxFragment, int minFragment, @NotNull ErrorState errorState2) {
            if (errorState2 == null) {
                Session.$$$reportNull$$$0(18);
            }
            for (int i2 = minFragment; i2 < maxFragment; ++i2) {
                FList<TextRange> ranges;
                if (!this.isUppercasePatternVsLowercaseNameChar(patternIndex + i2, nameIndex + i2, errorState2) || (ranges = this.findUppercaseMatchFurther(patternIndex + i2, nameIndex + i2, errorState2.deriveFrom(patternIndex + i2))) == null) continue;
                int errors = errorState2.countErrors(patternIndex, patternIndex + i2);
                if (errors == i2) {
                    return null;
                }
                return TypoTolerantMatcher.prependRange(ranges, new Range(nameIndex, nameIndex + i2, errors));
            }
            return null;
        }

        private boolean isUppercasePatternVsLowercaseNameChar(int patternIndex, int nameIndex, @NotNull ErrorState errorState2) {
            if (errorState2 == null) {
                Session.$$$reportNull$$$0(19);
            }
            return this.isUpperCase(patternIndex, errorState2) && !this.charEquals(patternIndex, nameIndex, false, false, errorState2);
        }

        @Nullable
        private FList<TextRange> findUppercaseMatchFurther(int patternIndex, int nameIndex, @NotNull ErrorState errorState2) {
            if (errorState2 == null) {
                Session.$$$reportNull$$$0(20);
            }
            int nextWordStart = this.indexOfWordStart(patternIndex, nameIndex, errorState2);
            return this.matchWildcards(patternIndex, nextWordStart, errorState2.deriveFrom(patternIndex));
        }

        private boolean isFirstCharMatching(int nameIndex, int patternIndex, @NotNull ErrorState errorState2) {
            boolean ignoreCase;
            if (errorState2 == null) {
                Session.$$$reportNull$$$0(21);
            }
            if (nameIndex >= this.myName.length()) {
                return false;
            }
            boolean bl = ignoreCase = TypoTolerantMatcher.this.myOptions != NameUtil.MatchingCaseSensitivity.ALL;
            if (!this.charEquals(patternIndex, nameIndex, ignoreCase, true, errorState2)) {
                return false;
            }
            char patternChar = this.charAt(patternIndex, errorState2);
            return TypoTolerantMatcher.this.myOptions != NameUtil.MatchingCaseSensitivity.FIRST_LETTER || patternIndex != 0 && (patternIndex != 1 || !TypoTolerantMatcher.this.isWildcard(0)) || !Session.hasCase(patternChar) || Character.isUpperCase(patternChar) == Character.isUpperCase(this.myName.charAt(0));
        }

        private static boolean hasCase(char patternChar) {
            return Character.isUpperCase(patternChar) || Character.isLowerCase(patternChar);
        }

        private boolean isPatternChar(int patternIndex, char c, @NotNull ErrorState errorState2) {
            if (errorState2 == null) {
                Session.$$$reportNull$$$0(22);
            }
            return patternIndex >= 0 && patternIndex < this.patternLength(errorState2) && this.charAt(patternIndex, errorState2) == c;
        }

        private int indexOfWordStart(int patternIndex, int startFrom, @NotNull ErrorState errorState2) {
            if (errorState2 == null) {
                Session.$$$reportNull$$$0(23);
            }
            if (startFrom >= this.myName.length() || TypoTolerantMatcher.this.myHasHumps && this.isLowerCase(patternIndex, errorState2) && (patternIndex <= 0 || !this.isWordSeparator(patternIndex - 1, errorState2))) {
                return -1;
            }
            int nextWordStart = startFrom;
            do {
                if ((nextWordStart = TypoTolerantMatcher.nextWord(this.myName, nextWordStart, this.isAsciiName)) < this.myName.length()) continue;
                return -1;
            } while (!this.charEquals(patternIndex, nextWordStart, true, true, errorState2));
            return nextWordStart;
        }

        private int indexOfIgnoreCase(int fromIndex, int patternIndex, @NotNull ErrorState errorState2) {
            if (errorState2 == null) {
                Session.$$$reportNull$$$0(24);
            }
            char p = this.charAt(patternIndex, errorState2);
            if (this.isAsciiName && Strings.isAscii(p)) {
                int i2 = this.indexIgnoringCaseAscii(fromIndex, p);
                if (i2 != -1) {
                    return i2;
                }
                if (this.myAllowTypos) {
                    int leftMiss = this.indexIgnoringCaseAscii(fromIndex, TypoTolerantMatcher.leftMiss(p));
                    if (leftMiss != -1) {
                        return leftMiss;
                    }
                    int rightMiss = this.indexIgnoringCaseAscii(fromIndex, TypoTolerantMatcher.rightMiss(p));
                    if (rightMiss != -1) {
                        return rightMiss;
                    }
                }
                return -1;
            }
            return Strings.indexOfIgnoreCase(this.myName, p, fromIndex);
        }

        private int indexIgnoringCaseAscii(int fromIndex, char p) {
            char pUpper = AsciiUtils.toUpperAscii(p);
            char pLower = AsciiUtils.toLowerAscii(p);
            for (int i2 = fromIndex; i2 < this.myName.length(); ++i2) {
                char c = this.myName.charAt(i2);
                if (c != p && AsciiUtils.toUpperAscii(c) != pUpper && AsciiUtils.toLowerAscii(c) != pLower) continue;
                return i2;
            }
            return -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorState";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseErrorState";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/codeStyle/TypoTolerantMatcher$Session";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "charAt";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "equalsIgnoreCase";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isLowerCase";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isUpperCase";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isWordSeparator";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "patternLength";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchWildcards";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isTrailingSpacePattern";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchSkippingWords";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findNextPatternCharOccurrence";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "seemsLikeFragmentStart";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "charEquals";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchFragment";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "maxMatchingFragment";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchInsideFragment";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMiddleMatch";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findLongestMatchingPrefix";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[2] = "improveCamelHumps";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isUppercasePatternVsLowercaseNameChar";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findUppercaseMatchFurther";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isFirstCharMatching";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPatternChar";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[2] = "indexOfWordStart";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[2] = "indexOfIgnoreCase";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Fragment {
        private final int myLength;
        private final ErrorState myErrorState;

        Fragment(int length, @NotNull ErrorState errorState2) {
            if (errorState2 == null) {
                Fragment.$$$reportNull$$$0(0);
            }
            this.myLength = length;
            this.myErrorState = errorState2;
        }

        int getLength() {
            return this.myLength;
        }

        @NotNull
        ErrorState getErrorState() {
            ErrorState errorState2 = this.myErrorState;
            if (errorState2 == null) {
                Fragment.$$$reportNull$$$0(1);
            }
            return errorState2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorState";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/codeStyle/TypoTolerantMatcher$Fragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/codeStyle/TypoTolerantMatcher$Fragment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private record MissError(char missedChar) implements Error
    {
    }

    private record SwapError() implements Error
    {
        public static final SwapError instance = new SwapError();
    }

    private record TypoError(char correctChar) implements Error
    {
    }

    private static sealed interface Error
    permits TypoError, SwapError, MissError {
    }

    private static class ErrorState {
        @Nullable
        private final ErrorState myBase;
        private final int myDeriveIndex;
        private BitSet myAffected;
        private int myAllAffectedAfter = Integer.MAX_VALUE;
        private List<ErrorWithIndex> myErrors;
        private char[] myPattern;

        ErrorState(@Nullable ErrorState base, int deriveIndex) {
            this.myBase = base;
            this.myDeriveIndex = deriveIndex;
        }

        ErrorState() {
            this(null, 0);
        }

        @NotNull
        ErrorState deriveFrom(int index) {
            return new ErrorState(this, index);
        }

        void addError(int index, @NotNull Error error2) {
            if (error2 == null) {
                ErrorState.$$$reportNull$$$0(0);
            }
            if (this.myErrors == null) {
                this.myErrors = new SmartList<ErrorWithIndex>();
                this.myAffected = new BitSet();
            }
            ErrorWithIndex errorWithIndex = new ErrorWithIndex(index, error2);
            this.myErrors.add(errorWithIndex);
            this.updateAffected(index, error2);
            if (this.myPattern != null) {
                this.myPattern = ErrorState.applyError(this.myPattern, errorWithIndex);
            }
        }

        private void updateAffected(int index, @NotNull Error error2) {
            if (error2 == null) {
                ErrorState.$$$reportNull$$$0(1);
            }
            this.myAffected.set(index);
            if (error2 instanceof SwapError) {
                this.myAffected.set(index + 1);
            } else if (error2 instanceof MissError) {
                this.myAllAffectedAfter = Math.min(index, this.myAllAffectedAfter);
            }
        }

        int countErrors(int start2, int end) {
            int errors = 0;
            if (this.myBase != null && start2 < this.myDeriveIndex) {
                errors += this.myBase.countErrors(start2, this.myDeriveIndex);
            }
            if (this.myErrors != null) {
                for (ErrorWithIndex error2 : this.myErrors) {
                    if (start2 > error2.index || error2.index >= end) continue;
                    ++errors;
                }
            }
            return errors;
        }

        public char getChar(char[] pattern, int index) {
            if (this.myPattern == null) {
                this.myPattern = this.applyErrors((char[])pattern.clone(), Integer.MAX_VALUE);
            }
            return this.myPattern[index];
        }

        private char[] applyErrors(char[] pattern, int upToIndex) {
            if (this.myBase != null) {
                pattern = this.myBase.applyErrors(pattern, Math.min(this.myDeriveIndex, upToIndex));
            }
            if (this.myErrors != null) {
                for (ErrorWithIndex error2 : this.myErrors) {
                    if (error2.index >= upToIndex) continue;
                    pattern = ErrorState.applyError(pattern, error2);
                }
            }
            return pattern;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static char[] applyError(char[] pattern, ErrorWithIndex error2) {
            char missedChar;
            Error error3 = error2.error;
            if (error3 instanceof TypoError) {
                char c;
                char correctChar;
                TypoError typoError = (TypoError)error3;
                pattern[error2.index] = correctChar = (c = typoError.correctChar());
                return pattern;
            }
            if (error2.error instanceof SwapError) {
                int index = error2.index;
                char c = pattern[index];
                pattern[index] = pattern[index + 1];
                pattern[index + 1] = c;
                return pattern;
            }
            error3 = error2.error;
            if (!(error3 instanceof MissError)) return pattern;
            MissError missError = (MissError)error3;
            try {
                char c;
                missedChar = c = missError.missedChar();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return ArrayUtil.insert(pattern, error2.index, missedChar);
        }

        public boolean affects(int index) {
            return this.localAffects(index) || this.myBase != null && this.myBase.affects(index);
        }

        private boolean localAffects(int index) {
            return index >= this.myAllAffectedAfter || this.myAffected != null && this.myAffected.get(index);
        }

        public Error getError(int i2) {
            if (this.myErrors != null && this.myAffected.get(i2)) {
                for (ErrorWithIndex error2 : this.myErrors) {
                    if (error2.index != i2) continue;
                    return error2.error;
                }
            }
            if (this.myBase != null && this.myDeriveIndex > i2) {
                return this.myBase.getError(i2);
            }
            return null;
        }

        private int numMisses(int end) {
            int numMisses = 0;
            if (this.myErrors != null && end > 0) {
                for (ErrorWithIndex error2 : this.myErrors) {
                    if (error2.index >= end || !(error2.error instanceof MissError)) continue;
                    ++numMisses;
                }
            }
            return numMisses + (this.myBase == null ? 0 : this.myBase.numMisses(this.myDeriveIndex));
        }

        public int length(char[] pattern) {
            if (this.myPattern != null) {
                return this.myPattern.length;
            }
            return pattern.length + this.numMisses(Integer.MAX_VALUE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "error";
            objectArray2[1] = "com/intellij/psi/codeStyle/TypoTolerantMatcher$ErrorState";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addError";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateAffected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ErrorWithIndex
    extends Record {
        private final int index;
        private final Error error;

        private ErrorWithIndex(int index, Error error2) {
            this.index = index;
            this.error = error2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ErrorWithIndex.class, "index;error", "index", "error"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ErrorWithIndex.class, "index;error", "index", "error"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ErrorWithIndex.class, "index;error", "index", "error"}, this, o);
        }
    }
}

