/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import org.jetbrains.annotations.NotNull;

public abstract class PerformanceCareRule
implements FUSRule {
    private int failed = 0;

    @Override
    @NotNull
    public final ValidationResultType validate(@NotNull String data2, @NotNull EventContext context2) {
        if (this.failed > 10) {
            return ValidationResultType.PERFORMANCE_ISSUE;
        }
        long startedAt = System.currentTimeMillis();
        ValidationResultType resultType = this.doValidate(data2, context2);
        if (System.currentTimeMillis() - startedAt > 239L) {
            ++this.failed;
        }
        return resultType;
    }

    @NotNull
    protected abstract ValidationResultType doValidate(@NotNull String var1, @NotNull EventContext var2);
}

