/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.StackframeShrinkVerdict;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\ncoroutineTraceStrip.kt\nKotlin\n*S Kotlin\n*F\n+ 1 coroutineTraceStrip.kt\ncom/intellij/diagnostic/CoroutineTraceStripKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1740#2,3:131\n388#2,7:134\n*S KotlinDebug\n*F\n+ 1 coroutineTraceStrip.kt\ncom/intellij/diagnostic/CoroutineTraceStripKt\n*L\n19#1:131,3\n28#1:134,7\n*E\n"})
public final class CoroutineTraceStripKt {
    @NotNull
    private static final Function1<StackTraceElement, StackframeShrinkVerdict> nonLibraryCaseStackframeJudge = CoroutineTraceStripKt::nonLibraryCaseStackframeJudge$lambda$0;
    @NotNull
    private static final Function1<StackTraceElement, StackframeShrinkVerdict> libraryStackframeJudge = CoroutineTraceStripKt::libraryStackframeJudge$lambda$0;

    @ApiStatus.Internal
    @VisibleForTesting
    @NotNull
    public static final List<StackTraceElement> stripCoroutineTrace(@NotNull List<StackTraceElement> trace) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(trace, (String)"trace");
            if (trace.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Iterable $this$all$iv = trace;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    StackTraceElement it = (StackTraceElement)element$iv;
                    boolean bl2 = false;
                    String string = it.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
                    if (StringsKt.startsWith$default((String)string, (String)"kotlinx.coroutines.", (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl ? CoroutineTraceStripKt.stripLibraryOnlyTrace(trace) : CoroutineTraceStripKt.stripTraceWithNonLibraryFrames(trace);
    }

    private static final List<StackTraceElement> stripTraceWithNonLibraryFrames(List<StackTraceElement> trace) {
        int lastNonLibFrameIndex;
        block2: {
            int n;
            List<StackTraceElement> $this$indexOfLast$iv = trace;
            boolean $i$f$indexOfLast = false;
            ListIterator<StackTraceElement> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                StackTraceElement it = iterator$iv.previous();
                boolean bl = false;
                String string = it.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
                if (!(!StringsKt.startsWith$default((String)string, (String)"kotlinx.coroutines.", (boolean)false, (int)2, null))) continue;
                n = iterator$iv.nextIndex();
                break block2;
            }
            n = lastNonLibFrameIndex = -1;
        }
        if (!(lastNonLibFrameIndex != -1)) {
            throw new IllegalStateException("Check failed.");
        }
        return CoroutineTraceStripKt.stripStart(trace.subList(0, lastNonLibFrameIndex + 1), nonLibraryCaseStackframeJudge);
    }

    private static final List<StackTraceElement> stripLibraryOnlyTrace(List<StackTraceElement> trace) {
        return CoroutineTraceStripKt.stripTail(CoroutineTraceStripKt.stripStart(trace, libraryStackframeJudge), libraryStackframeJudge);
    }

    private static final List<StackTraceElement> stripStart(List<StackTraceElement> $this$stripStart, Function1<? super StackTraceElement, ? extends StackframeShrinkVerdict> judge) {
        int startIndex;
        for (startIndex = 0; startIndex < $this$stripStart.size() && judge.invoke((Object)$this$stripStart.get(startIndex)) == StackframeShrinkVerdict.OMIT; ++startIndex) {
        }
        while (startIndex + 1 < $this$stripStart.size() && judge.invoke((Object)$this$stripStart.get(startIndex)) == StackframeShrinkVerdict.SHRINK && judge.invoke((Object)$this$stripStart.get(startIndex + 1)) == StackframeShrinkVerdict.SHRINK) {
            ++startIndex;
        }
        return $this$stripStart.subList(startIndex, $this$stripStart.size());
    }

    private static final List<StackTraceElement> stripTail(List<StackTraceElement> $this$stripTail, Function1<? super StackTraceElement, ? extends StackframeShrinkVerdict> judge) {
        int afterLastIndex = $this$stripTail.size();
        while (0 <= afterLastIndex - 1 && judge.invoke((Object)$this$stripTail.get(afterLastIndex - 1)) == StackframeShrinkVerdict.OMIT) {
            --afterLastIndex;
        }
        return $this$stripTail.subList(0, afterLastIndex);
    }

    private static final String getFullName(StackTraceElement $this$fullName) {
        return $this$fullName.getClassName() + '.' + $this$fullName.getMethodName();
    }

    private static final StackframeShrinkVerdict nonLibraryCaseStackframeJudge$lambda$0(StackTraceElement stackframe) {
        StackframeShrinkVerdict stackframeShrinkVerdict;
        Intrinsics.checkNotNullParameter((Object)stackframe, (String)"stackframe");
        switch (CoroutineTraceStripKt.getFullName(stackframe)) {
            case "com.intellij.util.CoroutineScopeKt$namedChildScope$2$1.invokeSuspend": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "com.intellij.util.CoroutineScopeKt$namedChildScope$2.invokeSuspend": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.KEEP;
                break;
            }
            case "kotlinx.coroutines.flow.StateFlowImpl.collect": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__MergeKt$flattenConcat$1$1.emit": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__MergeKt$flatMapConcat$$inlined$map$1$2.emit": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__LimitKt.emitAbort$FlowKt__LimitKt": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__LimitKt$take$2$1.emit": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            default: {
                stackframeShrinkVerdict = (StackframeShrinkVerdict)((Object)libraryStackframeJudge.invoke((Object)stackframe));
            }
        }
        return stackframeShrinkVerdict;
    }

    private static final StackframeShrinkVerdict libraryStackframeJudge$lambda$0(StackTraceElement stackframe) {
        StackframeShrinkVerdict stackframeShrinkVerdict;
        Intrinsics.checkNotNullParameter((Object)stackframe, (String)"stackframe");
        switch (CoroutineTraceStripKt.getFullName(stackframe)) {
            case "kotlinx.coroutines.channels.AbstractChannel.receiveCatching-JP2dKIU": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.channels.ProduceKt.awaitClose": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.SharedFlowImpl.collect$suspendImpl": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__ChannelsKt.emitAllImpl$FlowKt__ChannelsKt": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__DelayKt$debounceInternal$1.invokeSuspend": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__DelayKt$debounceInternal$1$values$1.invokeSuspend": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__ReduceKt.first": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.CallbackFlowBuilder.collectTo": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.StateFlowImpl.collect": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.SHRINK;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__ShareKt$launchSharing$1.invokeSuspend": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.SHRINK;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__ErrorsKt.catchImpl": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.SHRINK;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__ErrorsKt$retryWhen$$inlined$unsafeFlow$1.collect": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.SHRINK;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__ErrorsKt$catch$$inlined$unsafeFlow$1.collect": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.SHRINK;
                break;
            }
            case "kotlinx.coroutines.flow.internal.FlowCoroutineKt$scopedFlow$1$1.invokeSuspend": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.internal.ChannelFlow$collect$2.invokeSuspend": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.internal.ChannelFlow$collectToFun$1.invokeSuspend": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.internal.CombineKt$combineInternal$2.invokeSuspend": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.SHRINK;
                break;
            }
            case "kotlinx.coroutines.flow.internal.CombineKt$combineInternal$2$1.invokeSuspend": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.SHRINK;
                break;
            }
            case "kotlinx.coroutines.flow.internal.ChannelFlowTransformLatest$flowCollect$3.invokeSuspend": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.SHRINK;
                break;
            }
            case "kotlinx.coroutines.DelayKt.awaitCancellation": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            default: {
                stackframeShrinkVerdict = StackframeShrinkVerdict.KEEP;
            }
        }
        return stackframeShrinkVerdict;
    }
}

